/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.gui.config.OptionsListWidget;
import mcp.mobius.waila.gui.config.value.OptionValue;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class OptionsScreen
extends Screen {
    private final Screen parent;
    private final Runnable saver;
    private final Runnable canceller;
    private OptionsListWidget options;

    public OptionsScreen(Screen parent, Component title, Runnable saver, Runnable canceller) {
        super(title);
        this.parent = parent;
        this.saver = saver;
        this.canceller = canceller;
    }

    public OptionsScreen(Screen parent, String title, Runnable saver, Runnable canceller) {
        this(parent, OptionsListWidget.Entry.makeTitle(title), saver, canceller);
    }

    public OptionsScreen(Screen parent, String title) {
        this(parent, title, null, null);
    }

    protected void m_7856_() {
        this.options = this.getOptions();
        this.m_142416_((GuiEventListener)this.options);
        if (this.saver != null && this.canceller != null) {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 25, 100, 20, (Component)new TranslatableComponent("gui.done"), w -> {
                this.options.save();
                this.saver.run();
                this.f_96541_.m_91152_(this.parent);
            }));
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 5, this.f_96544_ - 25, 100, 20, (Component)new TranslatableComponent("gui.cancel"), w -> {
                this.canceller.run();
                this.f_96541_.m_91152_(this.parent);
            }));
        } else {
            this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 50, this.f_96544_ - 25, 100, 20, (Component)new TranslatableComponent("gui.done"), w -> {
                this.options.save();
                this.f_96541_.m_91152_(this.parent);
            }));
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        OptionValue value;
        this.m_7333_(matrixStack);
        this.options.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        OptionsScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)12, (int)0xFFFFFF);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (mouseY < 32 || mouseY > this.f_96544_ - 32) {
            return;
        }
        OptionsListWidget.Entry entry = (OptionsListWidget.Entry)this.options.m_93511_();
        if (entry instanceof OptionValue && I18n.m_118936_((String)(value = (OptionValue)entry).getDescription())) {
            int valueX = value.getX() + 10;
            String title = value.getTitle().getString();
            if (mouseX < valueX || mouseX > valueX + this.f_96547_.m_92895_(title)) {
                return;
            }
            ArrayList tooltip = Lists.newArrayList((Object[])new FormattedCharSequence[]{value.getTitle().m_7532_()});
            List tooltip2 = this.f_96547_.m_92923_((FormattedText)new TranslatableComponent(value.getDescription()), 200);
            tooltip.addAll(tooltip2);
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 100.0);
            this.m_96617_(matrixStack, tooltip, mouseX, mouseY);
            RenderSystem.m_69482_();
            matrixStack.m_85849_();
        }
    }

    public void m_7333_(PoseStack matrixStack) {
        this.m_96558_(matrixStack, 0);
    }

    public void m_96558_(PoseStack matrixStack, int vOffset) {
        if (this.f_96541_.f_91073_ != null) {
            this.m_93179_(matrixStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
            MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.BackgroundDrawnEvent((Screen)this, matrixStack));
        } else {
            this.m_96626_(vOffset);
        }
    }

    public abstract OptionsListWidget getOptions();

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.options.m_6050_(mouseX, mouseY, delta);
    }

    public void m_7379_() {
        if (this.canceller != null) {
            this.canceller.run();
        }
        super.m_7379_();
    }

    public <T extends GuiEventListener & NarratableEntry> T m_7787_(T widget) {
        return (T)super.m_7787_(widget);
    }
}

