/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.config;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mcp.mobius.waila.gui.OptionsScreen;
import mcp.mobius.waila.gui.config.value.CycleOptionValue;
import mcp.mobius.waila.gui.config.value.InputOptionValue;
import mcp.mobius.waila.gui.config.value.OptionValue;
import mcp.mobius.waila.gui.config.value.SliderOptionValue;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationSupplier;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class OptionsListWidget
extends AbstractSelectionList<Entry> {
    private final OptionsScreen owner;
    private final Runnable diskWriter;
    private static final List<Component> boolNames = Arrays.asList(new TranslatableComponent("gui.yes"), new TranslatableComponent("gui.no"));
    private static final List<Boolean> boolValues = Arrays.asList(Boolean.TRUE, Boolean.FALSE);

    public OptionsListWidget(OptionsScreen owner, Minecraft client, int x, int height, int width, int y, int entryHeight, Runnable diskWriter) {
        super(client, x, height, width, y, entryHeight);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.m_93471_(false);
    }

    public OptionsListWidget(OptionsScreen owner, Minecraft client, int x, int height, int width, int y, int entryHeight) {
        this(owner, client, x, height, width, y, entryHeight, null);
    }

    public int m_5759_() {
        return 250;
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float delta) {
        Entry entry = (Entry)this.m_93412_(mouseX, mouseY);
        this.m_6987_(entry);
        this.m_7733_(matrixStack);
        int scrollPosX = this.m_5756_();
        int j = scrollPosX + 6;
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int rowLeft = this.m_5747_();
        int scrollJump = this.f_93390_ + 4 - (int)this.m_93517_();
        this.m_93451_(matrixStack, rowLeft, scrollJump, mouseX, mouseY, delta);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93096_);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)519);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, -100.0).m_6122_(64, 64, 64, 255).m_7421_(0.0f, (float)this.f_93390_ / 32.0f).m_5752_();
        bufferBuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93390_, -100.0).m_6122_(64, 64, 64, 255).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93390_ / 32.0f).m_5752_();
        bufferBuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), 0.0, -100.0).m_6122_(64, 64, 64, 255).m_7421_((float)this.f_93388_ / 32.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, 0.0, -100.0).m_6122_(64, 64, 64, 255).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93389_, -100.0).m_6122_(64, 64, 64, 255).m_6122_(64, 64, 64, 255).m_7421_(0.0f, (float)this.f_93389_ / 32.0f).m_5752_();
        bufferBuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93389_, -100.0).m_6122_(64, 64, 64, 255).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93389_ / 32.0f).m_5752_();
        bufferBuilder.m_5483_((double)(this.f_93393_ + this.f_93388_), (double)this.f_93391_, -100.0).m_6122_(64, 64, 64, 255).m_7421_((float)this.f_93388_ / 32.0f, (float)this.f_93391_ / 32.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, -100.0).m_6122_(64, 64, 64, 255).m_7421_(0.0f, (float)this.f_93391_ / 32.0f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        bufferBuilder.m_5483_((double)this.f_93393_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)(this.f_93390_ + 4), 0.0).m_6122_(0, 0, 0, 0).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93392_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_7421_(1.0f, 0.0f).m_5752_();
        bufferBuilder.m_5483_((double)this.f_93393_, (double)(this.f_93391_ - 4), 0.0).m_6122_(0, 0, 0, 0).m_7421_(0.0f, 0.0f).m_5752_();
        tessellator.m_85914_();
        int int_8 = Math.max(0, this.m_5775_() - (this.f_93391_ - this.f_93390_ - 4));
        if (int_8 > 0) {
            int int_9 = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
            int_9 = Mth.m_14045_((int)int_9, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
            int int_10 = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - int_9) / int_8 + this.f_93390_;
            if (int_10 < this.f_93390_) {
                int_10 = this.f_93390_;
            }
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            bufferBuilder.m_5483_((double)scrollPosX, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)j, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)j, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)(int_10 + int_9), 0.0).m_6122_(128, 128, 128, 255).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)j, (double)(int_10 + int_9), 0.0).m_6122_(128, 128, 128, 255).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)j, (double)int_10, 0.0).m_6122_(128, 128, 128, 255).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)int_10, 0.0).m_6122_(128, 128, 128, 255).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)(int_10 + int_9 - 1), 0.0).m_6122_(192, 192, 192, 255).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)(j - 1), (double)(int_10 + int_9 - 1), 0.0).m_6122_(192, 192, 192, 255).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_5483_((double)(j - 1), (double)int_10, 0.0).m_6122_(192, 192, 192, 255).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_5483_((double)scrollPosX, (double)int_10, 0.0).m_6122_(192, 192, 192, 255).m_7421_(0.0f, 0.0f).m_5752_();
            tessellator.m_85914_();
        }
        this.m_7415_(matrixStack, mouseX, mouseY);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    public void save() {
        this.m_6702_().stream().filter(e -> e instanceof OptionValue).map(e -> (OptionValue)((Object)e)).forEach(OptionValue::save);
        if (this.diskWriter != null) {
            this.diskWriter.run();
        }
    }

    public void add(Entry entry) {
        AbstractWidget element;
        if (entry instanceof OptionValue && (element = ((OptionValue)entry).getListener()) != null) {
            this.owner.m_7787_(element);
        }
        this.m_7085_(entry);
    }

    public void slider(String optionName, float value, Consumer<Float> setter) {
        this.slider(optionName, value, setter, 0.0f, 1.0f);
    }

    public void slider(String optionName, float value, Consumer<Float> setter, float min, float max) {
        this.add(new SliderOptionValue(optionName, value, setter, min, max));
    }

    public <T> void input(String optionName, T value, Consumer<T> setter, Predicate<String> validator) {
        this.add(new InputOptionValue<T>(optionName, value, setter, validator));
    }

    public <T> void input(String optionName, T value, Consumer<T> setter) {
        this.input(optionName, value, setter, (Predicate<String>)Predicates.alwaysTrue());
    }

    public void choices(String optionName, boolean value, BooleanConsumer setter) {
        this.add(new CycleOptionValue<Boolean>(optionName, boolNames, boolValues, value, (Consumer<Boolean>)setter));
    }

    public <T extends Enum<T>> void choices(String optionName, T value, Consumer<T> setter) {
        List<Enum> values = Arrays.asList((Enum[])value.getClass().getEnumConstants());
        List names = Lists.transform(values, v -> Entry.makeTitle(optionName + "_" + v.name().toLowerCase(Locale.ENGLISH)));
        this.add(new CycleOptionValue<Enum>(optionName, names, values, value, setter));
    }

    public <T> void choices(String optionName, T value, List<T> values, Consumer<T> setter) {
        List names = Lists.transform(values, v -> new TextComponent(v.toString()));
        this.add(new CycleOptionValue<T>(optionName, names, values, value, setter));
    }

    public void m_142291_(NarrationElementOutput output) {
        Entry e = (Entry)this.m_168795_();
        if (e != null) {
            e.m_142291_(output.m_142047_());
            this.m_168790_(output, e);
        } else {
            Entry e1 = (Entry)this.m_7222_();
            if (e1 != null) {
                e1.m_142291_(output.m_142047_());
                this.m_168790_(output, e1);
            }
        }
        output.m_169146_(NarratedElementType.USAGE, (Component)new TranslatableComponent("narration.component_list.usage"));
    }

    public static abstract class Entry
    extends AbstractSelectionList.Entry<Entry>
    implements NarrationSupplier {
        protected final Minecraft client = Minecraft.m_91087_();

        public static Component makeTitle(String key) {
            return new TranslatableComponent(Entry.makeKey(key));
        }

        public static String makeKey(String key) {
            return Util.m_137492_((String)"config", (ResourceLocation)new ResourceLocation("waila", key));
        }

        public abstract void m_6311_(PoseStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);
    }
}

