/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.impl;

import mcp.mobius.waila.api.Accessor;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.overlay.WailaTickHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class ObjectDataCenter {
    public static int rateLimiter = 250;
    private static Accessor accessor;
    private static CompoundTag serverData;
    private static Object lastObject;
    public static long timeLastUpdate;
    public static boolean serverConnected;

    private ObjectDataCenter() {
    }

    public static void set(Accessor accessor) {
        ObjectDataCenter.accessor = accessor;
        if (accessor == null) {
            WailaTickHandler.instance().progressTracker.clear();
            lastObject = null;
            return;
        }
        BlockEntity object = null;
        if (accessor instanceof BlockAccessor) {
            object = ((BlockAccessor)accessor).getBlockEntity();
        } else if (accessor instanceof EntityAccessor) {
            object = ((EntityAccessor)accessor).getEntity();
        }
        if (object != lastObject) {
            WailaTickHandler.instance().progressTracker.clear();
            lastObject = object;
            serverData = null;
            ObjectDataCenter.requestServerData();
        }
    }

    public static Accessor get() {
        return accessor;
    }

    public static void setServerData(CompoundTag tag) {
        serverData = tag;
    }

    public static CompoundTag getServerData() {
        if (accessor instanceof BlockAccessor && ObjectDataCenter.isTagCorrectBlockEntity()) {
            return serverData;
        }
        if (accessor instanceof EntityAccessor && ObjectDataCenter.isTagCorrectEntity()) {
            return serverData;
        }
        return null;
    }

    private static boolean isTagCorrectBlockEntity() {
        if (serverData == null) {
            ObjectDataCenter.requestServerData();
            return false;
        }
        int x = serverData.m_128451_("x");
        int y = serverData.m_128451_("y");
        int z = serverData.m_128451_("z");
        BlockPos hitPos = ((BlockAccessor)accessor).getPosition();
        if (x == hitPos.m_123341_() && y == hitPos.m_123342_() && z == hitPos.m_123343_()) {
            return true;
        }
        ObjectDataCenter.requestServerData();
        return false;
    }

    private static boolean isTagCorrectEntity() {
        if (serverData == null || !serverData.m_128441_("WailaEntityID")) {
            ObjectDataCenter.requestServerData();
            return false;
        }
        int id = serverData.m_128451_("WailaEntityID");
        if (id == ((EntityAccessor)accessor).getEntity().m_142049_()) {
            return true;
        }
        ObjectDataCenter.requestServerData();
        return false;
    }

    public static void requestServerData() {
        timeLastUpdate = System.currentTimeMillis() - (long)rateLimiter;
    }

    public static boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - timeLastUpdate >= time;
    }

    public static void resetTimer() {
        timeLastUpdate = System.currentTimeMillis();
    }

    static {
        timeLastUpdate = System.currentTimeMillis();
    }
}

