/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.impl;

import com.google.common.collect.Sets;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.api.ui.IDisplayHelper;
import mcp.mobius.waila.api.ui.IElementHelper;
import mcp.mobius.waila.impl.HierarchyLookup;
import mcp.mobius.waila.impl.config.ConfigEntry;
import mcp.mobius.waila.impl.config.PluginConfig;
import mcp.mobius.waila.impl.ui.ElementHelper;
import mcp.mobius.waila.overlay.DisplayHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class WailaRegistrar
implements IRegistrar {
    public static final WailaRegistrar INSTANCE = new WailaRegistrar();
    public final HierarchyLookup<IComponentProvider> blockIconProviders;
    public final EnumMap<TooltipPosition, HierarchyLookup<IComponentProvider>> blockComponentProviders;
    public final HierarchyLookup<IServerDataProvider<BlockEntity>> blockDataProviders;
    public final HierarchyLookup<IEntityComponentProvider> entityIconProviders;
    public final EnumMap<TooltipPosition, HierarchyLookup<IEntityComponentProvider>> entityComponentProviders;
    public final HierarchyLookup<IServerDataProvider<Entity>> entityDataProviders;
    public final Set<Block> hideBlocks = Sets.newHashSet();
    public final Set<EntityType<?>> hideEntities = Sets.newHashSet();
    public final Set<Block> pickBlocks = Sets.newHashSet();

    WailaRegistrar() {
        this.blockIconProviders = new HierarchyLookup(Block.class);
        this.blockComponentProviders = new EnumMap(TooltipPosition.class);
        this.blockDataProviders = new HierarchyLookup(BlockEntity.class);
        this.entityIconProviders = new HierarchyLookup(Entity.class);
        this.entityComponentProviders = new EnumMap(TooltipPosition.class);
        this.entityDataProviders = new HierarchyLookup(Entity.class);
        for (TooltipPosition position : TooltipPosition.values()) {
            this.blockComponentProviders.put(position, new HierarchyLookup(Block.class));
            this.entityComponentProviders.put(position, new HierarchyLookup(Entity.class));
        }
    }

    @Override
    public void addConfig(ResourceLocation key, boolean defaultValue) {
        PluginConfig.INSTANCE.addConfig(new ConfigEntry(key, defaultValue, false));
    }

    @Override
    public void addSyncedConfig(ResourceLocation key, boolean defaultValue) {
        PluginConfig.INSTANCE.addConfig(new ConfigEntry(key, defaultValue, true));
    }

    @Override
    public void registerIconProvider(IComponentProvider dataProvider, Class<? extends Block> block) {
        this.blockIconProviders.register(block, dataProvider);
    }

    @Override
    public void registerComponentProvider(IComponentProvider dataProvider, TooltipPosition position, Class<? extends Block> block) {
        this.blockComponentProviders.get((Object)position).register(block, dataProvider);
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<BlockEntity> dataProvider, Class<? extends BlockEntity> block) {
        this.blockDataProviders.register(block, dataProvider);
    }

    @Override
    public void registerIconProvider(IEntityComponentProvider dataProvider, Class<? extends Entity> entity) {
        this.entityIconProviders.register(entity, dataProvider);
    }

    @Override
    public void registerComponentProvider(IEntityComponentProvider dataProvider, TooltipPosition position, Class<? extends Entity> entity) {
        this.entityComponentProviders.get((Object)position).register(entity, dataProvider);
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<Entity> dataProvider, Class<? extends Entity> entity) {
        this.entityDataProviders.register(entity, dataProvider);
    }

    public List<IComponentProvider> getBlockProviders(Block block, TooltipPosition position) {
        return this.blockComponentProviders.get((Object)position).get(block);
    }

    public List<IComponentProvider> getBlockIconProviders(Block block) {
        return this.blockIconProviders.get(block);
    }

    public List<IServerDataProvider<BlockEntity>> getBlockNBTProviders(BlockEntity block) {
        return this.blockDataProviders.get(block);
    }

    public List<IEntityComponentProvider> getEntityProviders(Entity entity, TooltipPosition position) {
        return this.entityComponentProviders.get((Object)position).get(entity);
    }

    public List<IEntityComponentProvider> getEntityIconProviders(Entity entity) {
        return this.entityIconProviders.get(entity);
    }

    public List<IServerDataProvider<Entity>> getEntityNBTProviders(Entity entity) {
        return this.entityDataProviders.get(entity);
    }

    @Override
    public IElementHelper getElementHelper() {
        return ElementHelper.INSTANCE;
    }

    @Override
    public IDisplayHelper getDisplayHelper() {
        return FMLEnvironment.dist.isClient() ? DisplayHelper.INSTANCE : null;
    }

    @Override
    public WailaConfig getConfig() {
        return Waila.CONFIG.get();
    }

    @Override
    public void hideTarget(Block block) {
        this.hideBlocks.add(block);
    }

    @Override
    public void hideTarget(EntityType<?> entityType) {
        this.hideEntities.add(entityType);
    }

    @Override
    public void usePickedResult(Block block) {
        this.pickBlocks.add(block);
    }

    public boolean shouldHide(BlockState state) {
        return this.hideBlocks.contains(state.m_60734_());
    }

    public boolean shouldPick(BlockState state) {
        return this.pickBlocks.contains(state.m_60734_());
    }

    public boolean shouldHide(Entity entity) {
        return this.hideEntities.contains(entity.m_6095_());
    }
}

