/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.impl.config;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.impl.config.ConfigEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;

public class PluginConfig
implements IPluginConfig {
    public static final PluginConfig INSTANCE = new PluginConfig();
    private final Map<ResourceLocation, ConfigEntry> configs = Maps.newHashMap();

    private PluginConfig() {
    }

    public void addConfig(ConfigEntry entry) {
        this.configs.put(entry.getId(), entry);
    }

    @Override
    public Set<ResourceLocation> getKeys(String namespace) {
        return this.getKeys().stream().filter(id -> id.m_135827_().equals(namespace)).collect(Collectors.toSet());
    }

    @Override
    public Set<ResourceLocation> getKeys() {
        return this.configs.keySet();
    }

    @Override
    public boolean get(ResourceLocation key, boolean defaultValue) {
        ConfigEntry entry = this.configs.get(key);
        return entry == null ? defaultValue : entry.getValue();
    }

    public Set<ConfigEntry> getSyncableConfigs() {
        return this.configs.values().stream().filter(ConfigEntry::isSynced).collect(Collectors.toSet());
    }

    public List<String> getNamespaces() {
        return this.configs.keySet().stream().sorted((o1, o2) -> o1.m_135827_().compareToIgnoreCase(o2.m_135827_())).map(ResourceLocation::m_135827_).distinct().collect(Collectors.toList());
    }

    public ConfigEntry getEntry(ResourceLocation key) {
        return this.configs.get(key);
    }

    public void set(ResourceLocation key, boolean value) {
        ConfigEntry entry = this.configs.computeIfAbsent(key, k -> new ConfigEntry((ResourceLocation)k, value, true));
        entry.setValue(value);
    }

    public void reload() {
        File configFile = new File(FMLPaths.CONFIGDIR.get().toFile(), "jade/jade_plugins.json");
        if (!configFile.exists()) {
            this.writeConfig(configFile, true);
        } else {
            Map config;
            try (FileReader reader = new FileReader(configFile);){
                config = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, Map<String, Boolean>>>(){}.getType());
            }
            catch (Exception e) {
                e.printStackTrace();
                config = Maps.newHashMap();
            }
            HashSet found = Sets.newHashSet();
            config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> {
                ResourceLocation id = new ResourceLocation(namespace, path);
                if (!this.configs.containsKey(id)) {
                    return;
                }
                this.set(id, (boolean)value);
                found.add(id);
            }));
            Set<ResourceLocation> allKeys = this.getKeys();
            boolean flag = false;
            for (ResourceLocation id : allKeys) {
                if (found.contains(id)) continue;
                this.set(id, this.getEntry(id).getDefaultValue());
                flag = true;
            }
            if (flag) {
                this.save();
            }
        }
    }

    public void save() {
        File configFile = new File(FMLPaths.CONFIGDIR.get().toFile(), "waila/waila_plugins.json");
        this.writeConfig(configFile, false);
    }

    private void writeConfig(File file, boolean reset) {
        HashMap config = Maps.newHashMap();
        this.configs.values().forEach(e -> {
            Map modConfig = config.computeIfAbsent(e.getId().m_135827_(), k -> Maps.newHashMap());
            if (reset) {
                e.setValue(e.getDefaultValue());
            }
            modConfig.put(e.getId().m_135815_(), e.getValue());
        });
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((Object)config);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(json);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

