/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import mcp.mobius.waila.utils.SmoothChasingValue;
import net.minecraft.resources.ResourceLocation;

public class ProgressTracker {
    private final ListMultimap<ResourceLocation, TrackInfo> map = ArrayListMultimap.create();

    public TrackInfo createInfo(ResourceLocation tag, float progress, float expectedWidth) {
        List infos = this.map.get((Object)tag);
        TrackInfo info = null;
        for (TrackInfo o : infos) {
            if (o.updatedThisTick) continue;
            info = o;
            break;
        }
        if (info == null) {
            info = new TrackInfo();
            info.width = expectedWidth;
            info.progress.set(progress);
            this.map.put((Object)tag, (Object)info);
        }
        info.updatedThisTick = true;
        info.progress.target(progress);
        if (info.width != expectedWidth && (expectedWidth > info.width || ++info.ticksSinceWidthChanged > 10)) {
            info.width = expectedWidth;
            info.ticksSinceWidthChanged = 0;
        }
        return info;
    }

    public void tick() {
        this.map.values().removeIf(info -> !info.updatedThisTick);
        this.map.values().forEach(info -> {
            info.updatedThisTick = false;
        });
    }

    public void clear() {
        this.map.clear();
    }

    public static class TrackInfo {
        private float width;
        private int ticksSinceWidthChanged;
        private boolean updatedThisTick;
        private SmoothChasingValue progress = new SmoothChasingValue();

        public float getWidth() {
            return this.width;
        }

        public float tick(float pTicks) {
            this.progress.tick(pTicks);
            return this.progress.value;
        }
    }
}

