/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.Accessor;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.impl.ObjectDataCenter;
import mcp.mobius.waila.impl.WailaRegistrar;
import mcp.mobius.waila.impl.config.PluginConfig;
import mcp.mobius.waila.impl.ui.FluidStackElement;
import mcp.mobius.waila.impl.ui.ItemStackElement;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;

public class RayTracing {
    public static final RayTracing INSTANCE = new RayTracing();
    private HitResult target = null;
    private Minecraft mc = Minecraft.m_91087_();

    private RayTracing() {
    }

    public void fire() {
        Entity targetEntity;
        Entity viewpoint = this.mc.m_91288_();
        if (viewpoint == null) {
            return;
        }
        if (this.mc.f_91077_ != null && this.mc.f_91077_.m_6662_() == HitResult.Type.ENTITY && this.canBeTarget(targetEntity = ((EntityHitResult)this.mc.f_91077_).m_82443_(), viewpoint)) {
            this.target = this.mc.f_91077_;
            return;
        }
        float reach = this.mc.f_91072_.m_105286_() + Waila.CONFIG.get().getGeneral().getReachDistance();
        this.target = this.rayTrace(viewpoint, reach, this.mc.m_91296_());
    }

    public HitResult getTarget() {
        return this.target;
    }

    public HitResult rayTrace(Entity entity, double playerReach, float partialTicks) {
        BlockState state;
        Vec3 traceEnd;
        Vec3 eyePosition = entity.m_20299_(partialTicks);
        if (this.mc.f_91077_ != null && this.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            traceEnd = this.mc.f_91077_.m_82450_();
            traceEnd = eyePosition.m_82549_(traceEnd.m_82546_(eyePosition).m_82490_(1.01));
        } else {
            Vec3 lookVector = entity.m_20252_(partialTicks);
            traceEnd = eyePosition.m_82520_(lookVector.f_82479_ * playerReach, lookVector.f_82480_ * playerReach, lookVector.f_82481_ * playerReach);
        }
        Level world = entity.f_19853_;
        AABB bound = new AABB(eyePosition, traceEnd);
        Predicate<Entity> predicate = e -> this.canBeTarget((Entity)e, entity);
        EntityHitResult entityResult = RayTracing.getEntityHitResult(world, entity, eyePosition, traceEnd, bound, predicate);
        if (this.mc.f_91077_ != null && this.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 lookVector = entity.m_20252_(partialTicks);
            traceEnd = eyePosition.m_82520_(lookVector.f_82479_ * playerReach, lookVector.f_82480_ * playerReach, lookVector.f_82481_ * playerReach);
        }
        ClipContext.Fluid fluidView = Waila.CONFIG.get().getGeneral().getDisplayFluids();
        ClipContext context = new ClipContext(eyePosition, traceEnd, ClipContext.Block.OUTLINE, fluidView, entity);
        BlockHitResult blockResult = world.m_45547_(context);
        if (entityResult != null && blockResult != null) {
            if (blockResult.m_6662_() == HitResult.Type.BLOCK) {
                double blockDist;
                double entityDist = entityResult.m_82450_().m_82557_(eyePosition);
                if (entityDist < (blockDist = blockResult.m_82450_().m_82557_(eyePosition))) {
                    return entityResult;
                }
            } else {
                return entityResult;
            }
        }
        if (blockResult != null && WailaRegistrar.INSTANCE.shouldHide(state = world.m_8055_(blockResult.m_82425_()))) {
            return null;
        }
        return blockResult;
    }

    private boolean canBeTarget(Entity target, Entity viewEntity) {
        if (target.m_5833_()) {
            return false;
        }
        if (target == viewEntity.m_20202_()) {
            return false;
        }
        if (viewEntity instanceof Player ? target.m_20177_((Player)viewEntity) : target.m_20145_()) {
            return false;
        }
        return !WailaRegistrar.INSTANCE.shouldHide(target);
    }

    @Nullable
    public static EntityHitResult getEntityHitResult(Level worldIn, Entity projectile, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : worldIn.m_6249_(projectile, boundingBox, filter)) {
            double d1;
            Optional optional;
            AABB axisalignedbb = entity1.m_142469_();
            if (axisalignedbb.m_82309_() < 0.3) {
                axisalignedbb = axisalignedbb.m_82400_(0.3);
            }
            if (!(optional = axisalignedbb.m_82371_(startVec, endVec)).isPresent() || !((d1 = startVec.m_82557_((Vec3)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity);
    }

    public IElement getIcon() {
        Accessor accessor = ObjectDataCenter.get();
        if (accessor == null) {
            return null;
        }
        IElement icon = null;
        if (accessor instanceof EntityAccessor) {
            Entity entity = ((EntityAccessor)accessor).getEntity();
            if (entity instanceof ItemEntity) {
                icon = ItemStackElement.of(((ItemEntity)entity).m_32055_());
            } else {
                ItemStack stack = entity.getPickedResult(accessor.getHitResult());
                if (!(stack.m_41720_() instanceof SpawnEggItem) || !(entity instanceof LivingEntity)) {
                    icon = ItemStackElement.of(stack);
                }
            }
            for (IEntityComponentProvider provider : WailaRegistrar.INSTANCE.getEntityIconProviders(entity)) {
                IElement element = provider.getIcon((EntityAccessor)accessor, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmpty(element)) continue;
                icon = element;
            }
        } else if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            Level world = blockAccessor.getLevel();
            BlockPos pos = blockAccessor.getHitResult().m_82425_();
            BlockState state = blockAccessor.getBlockState();
            if (state.m_60795_()) {
                return null;
            }
            ItemStack pick = state.m_60734_().getPickBlock(state, this.target, (BlockGetter)world, pos, (Player)this.mc.f_91074_);
            if (!pick.m_41619_()) {
                icon = ItemStackElement.of(pick);
            }
            if (RayTracing.isEmpty(icon) && state.m_60734_().m_5456_() != Items.f_41852_) {
                icon = ItemStackElement.of(new ItemStack((ItemLike)state.m_60734_()));
            }
            if (RayTracing.isEmpty(icon) && state.m_60734_() instanceof LiquidBlock) {
                LiquidBlock block = (LiquidBlock)state.m_60734_();
                FlowingFluid fluid = block.getFluid();
                FluidStack fluidStack = new FluidStack((Fluid)fluid, 1);
                icon = new FluidStackElement(fluidStack);
            }
            for (IComponentProvider provider : WailaRegistrar.INSTANCE.getBlockIconProviders(state.m_60734_())) {
                IElement element = provider.getIcon(blockAccessor, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmpty(element)) continue;
                icon = element;
            }
        }
        if (RayTracing.isEmpty(icon)) {
            return null;
        }
        return icon;
    }

    private static boolean isEmpty(IElement element) {
        return element == null || element == ItemStackElement.EMPTY;
    }
}

