/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.utils;

import com.google.common.collect.Multimap;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.impl.HierarchyLookup;
import mcp.mobius.waila.impl.WailaRegistrar;

public class DumpGenerator {
    public static String generateInfoDump() {
        StringBuilder builder = new StringBuilder("# Waila Handler Dump");
        builder.append("\n## Block");
        DumpGenerator.createSection(builder, "Icon Providers", WailaRegistrar.INSTANCE.blockIconProviders);
        DumpGenerator.createSection(builder, "Head Providers", WailaRegistrar.INSTANCE.blockComponentProviders.get((Object)TooltipPosition.HEAD));
        DumpGenerator.createSection(builder, "Body Providers", WailaRegistrar.INSTANCE.blockComponentProviders.get((Object)TooltipPosition.BODY));
        DumpGenerator.createSection(builder, "Tail Providers", WailaRegistrar.INSTANCE.blockComponentProviders.get((Object)TooltipPosition.TAIL));
        DumpGenerator.createSection(builder, "Data Providers", WailaRegistrar.INSTANCE.blockDataProviders);
        builder.append("\n## Entity");
        DumpGenerator.createSection(builder, "Icon Providers", WailaRegistrar.INSTANCE.entityIconProviders);
        DumpGenerator.createSection(builder, "Head Providers", WailaRegistrar.INSTANCE.entityComponentProviders.get((Object)TooltipPosition.HEAD));
        DumpGenerator.createSection(builder, "Body Providers", WailaRegistrar.INSTANCE.entityComponentProviders.get((Object)TooltipPosition.BODY));
        DumpGenerator.createSection(builder, "Tail Providers", WailaRegistrar.INSTANCE.entityComponentProviders.get((Object)TooltipPosition.TAIL));
        DumpGenerator.createSection(builder, "Data Providers", WailaRegistrar.INSTANCE.entityDataProviders);
        return builder.toString();
    }

    private static void createSection(StringBuilder builder, String subsection, HierarchyLookup<?> lookup) {
        Multimap<Class<?>, ?> multimap = lookup.getObjects();
        if (multimap.isEmpty()) {
            return;
        }
        builder.append("\n### ").append(subsection);
        multimap.asMap().forEach((k, v) -> {
            builder.append("\n\n#### ").append(k.getName());
            v.stream().distinct().map(o -> o.getClass().getName()).sorted(String::compareToIgnoreCase).forEachOrdered(s -> builder.append("\n* ").append((String)s));
        });
        builder.append("\n\n");
    }
}

