/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import mcp.mobius.waila.impl.ui.SubTextElement;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.Tags;
import snownee.jade.VanillaPlugin;

public class HarvestToolProvider
implements IComponentProvider,
ResourceManagerReloadListener {
    public static final HarvestToolProvider INSTANCE = new HarvestToolProvider();
    public static final Cache<BlockState, ImmutableList<TestCase>> resultCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    public static final List<TestCase> testTools = Lists.newLinkedList();
    private static final Component UNBREAKABLE_TEXT = new TranslatableComponent("jade.harvest_tool.unbreakable").m_130940_(ChatFormatting.DARK_RED);
    private static final Vec2 ITEM_SIZE = new Vec2(10.0f, 0.0f);
    private static final TestCase SHEARS;

    @Nullable
    public static ImmutableList<TestCase> getTool(BlockState state, Level world, BlockPos pos) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (TestCase testCase : testTools) {
            if (testCase == SHEARS && state.m_60734_() instanceof IForgeShearable) {
                list.add((Object)testCase);
                continue;
            }
            if (testCase.blocks == null) {
                if (testCase.stack.m_41619_() || !testCase.stack.m_41735_(state)) continue;
                list.add((Object)testCase);
                continue;
            }
            if (!state.m_60620_(testCase.blocks)) continue;
            list.add((Object)testCase);
        }
        return list.build();
    }

    public static synchronized TestCase registerTool(ItemStack stack, String name, @Nullable Tag<Block> toolType) {
        TestCase testCase = new TestCase(stack, name, toolType);
        testTools.add(testCase);
        return testCase;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Player player = accessor.getPlayer();
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        BlockState state = accessor.getBlockState();
        float hardness = state.m_60800_((BlockGetter)accessor.getLevel(), accessor.getPosition());
        if (hardness < 0.0f) {
            if (accessor.getTooltipPosition() == TooltipPosition.BODY) {
                tooltip.add(UNBREAKABLE_TEXT);
            }
            return;
        }
        boolean newLine = config.get(VanillaPlugin.HARVEST_TOOL_NEW_LINE);
        if (!newLine && accessor.getTooltipPosition() != TooltipPosition.TAIL) {
            return;
        }
        if (newLine && accessor.getTooltipPosition() != TooltipPosition.BODY) {
            return;
        }
        List<IElement> elements = this.getText(accessor, config, tooltip.getElementHelper());
        if (elements.isEmpty()) {
            return;
        }
        if (newLine) {
            tooltip.add(elements);
        } else {
            elements.forEach(e -> e.align(IElement.Align.RIGHT));
            tooltip.append(0, elements);
        }
    }

    public List<IElement> getText(BlockAccessor accessor, IPluginConfig config, IElementHelper helper) {
        if (!config.get(VanillaPlugin.HARVEST_TOOL)) {
            return Collections.EMPTY_LIST;
        }
        BlockState state = accessor.getBlockState();
        List results = Collections.EMPTY_LIST;
        try {
            results = (List)resultCache.get((Object)state, () -> HarvestToolProvider.getTool(state, accessor.getLevel(), accessor.getPosition()));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (results.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (!state.m_60834_() && !config.get(VanillaPlugin.EFFECTIVE_TOOL)) {
            return Collections.EMPTY_LIST;
        }
        int offsetY = 0;
        if (!config.get(VanillaPlugin.HARVEST_TOOL_NEW_LINE)) {
            offsetY = -3;
        }
        ArrayList elements = Lists.newArrayList();
        for (TestCase result : results) {
            ItemStack stack = ItemStack.f_41583_;
            if (result.blocks == null) {
                stack = result.stack;
            } else {
                for (ItemStack tool : result.tools) {
                    if (!tool.m_41735_(state)) continue;
                    stack = tool;
                    break;
                }
            }
            if (stack.m_41619_()) continue;
            elements.add(helper.item(stack, 0.75f).translate(new Vec2(-5.0f, (float)offsetY)).size(ITEM_SIZE));
        }
        if (!elements.isEmpty()) {
            elements.add(0, helper.spacer(5, 0));
            ItemStack held = accessor.getPlayer().m_21205_();
            boolean canHarvest = held.m_41735_(state);
            if (state.m_60734_() instanceof IForgeShearable && held.m_150922_((Tag)Tags.Items.SHEARS)) {
                canHarvest = true;
            }
            if (state.m_60834_()) {
                String sub = canHarvest ? "\u00a7a\u2714" : "\u00a74\u2715";
                elements.add(new SubTextElement(sub).translate(new Vec2(-6.0f, (float)(7 + offsetY))));
            } else if (canHarvest) {
                elements.add(new SubTextElement("\u00a7a\u2714").translate(new Vec2(-6.0f, (float)(7 + offsetY))));
            }
        }
        return elements;
    }

    public void m_6213_(ResourceManager resourceManager) {
        resultCache.invalidateAll();
    }

    public static void init() {
    }

    static {
        HarvestToolProvider.registerTool(new ItemStack((ItemLike)Items.f_42422_), "pickaxe", (Tag<Block>)BlockTags.f_144282_).addTool(Items.f_42427_).addTool(Items.f_42385_).addTool(Items.f_42390_).addTool(Items.f_42395_);
        HarvestToolProvider.registerTool(new ItemStack((ItemLike)Items.f_42423_), "axe", (Tag<Block>)BlockTags.f_144280_).addTool(Items.f_42428_).addTool(Items.f_42386_).addTool(Items.f_42391_).addTool(Items.f_42396_);
        HarvestToolProvider.registerTool(new ItemStack((ItemLike)Items.f_42421_), "shovel", (Tag<Block>)BlockTags.f_144283_).addTool(Items.f_42426_).addTool(Items.f_42384_).addTool(Items.f_42389_).addTool(Items.f_42394_);
        HarvestToolProvider.registerTool(new ItemStack((ItemLike)Items.f_42424_), "hoe", (Tag<Block>)BlockTags.f_144281_).addTool(Items.f_42429_).addTool(Items.f_42387_).addTool(Items.f_42392_).addTool(Items.f_42397_);
        SHEARS = HarvestToolProvider.registerTool(new ItemStack((ItemLike)Items.f_42574_), "shears", null);
    }

    public static class TestCase {
        private ItemStack stack;
        public final String name;
        private final Tag<Block> blocks;
        private final List<ItemStack> tools = Lists.newArrayList();

        public TestCase(ItemStack stack, String name, @Nullable Tag<Block> blocks) {
            this.stack = stack;
            this.name = name;
            this.blocks = blocks;
            this.addTool(stack);
        }

        public TestCase addTool(Item tool) {
            return this.addTool(new ItemStack((ItemLike)tool));
        }

        public TestCase addTool(ItemStack stack) {
            if (!stack.m_41619_()) {
                this.tools.add(stack);
            }
            return this;
        }
    }
}

