/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.event;

import lotr.common.config.LOTRConfig;
import lotr.common.dim.LOTRDimensionType;
import lotr.common.init.LOTRBiomes;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;

public class SunGlare {
    private float sunGlare;
    private float prevSunGlare;
    private static final float MAX_OVERSATURATED_GLARE = 1.4f;
    private static final float MIN_BRIGHTNESS_FOR_GLARE = 0.45f;
    private float glareYellowness;
    private static final float BRIGHTNESS_YELLOW_THRESHOLD = 0.75f;
    private static final float BRIGHTNESS_YELLOW_FULL = 0.6f;
    private static final float[] NORMAL_RGB = new float[]{1.0f, 1.0f, 1.0f};
    private static final float[] YELLOW_RGB = new float[]{1.0f, 0.6f, 0.0f};

    public void update(ClientWorld world, Entity viewer) {
        if (((Boolean)LOTRConfig.CLIENT.sunGlare.get()).booleanValue() && world.func_230315_m_() instanceof LOTRDimensionType && world.func_230315_m_().func_218272_d()) {
            float celestialAngle;
            this.prevSunGlare = this.sunGlare;
            float renderTick = 1.0f;
            RayTraceResult look = this.getBlockRayTrace(viewer, 10000.0);
            boolean lookingAtSky = look.func_216346_c() == RayTraceResult.Type.MISS;
            Biome biome = world.func_226691_t_(viewer.func_233580_cy_());
            boolean biomeHasSun = LOTRBiomes.getWrapperFor(biome, (IWorld)world).hasSkyFeatures();
            float sunPitch = celestialAngle = world.func_242415_f(renderTick) * 360.0f - 90.0f;
            float sunYaw = 90.0f;
            float yc = MathHelper.func_76134_b((float)((float)Math.toRadians(-sunYaw - 180.0f)));
            float ys = MathHelper.func_76126_a((float)((float)Math.toRadians(-sunYaw - 180.0f)));
            float pc = -MathHelper.func_76134_b((float)((float)Math.toRadians(-sunPitch)));
            float ps = MathHelper.func_76126_a((float)((float)Math.toRadians(-sunPitch)));
            Vector3d sunVec = new Vector3d((double)(ys * pc), (double)ps, (double)(yc * pc));
            Vector3d lookVec = viewer.func_70676_i(renderTick);
            double cos = lookVec.func_72430_b(sunVec) / (lookVec.func_72433_c() * sunVec.func_72433_c());
            float cosThreshold = 0.97f;
            float cQ = ((float)cos - 0.97f) / 0.029999971f;
            cQ = Math.max(cQ, 0.0f);
            float brightness = world.func_228326_g_(renderTick);
            float bQ = (brightness - 0.45f) / 0.55f;
            bQ = Math.max(bQ, 0.0f);
            float brightnessForYellowness = this.getSunBrightnessBasedOnlyOnAngle(world, renderTick);
            this.glareYellowness = (0.75f - brightnessForYellowness) / 0.14999998f;
            this.glareYellowness = MathHelper.func_76131_a((float)this.glareYellowness, (float)0.0f, (float)1.0f);
            float maxGlareNow = cQ * bQ;
            float maxGlareNowWithOversaturation = maxGlareNow * 1.4f;
            if (maxGlareNow > 0.0f && lookingAtSky && !world.func_72896_J() && biomeHasSun) {
                if (this.sunGlare < maxGlareNowWithOversaturation) {
                    this.sunGlare += 0.1f * maxGlareNow;
                    this.sunGlare = Math.min(this.sunGlare, maxGlareNowWithOversaturation);
                } else if (this.sunGlare > maxGlareNowWithOversaturation) {
                    this.sunGlare -= 0.02f;
                    this.sunGlare = Math.max(this.sunGlare, maxGlareNowWithOversaturation);
                }
            } else {
                if (this.sunGlare > 0.0f) {
                    this.sunGlare -= 0.02f;
                }
                this.sunGlare = Math.max(this.sunGlare, 0.0f);
            }
        } else {
            this.reset();
        }
    }

    private float getSunBrightnessBasedOnlyOnAngle(ClientWorld world, float partialTicks) {
        float f = world.func_242415_f(partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        return f1 * 0.8f + 0.2f;
    }

    private RayTraceResult getBlockRayTrace(Entity viewer, double distance) {
        return viewer.func_213324_a(distance, 1.0f, true);
    }

    public void reset() {
        this.sunGlare = 0.0f;
        this.prevSunGlare = 0.0f;
        this.glareYellowness = 0.0f;
    }

    public float getGlareBrightness(float partialTick) {
        float lerp = this.prevSunGlare + (this.sunGlare - this.prevSunGlare) * partialTick;
        return Math.min(lerp, 1.0f);
    }

    public float[] getGlareColorRGB() {
        float[] rgb = new float[3];
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = MathHelper.func_219799_g((float)this.glareYellowness, (float)NORMAL_RGB[i], (float)YELLOW_RGB[i]);
        }
        return rgb;
    }
}

