/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import lotr.common.LOTRLog;
import net.minecraft.client.resources.I18n;

public class AlignmentFormatter {
    private static final DecimalFormat ALIGNMENT_FORMAT = new DecimalFormat(",##0.0");
    private static final DecimalFormat CONQUEST_FORMAT = new DecimalFormat(",##0.00");
    private static final DecimalFormatSymbols ALIGNMENT_FORMAT_SYMBOLS = new DecimalFormatSymbols();

    public static String formatAlignForDisplay(float alignment) {
        return AlignmentFormatter.formatAlignForDisplay(alignment, ALIGNMENT_FORMAT, true);
    }

    public static String formatConqForDisplay(float conq, boolean prefixPlus) {
        return AlignmentFormatter.formatAlignForDisplay(conq, CONQUEST_FORMAT, prefixPlus);
    }

    private static String formatAlignForDisplay(float alignment, DecimalFormat dFormat, boolean prefixPlus) {
        AlignmentFormatter.setupDecimalFormat(dFormat);
        String s = dFormat.format(alignment);
        if (prefixPlus && !s.startsWith("-")) {
            s = "+" + s;
        }
        return s;
    }

    private static DecimalFormat setupDecimalFormat(DecimalFormat dFormat) {
        String groupSeparator;
        char decimalSeparatorChar = '.';
        char groupSeparatorChar = ',';
        String decimalSeparator = I18n.func_135052_a((String)"gui.lotr.alignment.decimal_separator_char", (Object[])new Object[0]);
        if (decimalSeparator.length() == 1) {
            decimalSeparatorChar = decimalSeparator.charAt(0);
        }
        if ((groupSeparator = I18n.func_135052_a((String)"gui.lotr.alignment.group_separator_char", (Object[])new Object[0])).length() == 1) {
            groupSeparatorChar = groupSeparator.charAt(0);
        }
        ALIGNMENT_FORMAT_SYMBOLS.setDecimalSeparator(decimalSeparatorChar);
        ALIGNMENT_FORMAT_SYMBOLS.setGroupingSeparator(groupSeparatorChar);
        dFormat.setDecimalFormatSymbols(ALIGNMENT_FORMAT_SYMBOLS);
        return dFormat;
    }

    public static float parseDisplayedAlign(String alignmentText) {
        DecimalFormat dFormat = ALIGNMENT_FORMAT;
        AlignmentFormatter.setupDecimalFormat(dFormat);
        if (alignmentText.startsWith("+")) {
            alignmentText = alignmentText.substring("+".length());
        }
        try {
            return dFormat.parse(alignmentText).floatValue();
        }
        catch (ParseException e) {
            LOTRLog.error("Could not parse alignment value from display string %s", alignmentText);
            e.printStackTrace();
            return 0.0f;
        }
    }
}

