/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import lotr.client.LOTRClientProxy;
import lotr.client.LOTRClientUtil;
import lotr.client.gui.BasicIngameScreen;
import lotr.client.gui.MiddleEarthMapRenderer;
import lotr.client.gui.MiddleEarthMapScreen;
import lotr.common.init.LOTRSoundEvents;
import lotr.common.util.LOTRUtil;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.Waypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FastTravelScreen
extends BasicIngameScreen {
    private MiddleEarthMapScreen mapGui;
    private MiddleEarthMapRenderer mapRenderer;
    private int tickCounter;
    private Waypoint theWaypoint;
    private int startX;
    private int startZ;
    private boolean chunkLoaded = false;
    private boolean playedSound = false;
    private static final ResourceLocation FAST_TRAVEL_QUOTES = new ResourceLocation("lotr", "quotes/fast_travel");
    private ITextComponent loadingQuote;
    private final float zoomBase;
    private final double mapScaleFactor;
    private float currentZoom;
    private float prevZoom;
    private static final float ZOOM_IN_AMOUNT = 0.5f;
    private static final float ZOOM_INCREMENT = 0.008333334f;
    private boolean finishedZoomIn = false;
    private double mapSpeed;
    private double mapVelX;
    private double mapVelY;
    private static final float MAP_SPEED_MAX = 2.0f;
    private static final float MAP_SPEED_INCREMENT = 0.01f;
    private static final float MAP_ACCEL = 0.2f;
    private boolean reachedWP = false;
    private static final float REACHED_WP_DISTANCE = 1.0f;

    public FastTravelScreen(Waypoint waypoint, int x, int z) {
        super((ITextComponent)new StringTextComponent("TODO - FAST TRAVEL"));
        this.theWaypoint = waypoint;
        this.startX = x;
        this.startZ = z;
        this.loadingQuote = LOTRClientProxy.QUOTE_LIST_LOADER.getRandomQuoteComponent(FAST_TRAVEL_QUOTES);
        this.mapGui = new MiddleEarthMapScreen();
        this.mapRenderer = new MiddleEarthMapRenderer(true);
        MapSettings mapSettings = MapSettingsManager.clientInstance().getCurrentLoadedMap();
        this.mapRenderer.setInitialPosition(mapSettings.worldToMapX_frac(this.startX), mapSettings.worldToMapZ_frac(this.startZ));
        double dx = this.theWaypoint.getMapX() - this.mapRenderer.getMapX();
        double dy = this.theWaypoint.getMapZ() - this.mapRenderer.getMapY();
        double distSq = dx * dx + dy * dy;
        double dist = Math.sqrt(distSq);
        this.mapScaleFactor = dist / 100.0;
        this.zoomBase = -((float)(Math.log(this.mapScaleFactor * (double)0.3f) / Math.log(2.0)));
        this.currentZoom = this.prevZoom = this.zoomBase + 0.5f;
        this.mapRenderer.setStableZoom((float)Math.pow(2.0, this.zoomBase));
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (!this.chunkLoaded && LOTRClientUtil.doesClientChunkExist((World)this.field_230706_i_.field_71441_e, this.theWaypoint.getWorldX(), this.theWaypoint.getWorldZ())) {
            this.chunkLoaded = true;
        }
        if (!this.playedSound) {
            this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_239530_b_((SoundEvent)LOTRSoundEvents.FAST_TRAVEL));
            this.playedSound = true;
        }
        this.mapRenderer.tick();
        ++this.tickCounter;
        this.prevZoom = this.currentZoom;
        if (!this.reachedWP) {
            double dy;
            double dx = this.theWaypoint.getMapX() - this.mapRenderer.getMapX();
            double distSq = dx * dx + (dy = this.theWaypoint.getMapZ() - this.mapRenderer.getMapY()) * dy;
            double dist = Math.sqrt(distSq);
            if (dist <= 1.0 * this.mapScaleFactor) {
                this.reachedWP = true;
                this.mapSpeed = 0.0;
                this.mapVelX = 0.0;
                this.mapVelY = 0.0;
            } else {
                this.mapSpeed += (double)0.01f;
                this.mapSpeed = Math.min(this.mapSpeed, 2.0);
                double vXNew = dx / dist * this.mapSpeed;
                double vYNew = dy / dist * this.mapSpeed;
                double a = 0.2f;
                this.mapVelX += (vXNew - this.mapVelX) * a;
                this.mapVelY += (vYNew - this.mapVelY) * a;
            }
            this.mapRenderer.moveBy(this.mapVelX * this.mapScaleFactor, this.mapVelY * this.mapScaleFactor);
            this.currentZoom -= 0.008333334f;
            this.currentZoom = Math.max(this.currentZoom, this.zoomBase);
        } else {
            this.currentZoom += 0.008333334f;
            this.currentZoom = Math.min(this.currentZoom, this.zoomBase + 0.5f);
            if (this.currentZoom >= this.zoomBase + 0.5f) {
                this.finishedZoomIn = true;
            }
        }
        if (this.chunkLoaded && this.reachedWP && this.finishedZoomIn) {
            this.field_230706_i_.func_147108_a(null);
        }
    }

    public void func_231158_b_(Minecraft mc, int i, int j) {
        super.func_231158_b_(mc, i, j);
        this.mapGui.func_231158_b_(mc, i, j);
    }

    public boolean func_231178_ax__() {
        return this.chunkLoaded;
    }

    public void func_230430_a_(MatrixStack matStack, int mouseX, int mouseY, float f) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        f = Math.min(f, 1.0f);
        this.mapRenderer.setZoom(this.prevZoom + (this.currentZoom - this.prevZoom) * f);
        this.mapRenderer.renderMap(matStack, this, this.mapGui, f);
        this.mapRenderer.renderVignettes(matStack, this, this.func_230927_p_(), 4);
        RenderSystem.enableBlend();
        TranslationTextComponent title = new TranslationTextComponent("gui.lotr.fasttravel.travel", new Object[]{this.theWaypoint.getDisplayName()});
        int numEllipses = this.tickCounter / 10 % 4;
        String titleEllipsis = new String(new char[numEllipses]).replace("\u0000", ".");
        TranslationTextComponent fullTitle = new TranslationTextComponent("%s%s", new Object[]{title, titleEllipsis});
        List loadingQuoteLines = this.field_230712_o_.func_238425_b_((ITextProperties)this.loadingQuote, this.field_230708_k_ - 100);
        float boxAlpha = 0.5f;
        int boxColor = LOTRClientUtil.getRGBA(0, boxAlpha);
        this.field_230712_o_.getClass();
        int fh = 9;
        int border = fh * 2;
        if (this.chunkLoaded) {
            FastTravelScreen.func_238467_a_((MatrixStack)matStack, (int)0, (int)0, (int)this.field_230708_k_, (int)(0 + border + fh * 3 + border), (int)boxColor);
        } else {
            FastTravelScreen.func_238467_a_((MatrixStack)matStack, (int)0, (int)0, (int)this.field_230708_k_, (int)(0 + border + fh + border), (int)boxColor);
        }
        int messageY = this.field_230709_l_ - border - loadingQuoteLines.size() * fh;
        FastTravelScreen.func_238467_a_((MatrixStack)matStack, (int)0, (int)(messageY - border), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)boxColor);
        RenderSystem.disableBlend();
        this.field_230712_o_.func_243246_a(matStack, (ITextComponent)fullTitle, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)title) / 2), (float)(0 + border), 0xFFFFFF);
        for (IReorderingProcessor line : loadingQuoteLines) {
            this.field_230712_o_.func_238407_a_(matStack, line, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_243245_a(line) / 2), (float)messageY, 0xFFFFFF);
            messageY += fh;
        }
        if (this.chunkLoaded) {
            TranslationTextComponent skipText = new TranslationTextComponent("gui.lotr.fasttravel.skip", new Object[]{this.field_230706_i_.field_71474_y.field_151445_Q.func_238171_j_()});
            float skipAlpha = LOTRUtil.normalisedTriangleWave((float)this.tickCounter + f, 160.0f, 0.3f, 1.0f);
            int skipColor = LOTRClientUtil.getRGBAForFontRendering(0xFFFFFF, skipAlpha);
            RenderSystem.enableBlend();
            this.field_230712_o_.func_243248_b(matStack, (ITextComponent)skipText, (float)(this.field_230708_k_ / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)skipText) / 2), (float)(0 + border + fh * 2), skipColor);
        }
        RenderSystem.disableBlend();
        super.func_230430_a_(matStack, mouseX, mouseY, f);
    }
}

