/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.client.gui.MiddleEarthMapRenderer;
import lotr.client.gui.MiddleEarthMapScreen;
import lotr.client.gui.widget.button.RedBookButton;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.MapWaypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.fml.BrandingControl;

public class LOTRMainMenuScreen
extends MainMenuScreen {
    private static final ResourceLocation TITLE_TEXTURE = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation TITLE_EDITION = new ResourceLocation("textures/gui/title/edition.png");
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private boolean fadeIn = isFirstMenu;
    private static boolean isFirstMenu = true;
    private long firstRenderTime;
    private boolean minceraft;
    private String splashText;
    private String copyrightText = "Copyright Mojang AB. Do not distribute!";
    private int widthCopyright;
    private int widthCopyrightRest;
    private NotificationModUpdateScreen modUpdateNotification;
    private static final IFormattableTextComponent MOD_TITLE = new TranslationTextComponent("lotr.menu.title");
    private static final IFormattableTextComponent MOD_SUBTITLE = new TranslationTextComponent("lotr.menu.subtitle").func_240699_a_(TextFormatting.ITALIC);
    private MiddleEarthMapScreen mapGui;
    private static MiddleEarthMapRenderer mapRenderer;
    private static int tickCounter;
    private static Random rand;
    private static List<MapWaypoint> waypointRoute;
    private static int currentWPIndex;
    private static boolean randomWPStart;
    private static float mapSpeed;
    private static float mapVelX;
    private static float mapVelY;
    private static final float wpChangeDistance = 12.0f;
    private static final float mapSpeedMax = 0.8f;
    private static final float mapSpeedIncr = 0.01f;
    private static final float mapAccel = 0.02f;
    private static final float zoomBase = -0.1f;
    private static final float zoomOscilSpeed = 0.003f;
    private static final float zoomOscilMax = 0.8f;

    public LOTRMainMenuScreen() {
        isFirstMenu = false;
        this.minceraft = (double)new Random().nextFloat() < 1.0E-4;
        this.mapGui = new MiddleEarthMapScreen();
        mapRenderer = new MiddleEarthMapRenderer(false);
        mapRenderer.setStableZoom((float)Math.pow(2.0, -0.1f));
        LOTRMainMenuScreen.setupWaypoints();
        if (!waypointRoute.isEmpty()) {
            currentWPIndex = randomWPStart ? rand.nextInt(waypointRoute.size()) : 0;
            MapWaypoint wp = waypointRoute.get(currentWPIndex);
            mapRenderer.setInitialPosition(wp.getMapX(), wp.getMapZ());
        } else {
            MapSettings mapSettings = MapSettingsManager.clientInstance().getCurrentLoadedMap();
            mapRenderer.setInitialPosition(mapSettings.getOriginX(), mapSettings.getOriginZ());
        }
    }

    private static void setupWaypoints() {
        waypointRoute.clear();
        MapSettings mapSettings = MapSettingsManager.clientInstance().getCurrentLoadedMap();
        waypointRoute.addAll(mapSettings.getMenuWaypointRoute());
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.splashText == null) {
            this.splashText = this.field_230706_i_.func_213269_at().func_215276_a();
        }
        this.widthCopyright = this.field_230712_o_.func_78256_a(this.copyrightText);
        this.widthCopyrightRest = this.field_230708_k_ - this.widthCopyright - 2;
        Button modbutton = this.field_230710_m_.stream().filter(widget -> widget instanceof Button && widget.func_230458_i_().getString().equals(new TranslationTextComponent("fml.menu.mods").getString())).findFirst().orElse(null);
        this.modUpdateNotification = NotificationModUpdateScreen.init((MainMenuScreen)this, (Button)modbutton);
        int lowerButtonMaxY = 0;
        for (Widget button : this.field_230710_m_) {
            int buttonMaxY = button.field_230691_m_ + button.func_238483_d_();
            if (buttonMaxY <= lowerButtonMaxY) continue;
            lowerButtonMaxY = buttonMaxY;
        }
        int idealMoveDown = 50;
        int lowestSuitableHeight = this.field_230709_l_ - 25;
        int moveDown = Math.min(idealMoveDown, lowestSuitableHeight - lowerButtonMaxY);
        moveDown = Math.max(moveDown, 0);
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            Widget button = (Widget)this.field_230710_m_.get(i);
            button.field_230691_m_ += moveDown;
            if (button.getClass() != Button.class) continue;
            Button bt = (Button)button;
            RedBookButton newButton = new RedBookButton(bt.field_230690_l_, bt.field_230691_m_, bt.func_230998_h_(), bt.func_238483_d_(), bt.func_230458_i_(), b -> bt.func_230930_b_());
            this.field_230710_m_.set(i, newButton);
        }
    }

    public void func_231158_b_(Minecraft mc, int i, int j) {
        super.func_231158_b_(mc, i, j);
        this.mapGui.loadCurrentMapTextures();
        this.mapGui.func_231158_b_(mc, i, j);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++tickCounter;
        mapRenderer.tick();
        if (!waypointRoute.isEmpty()) {
            double dy;
            MapWaypoint wp;
            double dx;
            double distSq;
            double dist;
            if (currentWPIndex >= waypointRoute.size()) {
                currentWPIndex = 0;
            }
            if ((dist = Math.sqrt(distSq = (dx = (wp = waypointRoute.get(currentWPIndex)).getMapX() - mapRenderer.getMapX()) * dx + (dy = wp.getMapZ() - mapRenderer.getMapY()) * dy)) <= 12.0) {
                if (++currentWPIndex >= waypointRoute.size()) {
                    currentWPIndex = 0;
                }
            } else {
                mapSpeed += 0.01f;
                mapSpeed = Math.min(mapSpeed, 0.8f);
                float vXNew = (float)(dx / dist) * mapSpeed;
                float vYNew = (float)(dy / dist) * mapSpeed;
                float a = 0.02f;
                mapVelX += (vXNew - mapVelX) * a;
                mapVelY += (vYNew - mapVelY) * a;
            }
        }
        mapRenderer.moveBy(mapVelX, mapVelY);
    }

    public void func_230430_a_(MatrixStack matStack, int mouseX, int mouseY, float f) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (this.firstRenderTime == 0L && this.fadeIn) {
            this.firstRenderTime = Util.func_211177_b();
        }
        float fade = this.fadeIn ? (float)(Util.func_211177_b() - this.firstRenderTime) / 1000.0f : 1.0f;
        LOTRMainMenuScreen.func_238467_a_((MatrixStack)matStack, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1);
        float zoom = -0.1f + MathHelper.func_76134_b((float)(((float)tickCounter + f) * 0.003f)) * 0.8f;
        if (this.fadeIn) {
            float slowerFade = fade * 0.5f;
            float fadeInZoom = MathHelper.func_76131_a((float)(1.0f - slowerFade), (float)0.0f, (float)1.0f) * -2.5f;
            zoom += fadeInZoom;
        }
        mapRenderer.setZoom(zoom);
        mapRenderer.renderMap(matStack, (Screen)this, this.mapGui, f);
        mapRenderer.renderVignettes(matStack, (Screen)this, this.func_230927_p_(), 2);
        int i = 274;
        int j = this.field_230708_k_ / 2 - i / 2;
        this.field_230706_i_.func_110434_K().func_110577_a(PANORAMA_OVERLAY);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.fadeIn ? MathHelper.func_76131_a((float)(1.0f - fade), (float)0.0f, (float)1.0f) : 0.0f));
        LOTRMainMenuScreen.func_238466_a_((MatrixStack)matStack, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
        float f1 = this.fadeIn ? MathHelper.func_76131_a((float)(fade - 1.0f), (float)0.0f, (float)1.0f) : 1.0f;
        int l = MathHelper.func_76123_f((float)(f1 * 255.0f)) << 24;
        if ((l & 0xFC000000) != 0) {
            this.field_230706_i_.func_110434_K().func_110577_a(TITLE_TEXTURE);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f1);
            if (this.minceraft) {
                this.func_238474_b_(matStack, j + 0, 30, 0, 0, 99, 44);
                this.func_238474_b_(matStack, j + 99, 30, 129, 0, 27, 44);
                this.func_238474_b_(matStack, j + 99 + 26, 30, 126, 0, 3, 44);
                this.func_238474_b_(matStack, j + 99 + 26 + 3, 30, 99, 0, 26, 44);
                this.func_238474_b_(matStack, j + 155, 30, 0, 45, 155, 44);
            } else {
                this.func_238474_b_(matStack, j + 0, 30, 0, 0, 155, 44);
                this.func_238474_b_(matStack, j + 155, 30, 0, 45, 155, 44);
            }
            LOTRMainMenuScreen.func_238475_b_((MatrixStack)matStack, (FontRenderer)this.field_230712_o_, (ITextComponent)MOD_TITLE, (int)(this.field_230708_k_ / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)MOD_TITLE) / 2), (int)86, (int)-1);
            LOTRMainMenuScreen.func_238475_b_((MatrixStack)matStack, (FontRenderer)this.field_230712_o_, (ITextComponent)MOD_SUBTITLE, (int)(this.field_230708_k_ / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)MOD_SUBTITLE) / 2), (int)96, (int)-2236963);
            this.field_230706_i_.func_110434_K().func_110577_a(TITLE_EDITION);
            LOTRMainMenuScreen.func_238463_a_((MatrixStack)matStack, (int)(j + 88), (int)67, (float)0.0f, (float)0.0f, (int)98, (int)14, (int)128, (int)16);
            ForgeHooksClient.renderMainMenu((MainMenuScreen)this, (MatrixStack)matStack, (FontRenderer)this.field_230712_o_, (int)this.field_230708_k_, (int)this.field_230709_l_);
            String s = "Minecraft " + SharedConstants.func_215069_a().getName();
            s = this.field_230706_i_.func_71355_q() ? s + " Demo" : s + ("release".equalsIgnoreCase(this.field_230706_i_.func_184123_d()) ? "" : "/" + this.field_230706_i_.func_184123_d());
            if (this.field_230706_i_.func_230151_c_()) {
                s = s + I18n.func_135052_a((String)"menu.modded", (Object[])new Object[0]);
            }
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                int n = brdline;
                this.field_230712_o_.getClass();
                LOTRMainMenuScreen.func_238476_c_((MatrixStack)matStack, (FontRenderer)this.field_230712_o_, (String)brd, (int)2, (int)(this.field_230709_l_ - (10 + n * (9 + 1))), (int)(0xFFFFFF | l));
            });
            BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                int n = this.field_230708_k_ - this.field_230712_o_.func_78256_a(brd);
                int n2 = brdline + 1;
                this.field_230712_o_.getClass();
                LOTRMainMenuScreen.func_238476_c_((MatrixStack)matStack, (FontRenderer)this.field_230712_o_, (String)brd, (int)n, (int)(this.field_230709_l_ - (10 + n2 * (9 + 1))), (int)(0xFFFFFF | l));
            });
            LOTRMainMenuScreen.func_238476_c_((MatrixStack)matStack, (FontRenderer)this.field_230712_o_, (String)this.copyrightText, (int)this.widthCopyrightRest, (int)(this.field_230709_l_ - 10), (int)(0xFFFFFF | l));
            if (mouseX > this.widthCopyrightRest && mouseX < this.widthCopyrightRest + this.widthCopyright && mouseY > this.field_230709_l_ - 10 && mouseY < this.field_230709_l_) {
                LOTRMainMenuScreen.func_238467_a_((MatrixStack)matStack, (int)this.widthCopyrightRest, (int)(this.field_230709_l_ - 1), (int)(this.widthCopyrightRest + this.widthCopyright), (int)this.field_230709_l_, (int)(0xFFFFFF | l));
            }
            for (Widget widget : this.field_230710_m_) {
                widget.func_230986_a_(f1);
            }
            for (Widget widget : this.field_230710_m_) {
                widget.func_230430_a_(matStack, mouseX, mouseY, f);
            }
            this.modUpdateNotification.func_230430_a_(matStack, mouseX, mouseY, f);
        }
    }

    static {
        rand = new Random();
        waypointRoute = new ArrayList<MapWaypoint>();
        randomWPStart = false;
    }
}

