/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lotr.client.gui.MapTooltipRenderer;
import lotr.client.gui.MiddleEarthMapScreen;
import lotr.common.world.map.Waypoint;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WaypointTooltipRenderer
extends MapTooltipRenderer<Waypoint> {
    private List<TooltipSection> sections = new ArrayList<TooltipSection>();

    @Override
    public void render(MatrixStack matStack, Waypoint waypoint, boolean selected, int mouseX, int mouseY, float tick) {
        int innerRectWidth;
        float expandProgress = this.getSelectionExpandProgress();
        float textAlpha = this.getExpandingTextAlpha();
        ITextComponent name = this.getNameText(waypoint);
        ITextComponent coords = this.getCoordsText(waypoint);
        ITextComponent loreText = this.getLoreText(waypoint);
        ITextComponent ownershipText = this.getOwnershipText(waypoint);
        ITextComponent numTravelsText = this.getNumTravelsText(waypoint, selected);
        float guiScale = (float)this.mc.func_228018_at_().func_198100_s();
        float loreScale = guiScale - 1.0f;
        if (guiScale <= 2.0f) {
            loreScale = guiScale;
        }
        float loreScaleRel = loreScale / guiScale;
        float loreScaleRelInv = 1.0f / loreScaleRel;
        this.font.getClass();
        int loreFontHeight = MathHelper.func_76123_f((float)(9.0f * loreScaleRel));
        double[] pos = this.mapScreen.transformMapCoords(waypoint.getMapX(), waypoint.getMapZ());
        int rectX = (int)Math.round(pos[0]);
        int rectY = (int)Math.round(pos[1]);
        rectY += 5;
        int border = 3;
        this.font.getClass();
        int fontHeight = 9;
        int innerRectWidthCompletelyExpanded = innerRectWidth = this.font.func_238414_a_((ITextProperties)name);
        if (selected) {
            int innerRectWidthExpanded = Math.max(innerRectWidth, this.font.func_238414_a_((ITextProperties)coords));
            if (loreText != null) {
                innerRectWidthExpanded += 50;
                innerRectWidthExpanded = Math.round((float)innerRectWidthExpanded * (loreScaleRel / 0.66667f));
            }
            innerRectWidth = (int)MathHelper.func_219799_g((float)expandProgress, (float)innerRectWidth, (float)innerRectWidthExpanded);
            innerRectWidthCompletelyExpanded = innerRectWidthExpanded;
        }
        int rectWidth = innerRectWidth + border * 2;
        rectX -= rectWidth / 2;
        this.sections.clear();
        this.sections.add(new TooltipSection(fontHeight + border * 2, (midX, y, highlight) -> this.mapScreen.drawCenteredStringNoShadow(matStack, this.font, name, midX, y + border, this.getTextColor(highlight, 1.0f))));
        int rectHeight = this.calculateSectionsTotalHeight();
        if (selected) {
            int coordsAndTravelsHeight = fontHeight + border;
            if (numTravelsText != null) {
                coordsAndTravelsHeight += loreFontHeight + border;
            }
            this.sections.add(new TooltipSection(coordsAndTravelsHeight, (midX, y, highlight) -> {
                if (textAlpha > 0.0f) {
                    this.mapScreen.drawCenteredStringNoShadow(matStack, this.font, coords, midX, y, this.getTextColor(highlight, textAlpha));
                    if (numTravelsText != null) {
                        y += fontHeight + border;
                        int iconSize = 8;
                        int iconPlusTextWidth = iconSize + border + (int)((float)this.font.func_238414_a_((ITextProperties)numTravelsText) * loreScaleRel);
                        this.mc.func_110434_K().func_110577_a(MiddleEarthMapScreen.MAP_ICONS);
                        float brightness = highlight ? 1.0f : 0.82f;
                        RenderSystem.color4f((float)brightness, (float)brightness, (float)brightness, (float)textAlpha);
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        this.mapScreen.func_238474_b_(matStack, midX - iconPlusTextWidth / 2, y, 0, 216, iconSize, iconSize);
                        RenderSystem.disableBlend();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        matStack.func_227860_a_();
                        matStack.func_227862_a_(loreScaleRel, loreScaleRel, 1.0f);
                        this.font.func_243248_b(matStack, numTravelsText, (float)((int)((float)(midX - iconPlusTextWidth / 2 + iconSize + border) * loreScaleRelInv)), (float)((int)((float)(y + (fontHeight - loreFontHeight) / 2) * loreScaleRelInv)), this.getTextColor(highlight, textAlpha));
                        matStack.func_227865_b_();
                    }
                }
            }));
            int stableRectWidth = innerRectWidthCompletelyExpanded;
            if (loreText != null) {
                List loreLines = this.font.func_238425_b_((ITextProperties)loreText, (int)((float)stableRectWidth * loreScaleRelInv));
                int loreTextHeight = loreLines.size() * loreFontHeight;
                this.sections.add(new TooltipSection(loreTextHeight + border * 2, (midX, y, highlight) -> {
                    if (textAlpha > 0.0f) {
                        y += border;
                        matStack.func_227860_a_();
                        matStack.func_227862_a_(loreScaleRel, loreScaleRel, 1.0f);
                        for (IReorderingProcessor line : loreLines) {
                            this.mapScreen.drawCenteredStringNoShadow(matStack, this.font, line, (int)((float)midX * loreScaleRelInv), (int)((float)y * loreScaleRelInv), this.getTextColor(highlight, textAlpha));
                            y += loreFontHeight;
                        }
                        matStack.func_227865_b_();
                    }
                }));
            }
            if (ownershipText != null) {
                List ownershipLines = this.font.func_238425_b_((ITextProperties)ownershipText, (int)((float)stableRectWidth * loreScaleRelInv));
                int ownershipTextHeight = ownershipLines.size() * loreFontHeight;
                this.sections.add(new TooltipSection(ownershipTextHeight + border, (midX, y, highlight) -> {
                    if (textAlpha > 0.0f) {
                        matStack.func_227860_a_();
                        matStack.func_227862_a_(loreScaleRel, loreScaleRel, 1.0f);
                        for (IReorderingProcessor line : ownershipLines) {
                            this.mapScreen.drawCenteredStringNoShadow(matStack, this.font, line, (int)((float)midX * loreScaleRelInv), (int)((float)y * loreScaleRelInv), this.getTextColor(highlight, textAlpha));
                            y += loreFontHeight;
                        }
                        matStack.func_227865_b_();
                    }
                }));
            }
            int expandedRectHeight = this.calculateSectionsTotalHeight();
            rectHeight = (int)MathHelper.func_219799_g((float)expandProgress, (float)rectHeight, (float)expandedRectHeight);
        }
        int mapBorder2 = 2;
        rectX = Math.max(rectX, this.mapXMin + mapBorder2);
        rectX = Math.min(rectX, this.mapXMax - mapBorder2 - rectWidth);
        rectY = Math.max(rectY, this.mapYMin + mapBorder2);
        rectY = Math.min(rectY, this.mapYMax - mapBorder2 - rectHeight);
        boolean mouseWithinTooltip = mouseX >= rectX && mouseX <= rectX + rectWidth && mouseY >= rectY && mouseY <= rectY + rectHeight;
        matStack.func_227860_a_();
        matStack.func_227861_a_(0.0, 0.0, 300.0);
        this.mapScreen.drawFancyRect(matStack, rectX, rectY, rectX + rectWidth, rectY + rectHeight);
        int midX2 = rectX + rectWidth / 2;
        int sectionY = rectY;
        TooltipSection highlightedSection = null;
        if (mouseWithinTooltip) {
            for (TooltipSection section : this.sections) {
                if (mouseY >= sectionY && mouseY < sectionY + section.height) {
                    highlightedSection = section;
                    break;
                }
                sectionY += section.height;
            }
        }
        if (highlightedSection == null && !this.sections.isEmpty()) {
            highlightedSection = this.sections.get(0);
        }
        sectionY = rectY;
        for (TooltipSection section : this.sections) {
            section.renderer.render(midX2, sectionY, section == highlightedSection);
            sectionY += section.height;
        }
        matStack.func_227865_b_();
    }

    private ITextComponent getNameText(Waypoint waypoint) {
        return waypoint.getDisplayName();
    }

    private ITextComponent getCoordsText(Waypoint waypoint) {
        int wpX = waypoint.getWorldX();
        int wpZ = waypoint.getWorldZ();
        int wpY = waypoint.getWorldYForDisplay();
        if (wpY >= 0) {
            return new TranslationTextComponent("gui.lotr.map.coordsY", new Object[]{wpX, wpY, wpZ});
        }
        return new TranslationTextComponent("gui.lotr.map.coords", new Object[]{wpX, wpZ});
    }

    private ITextComponent getLoreText(Waypoint waypoint) {
        return waypoint.getDisplayLore() != null ? waypoint.getDisplayLore() : null;
    }

    private ITextComponent getOwnershipText(Waypoint waypoint) {
        return waypoint.getDisplayOwnership() != null ? waypoint.getDisplayOwnership() : null;
    }

    private ITextComponent getNumTravelsText(Waypoint waypoint, boolean selected) {
        int numTravels;
        if (selected && this.mc.field_71439_g != null && (numTravels = this.mapScreen.getClientPlayerData().getFastTravelData().getWPUseCount(waypoint)) > 0 && waypoint.hasPlayerUnlocked((PlayerEntity)this.mc.field_71439_g)) {
            return new StringTextComponent(String.valueOf(numTravels));
        }
        return null;
    }

    private int calculateSectionsTotalHeight() {
        return this.sections.stream().collect(Collectors.summingInt(section -> ((TooltipSection)section).height));
    }

    @FunctionalInterface
    private static interface SectionRenderer {
        public void render(int var1, int var2, boolean var3);
    }

    private static class TooltipSection {
        private final int height;
        private final SectionRenderer renderer;

        public TooltipSection(int height, SectionRenderer renderer) {
            this.height = height;
            this.renderer = renderer;
        }
    }
}

