/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import lotr.common.LOTRLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.entity.Entity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class RandomTextureVariants
implements ISelectiveResourceReloadListener {
    private static final Random RAND = new Random();
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final Map<ResourceLocation, RandomTextureVariants> ALL_RANDOM_SKINS = new HashMap<ResourceLocation, RandomTextureVariants>();
    protected ResourceLocation skinPath;
    protected List<ResourceLocation> skins;

    public static RandomTextureVariants loadSkinsList(String namespace, String path) {
        return RandomTextureVariants.loadSkinsList(new ResourceLocation(namespace, path));
    }

    public static RandomTextureVariants loadSkinsList(ResourceLocation path) {
        return ALL_RANDOM_SKINS.computeIfAbsent(path, RandomTextureVariants::new);
    }

    private RandomTextureVariants(ResourceLocation path) {
        this.skinPath = path;
        IReloadableResourceManager resMgr = (IReloadableResourceManager)MC.func_195551_G();
        resMgr.func_219534_a((IFutureReloadListener)this);
        this.loadAllRandomSkins((IResourceManager)resMgr);
    }

    private void loadAllRandomSkins(IResourceManager resMgr) {
        this.skins = new ArrayList<ResourceLocation>();
        int skinCount = 0;
        int skips = 0;
        int maxSkips = 10;
        boolean foundAfterSkip = false;
        while (true) {
            ResourceLocation skin = new ResourceLocation(this.skinPath.func_110624_b(), this.skinPath.func_110623_a() + "/" + skinCount + ".png");
            boolean noFile = false;
            try {
                if (resMgr.func_199002_a(skin) == null) {
                    noFile = true;
                }
            }
            catch (Exception e) {
                noFile = true;
            }
            if (noFile) {
                if (++skips >= maxSkips) break;
                ++skinCount;
                continue;
            }
            this.skins.add(skin);
            ++skinCount;
            if (skips <= 0) continue;
            foundAfterSkip = true;
        }
        if (this.skins.isEmpty()) {
            LOTRLog.warn("No random skins for %s", this.skinPath);
        }
        if (foundAfterSkip) {
            LOTRLog.warn("Random skins %s skipped a number. This is bad for performance - please number your skins from 0 up, with no gaps!", this.skinPath);
        }
    }

    public ResourceLocation getRandomSkin(Entity entity) {
        if (this.skins == null || this.skins.isEmpty()) {
            return MissingTextureSprite.func_195675_b();
        }
        int i = RandomTextureVariants.nextInt(entity, this.skins.size());
        return this.skins.get(i);
    }

    public ResourceLocation getRandomSkin() {
        if (this.skins == null || this.skins.isEmpty()) {
            return MissingTextureSprite.func_195675_b();
        }
        int i = RAND.nextInt(this.skins.size());
        return this.skins.get(i);
    }

    public static int nextInt(Entity entity, int n) {
        RandomTextureVariants.setRandSeedFromEntity(entity);
        return RAND.nextInt(n);
    }

    public static float nextFloat(Entity entity) {
        RandomTextureVariants.setRandSeedFromEntity(entity);
        return RAND.nextFloat();
    }

    private static void setRandSeedFromEntity(Entity entity) {
        UUID entityUuid = entity.func_110124_au();
        long l = entityUuid.getLeastSignificantBits();
        l = l * 29506206L * (l ^ entityUuid.getMostSignificantBits()) + 25859L;
        l = l * l * 426430295004L + 25925025L * l;
        RAND.setSeed(l);
    }

    public List<ResourceLocation> getAllSkins() {
        return this.skins;
    }

    public void onResourceManagerReload(IResourceManager resMgr, Predicate<IResourceType> resPredicate) {
        if (resPredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            this.loadAllRandomSkins(resMgr);
        }
    }
}

