/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import lotr.client.render.entity.model.LOTRBipedModel;
import lotr.common.entity.npc.NPCEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;

public class LOTRBipedRenderer<E extends NPCEntity, M extends LOTRBipedModel<E>>
extends BipedRenderer<E, M> {
    public static final float PLAYER_SCALE = 0.9375f;
    protected static final float BIPED_SHADOW_SIZE = 0.5f;

    public LOTRBipedRenderer(EntityRendererManager mgr, M model, M leggingsModel, M mainArmorModel, float shadowSize) {
        super(mgr, model, shadowSize);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, leggingsModel, mainArmorModel));
    }

    protected void preRenderCallback(E entity, MatrixStack matStack, float f) {
        super.func_225620_a_(entity, matStack, f);
        matStack.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
    }

    public void render(E entity, float yaw, float partialTicks, MatrixStack matStack, IRenderTypeBuffer buf, int packedLight) {
        ((LOTRBipedModel)this.field_77045_g).field_228270_o_ = entity.func_225608_bj_();
        ((LOTRBipedModel)this.field_77045_g).showChest = ((NPCEntity)((Object)entity)).shouldRenderNPCChest();
        ((LOTRBipedModel)this.field_77045_g).isEating = ((NPCEntity)((Object)entity)).getNPCItemsInv().getIsEating();
        ((LOTRBipedModel)this.field_77045_g).setTalkAnimation(((NPCEntity)((Object)entity)).getTalkAnimations(), partialTicks);
        this.setArmPoses(entity);
        super.func_225623_a_(entity, yaw, partialTicks, matStack, buf, packedLight);
    }

    private void setArmPoses(E entity) {
        BipedModel.ArmPose mainArmPose = LOTRBipedRenderer.getArmPose(entity, Hand.MAIN_HAND);
        BipedModel.ArmPose offArmPose = LOTRBipedRenderer.getArmPose(entity, Hand.OFF_HAND);
        if (mainArmPose.func_241657_a_()) {
            BipedModel.ArmPose armPose = offArmPose = entity.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
        }
        if (entity.func_184591_cq() == HandSide.RIGHT) {
            ((LOTRBipedModel)this.field_77045_g).field_187076_m = mainArmPose;
            ((LOTRBipedModel)this.field_77045_g).field_187075_l = offArmPose;
        } else {
            ((LOTRBipedModel)this.field_77045_g).field_187076_m = offArmPose;
            ((LOTRBipedModel)this.field_77045_g).field_187075_l = mainArmPose;
        }
    }

    private static BipedModel.ArmPose getArmPose(LivingEntity entity, Hand hand) {
        ItemStack heldItem = entity.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (entity.func_184600_cs() == hand && entity.func_184605_cv() > 0) {
            UseAction useaction = heldItem.func_77975_n();
            if (useaction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useaction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useaction == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useaction == UseAction.CROSSBOW && hand == entity.func_184600_cs()) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!entity.field_82175_bq && heldItem.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)heldItem)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }
}

