/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import lotr.client.LOTRClientProxy;
import lotr.client.LOTRClientUtil;
import lotr.client.render.entity.model.RingPortalModel;
import lotr.common.entity.item.RingPortalEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;

public class RingPortalRenderer
extends EntityRenderer<RingPortalEntity> {
    public static final ResourceLocation RING_TEXTURE = new ResourceLocation("lotr", "textures/entity/portal/ring.png");
    public static final ResourceLocation SCRIPT_TEXTURE = new ResourceLocation("lotr", "textures/entity/portal/script.png");
    private static final RingPortalModel MODEL_RING = new RingPortalModel(false);
    private static final RingPortalModel MODEL_SCRIPT = new RingPortalModel(true);
    private static final float OUTER_SCALE = 1.05f;
    private static final float INNER_SCALE = 0.85f;

    public RingPortalRenderer(EntityRendererManager mgr) {
        super(mgr);
    }

    public ResourceLocation getEntityTexture(RingPortalEntity entity) {
        return RING_TEXTURE;
    }

    protected int getBlockLight(RingPortalEntity entity, BlockPos pos) {
        return 15;
    }

    public void render(RingPortalEntity portal, float yaw, float ticks, MatrixStack matStack, IRenderTypeBuffer buf, int packedLight) {
        matStack.func_227860_a_();
        matStack.func_227861_a_(0.0, 0.75, 0.0);
        matStack.func_227862_a_(1.0f, -1.0f, -1.0f);
        float portalScale = portal.getPortalScale(ticks);
        matStack.func_227862_a_(portalScale, portalScale, portalScale);
        matStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(portal.getPortalRotation(ticks)));
        matStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(10.0f));
        this.renderRingModel(portal, (Model)MODEL_RING, RenderType.func_228640_c_((ResourceLocation)RING_TEXTURE), ticks, matStack, buf, packedLight, 1.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int fullbright = LOTRClientProxy.MAX_LIGHTMAP;
        float scriptBr = portal.getScriptBrightness(ticks);
        matStack.func_227860_a_();
        matStack.func_227862_a_(1.05f, 1.05f, 1.05f);
        this.renderRingModel(portal, (Model)MODEL_SCRIPT, RenderType.func_228644_e_((ResourceLocation)SCRIPT_TEXTURE), ticks, matStack, buf, fullbright, scriptBr);
        matStack.func_227865_b_();
        matStack.func_227860_a_();
        matStack.func_227862_a_(0.85f, 0.85f, 0.85f);
        this.renderRingModel(portal, (Model)MODEL_SCRIPT, RenderType.func_228644_e_((ResourceLocation)SCRIPT_TEXTURE), ticks, matStack, buf, fullbright, scriptBr);
        matStack.func_227865_b_();
        RenderSystem.disableBlend();
        matStack.func_227865_b_();
    }

    private void renderRingModel(RingPortalEntity portal, Model model, RenderType renType, float ticks, MatrixStack mat, IRenderTypeBuffer buf, int light, float alpha) {
        IVertexBuilder vb = buf.getBuffer(renType);
        int overlay = LOTRClientUtil.getPackedNoOverlay();
        model.func_225598_a_(mat, vb, light, overlay, 1.0f, 1.0f, 1.0f, alpha);
    }
}

