/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Predicate;
import lotr.client.render.RandomTextureVariants;
import lotr.client.render.entity.model.LOTRBipedModel;
import lotr.common.entity.npc.NPCEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;

public class NPCOutfitLayer<E extends NPCEntity, M extends LOTRBipedModel<E>>
extends LayerRenderer<E, M> {
    private final M outfitModel;
    private final RandomTextureVariants outfitSkins;
    private final EquipmentSlotType requiredEmptySlot;
    private final float proportionWithOutfit;
    private final Predicate<E> genderCheck;

    public NPCOutfitLayer(IEntityRenderer<E, M> renderer, M model, RandomTextureVariants skins, EquipmentSlotType slot, float prop, Predicate<E> gender) {
        super(renderer);
        this.outfitModel = model;
        this.outfitSkins = skins;
        this.requiredEmptySlot = slot;
        this.proportionWithOutfit = prop;
        this.genderCheck = gender;
    }

    public NPCOutfitLayer(IEntityRenderer<E, M> renderer, M model, RandomTextureVariants skins, EquipmentSlotType slot) {
        this(renderer, model, skins, slot, 1.0f);
    }

    public NPCOutfitLayer(IEntityRenderer<E, M> renderer, M model, RandomTextureVariants skins, EquipmentSlotType slot, float prop) {
        this(renderer, model, skins, slot, prop, NPCOutfitLayer::anyGender);
    }

    public static <E extends NPCEntity> boolean anyGender(E entity) {
        return true;
    }

    public static <E extends NPCEntity> boolean maleOnly(E entity) {
        return entity.getPersonalInfo().isMale();
    }

    public static <E extends NPCEntity> boolean femaleOnly(E entity) {
        return entity.getPersonalInfo().isFemale();
    }

    public void render(MatrixStack matStack, IRenderTypeBuffer buf, int packedLight, E entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.genderCheck.test(entity) && entity.func_184582_a(this.requiredEmptySlot).func_190926_b() && RandomTextureVariants.nextFloat(entity) < this.proportionWithOutfit) {
            NPCOutfitLayer.func_229140_a_((EntityModel)this.func_215332_c(), this.outfitModel, (ResourceLocation)this.outfitSkins.getRandomSkin((Entity)entity), (MatrixStack)matStack, (IRenderTypeBuffer)buf, (int)packedLight, entity, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

