/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity.model;

import com.google.common.collect.ImmutableList;
import lotr.client.render.entity.model.TransformableModelRenderer;
import lotr.common.entity.animal.CaracalEntity;
import lotr.common.util.LOTRUtil;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class CaracalModel<E extends CaracalEntity>
extends AgeableModel<E> {
    private static final float QUARTER_PHASE = 1.5707964f;
    private final TransformableModelRenderer body;
    private final ModelRenderer head;
    private final ModelRenderer noseBridge;
    private final ModelRenderer noseMark;
    private final ModelRenderer earL;
    private final ModelRenderer earR;
    private final ModelRenderer tuftL;
    private final ModelRenderer tuftR;
    private final ModelRenderer tailMain;
    private final ModelRenderer tailEnd;
    private final ModelRenderer backLegL;
    private final ModelRenderer backLegR;
    private final ModelRenderer frontLegL;
    private final ModelRenderer frontLegR;
    private State state = State.NORMAL;

    public CaracalModel(float f) {
        super(true, 10.0f, 4.0f);
        this.body = new TransformableModelRenderer((Model)this, 22, 0);
        this.body.func_78793_a(0.0f, 17.0f, 0.0f);
        this.body.func_228303_a_(-3.0f, -8.0f, -1.0f, 6.0f, 16.0f, 6.0f, f, false);
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_78793_a(0.0f, 14.0f, -10.0f);
        this.head.func_228303_a_(-3.0f, -4.0f, -3.0f, 6.0f, 5.0f, 5.0f, f, false);
        this.head.func_78784_a(0, 15).func_228303_a_(-1.5f, -1.0f, -4.5f, 3.0f, 2.0f, 2.0f, f, false);
        this.noseBridge = new ModelRenderer((Model)this, 0, 10);
        this.noseBridge.func_78793_a(0.0f, -1.0f, -4.0f);
        this.noseBridge.func_228303_a_(-1.0f, -2.75f, -0.435f, 2.0f, 3.0f, 2.0f, f, false);
        this.head.func_78792_a(this.noseBridge);
        this.noseMark = new ModelRenderer((Model)this, 8, 13);
        this.noseMark.func_78793_a(1.7f, -2.0f, -3.1f);
        this.noseMark.func_228303_a_(-1.7f, -0.5f, -1.335f, 1.0f, 1.0f, 1.0f, f, false);
        this.noseMark.field_78796_g = (float)Math.toRadians(30.0);
        this.head.func_78792_a(this.noseMark);
        this.earL = new ModelRenderer((Model)this, 0, 22);
        this.earL.func_78793_a(2.0f, -3.0f, 0.0f);
        this.earL.func_228303_a_(-0.5f, -3.0f, -1.0f, 1.0f, 2.0f, 2.0f, f, true);
        this.head.func_78792_a(this.earL);
        this.earR = new ModelRenderer((Model)this, 0, 22);
        this.earR.func_78793_a(-2.0f, -3.0f, 0.0f);
        this.earR.func_228303_a_(-0.5f, -3.0f, -1.0f, 1.0f, 2.0f, 2.0f, f, false);
        this.head.func_78792_a(this.earR);
        this.tuftL = new ModelRenderer((Model)this, 6, 23);
        this.tuftL.func_78793_a(0.0f, -3.0f, 0.0f);
        this.tuftL.func_228303_a_(-0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 0.0f, f, true);
        this.earL.func_78792_a(this.tuftL);
        this.tuftR = new ModelRenderer((Model)this, 6, 23);
        this.tuftR.func_78793_a(0.0f, -3.0f, 0.0f);
        this.tuftR.func_228303_a_(-0.5f, -3.0f, 0.0f, 1.0f, 3.0f, 0.0f, f, false);
        this.earR.func_78792_a(this.tuftR);
        this.tailMain = new ModelRenderer((Model)this);
        this.tailMain.func_78793_a(0.0f, 14.5f, 6.0f);
        this.tailMain.func_78784_a(22, 23).func_228303_a_(-0.5f, 1.0f, 1.0f, 1.0f, 8.0f, 1.0f, f, false);
        this.tailEnd = new ModelRenderer((Model)this);
        this.tailEnd.func_78793_a(0.0f, 9.0f, 1.0f);
        this.tailEnd.func_78784_a(26, 23).func_228303_a_(-0.5f, 0.0f, 0.0f, 1.0f, 8.0f, 1.0f, f, false);
        this.tailMain.func_78792_a(this.tailEnd);
        this.backLegL = new ModelRenderer((Model)this, 54, 0);
        this.backLegL.func_78793_a(1.1f, 14.0f, 6.0f);
        this.backLegL.func_228303_a_(-0.4f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, f, true);
        this.backLegR = new ModelRenderer((Model)this, 54, 0);
        this.backLegR.func_78793_a(-1.1f, 14.0f, 6.0f);
        this.backLegR.func_228303_a_(-1.6f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, f, false);
        this.frontLegL = new ModelRenderer((Model)this, 46, 0);
        this.frontLegL.func_78793_a(1.2f, 14.0f, -5.0f);
        this.frontLegL.func_228303_a_(-0.4f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, f, true);
        this.frontLegR = new ModelRenderer((Model)this, 46, 0);
        this.frontLegR.func_78793_a(-1.2f, 14.0f, -5.0f);
        this.frontLegR.func_228303_a_(-1.6f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, f, false);
    }

    public ModelRenderer getHead() {
        return this.head;
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)((Object)this.body), (Object)this.backLegL, (Object)this.backLegR, (Object)this.frontLegL, (Object)this.frontLegR, (Object)this.tailMain);
    }

    private boolean isCaracalAsleepOrOnBed(E caracal) {
        return caracal.func_70608_bn() || caracal.func_213416_eg();
    }

    public void setLivingAnimations(E caracal, float limbSwing, float limbSwingAmount, float partialTick) {
        this.body.field_78800_c = 0.0f;
        this.body.field_78797_d = 17.0f;
        this.body.field_78798_e = 0.0f;
        this.head.field_78800_c = 0.0f;
        this.head.field_78797_d = 14.0f;
        this.head.field_78798_e = -10.0f;
        this.tailMain.field_78800_c = 0.0f;
        this.tailMain.field_78797_d = 14.5f;
        this.tailMain.field_78798_e = 6.0f;
        this.frontLegL.field_78800_c = 1.2f;
        this.frontLegL.field_78797_d = 14.0f;
        this.frontLegL.field_78798_e = -5.0f;
        this.frontLegR.field_78800_c = -1.2f;
        this.frontLegR.field_78797_d = 14.0f;
        this.frontLegR.field_78798_e = -5.0f;
        this.backLegL.field_78800_c = 1.1f;
        this.backLegL.field_78797_d = 14.0f;
        this.backLegL.field_78798_e = 6.0f;
        this.backLegR.field_78800_c = -1.1f;
        this.backLegR.field_78797_d = 14.0f;
        this.backLegR.field_78798_e = 6.0f;
        if (((CaracalEntity)((Object)caracal)).isFloppa()) {
            this.body.setScaleAndTranslation(1.25f, 1.1f, 1.0f, 0.0, -1.7, 0.0);
            float legShift = 0.3f;
            this.frontLegL.field_78800_c += legShift;
            this.frontLegR.field_78800_c -= legShift;
            this.backLegL.field_78800_c += legShift;
            this.backLegR.field_78800_c -= legShift;
        } else {
            this.body.resetScaleAndTranslation();
        }
        this.noseMark.field_78806_j = ((CaracalEntity)((Object)caracal)).isFloppa();
        if (caracal.func_233684_eK_() || this.isCaracalAsleepOrOnBed(caracal)) {
            this.state = State.LYING;
            this.body.field_78797_d += 5.0f;
            this.body.field_78800_c -= 2.0f;
            this.head.field_78797_d += 5.0f;
            this.head.field_78800_c -= 1.0f;
            this.tailMain.field_78797_d += 5.0f;
            this.tailMain.field_78800_c -= 2.0f;
            this.frontLegL.field_78797_d += 8.0f;
            this.frontLegR.field_78797_d += 8.0f;
            this.backLegL.field_78797_d += 8.0f;
            this.backLegR.field_78797_d += 8.0f;
            this.frontLegR.field_78800_c -= 2.0f;
            this.frontLegR.field_78798_e -= 3.0f;
            this.backLegR.field_78798_e -= 2.0f;
        } else if (caracal.func_213453_ef()) {
            this.body.field_78797_d += 1.0f;
            this.head.field_78797_d += 2.0f;
            this.tailMain.field_78797_d += 1.0f;
            this.tailMain.field_78795_f = (float)Math.toRadians(90.0);
            this.state = State.SNEAKING;
        } else if (caracal.func_70051_ag()) {
            this.tailMain.field_78795_f = (float)Math.toRadians(90.0);
            this.state = State.SPRINTING;
        } else {
            this.state = State.NORMAL;
        }
    }

    public void setRotationAngles(E caracal, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.field_78795_f = (float)Math.toRadians(headPitch);
        this.head.field_78796_g = (float)Math.toRadians(netHeadYaw);
        this.noseBridge.field_78795_f = (float)Math.toRadians(-27.5);
        if (this.isCaracalAsleepOrOnBed(caracal)) {
            this.head.field_78795_f += (float)Math.toRadians(30.0) + MathHelper.func_76134_b((float)(ageInTicks / 30.0f)) * (float)Math.toRadians(10.0);
        }
        if (((CaracalEntity)((Object)caracal)).isFlopping()) {
            float flopSpeed = 0.75f;
            float flop = LOTRUtil.normalisedCos(ageInTicks * flopSpeed);
            float tuftFlop = LOTRUtil.normalisedCos(ageInTicks * flopSpeed + 1.5707964f);
            this.earL.field_78795_f = (float)Math.toRadians(-4.0 - (double)flop * 12.0);
            this.earL.field_78796_g = (float)Math.toRadians(6.5 + (double)flop * 35.0);
            this.earL.field_78808_h = (float)Math.toRadians(5.0 + (double)flop * 50.0);
            this.earR.field_78795_f = this.earL.field_78795_f;
            this.earR.field_78796_g = -this.earL.field_78796_g;
            this.earR.field_78808_h = -this.earL.field_78808_h;
            this.tuftL.field_78808_h = (float)Math.toRadians(3.0 + (double)tuftFlop * 40.0);
            this.tuftR.field_78808_h = -this.tuftL.field_78808_h;
        } else if (((CaracalEntity)((Object)caracal)).areEarsAlert()) {
            this.earL.field_78795_f = 0.0f;
            this.earL.field_78796_g = (float)Math.toRadians(10.5);
            this.earL.field_78808_h = (float)Math.toRadians(6.0);
            this.earR.field_78795_f = this.earL.field_78795_f;
            this.earR.field_78796_g = -this.earL.field_78796_g;
            this.earR.field_78808_h = -this.earL.field_78808_h;
            this.tuftL.field_78808_h = (float)Math.toRadians(4.0);
            this.tuftR.field_78808_h = -this.tuftL.field_78808_h;
        } else {
            float idleFlop = MathHelper.func_76134_b((float)(ageInTicks / 20.0f));
            float idleTuftFlop = MathHelper.func_76134_b((float)(ageInTicks / 20.0f + 1.5707964f));
            float motionFlop = LOTRUtil.normalisedCos(limbSwing * 1.0f) * limbSwingAmount;
            float motionTuftFlop = LOTRUtil.normalisedCos(limbSwing * 1.0f + 1.5707964f) * limbSwingAmount;
            float floppaHealth = caracal.func_110143_aJ() / caracal.func_110138_aP();
            double baseTuftTlop = MathHelper.func_219803_d((double)floppaHealth, (double)100.0, (double)20.0);
            this.earL.field_78795_f = (float)Math.toRadians(-4.0 - (double)motionFlop * 30.0 - (double)idleFlop * 4.0);
            this.earL.field_78796_g = (float)Math.toRadians(17.5 + (double)motionFlop * 5.0 + (double)idleFlop * 2.0);
            this.earL.field_78808_h = (float)Math.toRadians(12.5 + (double)motionFlop * 20.0 + (double)idleFlop * 3.0);
            if (this.state == State.LYING) {
                this.earL.field_78808_h += (float)Math.toRadians(8.0);
            }
            this.earR.field_78795_f = this.earL.field_78795_f;
            this.earR.field_78796_g = -this.earL.field_78796_g;
            this.earR.field_78808_h = -this.earL.field_78808_h;
            this.tuftL.field_78808_h = (float)Math.toRadians(baseTuftTlop + (double)motionTuftFlop * 30.0 + (double)idleTuftFlop * 4.0);
            this.tuftR.field_78808_h = -this.tuftL.field_78808_h;
        }
        this.body.field_78795_f = (float)Math.toRadians(90.0);
        this.tailMain.field_78795_f = (float)Math.toRadians(45.0);
        this.tailEnd.field_78795_f = (float)Math.toRadians(45.0);
        this.tailEnd.field_78796_g = 0.0f;
        this.tailMain.field_78796_g = 0.0f;
        if (this.state != State.LYING) {
            this.frontLegR.field_78808_h = 0.0f;
            this.frontLegL.field_78808_h = 0.0f;
            this.backLegR.field_78808_h = 0.0f;
            this.backLegL.field_78808_h = 0.0f;
            if (this.state == State.SPRINTING) {
                this.backLegL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.backLegR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + 0.3f)) * limbSwingAmount;
                this.frontLegL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI + 0.3f)) * limbSwingAmount;
                this.frontLegR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.tailEnd.field_78795_f = (float)Math.toRadians(44.0 + 18.0 * (double)MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * (double)limbSwingAmount);
            } else {
                this.backLegL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.backLegR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.frontLegL.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
                this.frontLegR.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * limbSwingAmount;
                this.tailEnd.field_78795_f = this.state == State.NORMAL ? (float)Math.toRadians(44.0 + 45.0 * (double)MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * (double)limbSwingAmount) : (float)Math.toRadians(44.0 + 27.0 * (double)MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * (double)limbSwingAmount);
            }
        } else {
            this.frontLegL.field_78808_h = this.frontLegR.field_78808_h = (float)Math.toRadians(-85.0);
            this.backLegR.field_78808_h = this.frontLegR.field_78808_h;
            this.backLegL.field_78808_h = this.frontLegR.field_78808_h;
            this.frontLegL.field_78795_f = (float)Math.toRadians(20.0);
            this.frontLegR.field_78795_f = (float)Math.toRadians(-20.0);
            this.backLegL.field_78795_f = (float)Math.toRadians(20.0);
            this.backLegR.field_78795_f = (float)Math.toRadians(-20.0);
            this.tailMain.field_78795_f = (float)Math.toRadians(60.0);
            this.tailEnd.field_78795_f = (float)Math.toRadians(30.0);
            this.tailMain.field_78796_g = MathHelper.func_76134_b((float)(ageInTicks / 30.0f)) * (float)Math.toRadians(35.0);
            this.tailEnd.field_78796_g = this.tailMain.field_78796_g * 1.3f;
        }
        if (((CaracalEntity)((Object)caracal)).isRaidingChest()) {
            this.frontLegL.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 1.3f + (float)Math.PI)) * limbSwingAmount;
            this.frontLegR.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 1.3f)) * limbSwingAmount;
        }
    }

    private static enum State {
        SNEAKING,
        NORMAL,
        SPRINTING,
        LYING;

    }
}

