/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity.model;

import java.util.function.Consumer;
import java.util.function.Function;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.ai.NPCTalkAnimations;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class LOTRBipedModel<E extends LivingEntity>
extends BipedModel<E> {
    public boolean showChest = false;
    public boolean isEating = false;
    private float talkingHeadYawRadians = 0.0f;
    private float talkingHeadPitchRadians = 0.0f;
    private float talkingGestureMainhand = 0.0f;
    private float talkingGestureOffhand = 0.0f;

    public LOTRBipedModel(float modelSize) {
        super(modelSize);
    }

    public LOTRBipedModel(float modelSize, float yOff, int texW, int texH) {
        super(modelSize, yOff, texW, texH);
    }

    public LOTRBipedModel(Function<ResourceLocation, RenderType> renderType, float modelSize, float yOff, int texW, int texH) {
        super(renderType, modelSize, yOff, texW, texH);
    }

    public void setTalkAnimation(NPCTalkAnimations talkAnims, float f) {
        this.talkingHeadYawRadians = talkAnims.getHeadYawRadians(f);
        this.talkingHeadPitchRadians = talkAnims.getHeadPitchRadians(f);
        this.talkingGestureMainhand = talkAnims.getMainhandGestureAmount(f);
        this.talkingGestureOffhand = talkAnims.getOffhandGestureAmount(f);
    }

    public void func_217111_a(EntityModel<E> other) {
        super.func_217111_a(other);
        if (other instanceof LOTRBipedModel) {
            LOTRBipedModel otherBiped = (LOTRBipedModel)other;
            otherBiped.showChest = this.showChest;
            otherBiped.isEating = this.isEating;
            otherBiped.talkingHeadYawRadians = this.talkingHeadYawRadians;
            otherBiped.talkingHeadPitchRadians = this.talkingHeadPitchRadians;
            otherBiped.talkingGestureMainhand = this.talkingGestureMainhand;
            otherBiped.talkingGestureOffhand = this.talkingGestureOffhand;
        }
    }

    public void func_225597_a_(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.isEating) {
            this.onArm((LivingEntity)entity, Hand.MAIN_HAND, arm -> {
                arm.field_78795_f = Math.min(arm.field_78795_f, (float)Math.toRadians(-60.0));
            });
        }
        this.field_78116_c.field_78796_g += this.talkingHeadYawRadians;
        this.field_78116_c.field_78795_f += this.talkingHeadPitchRadians;
        this.field_178720_f.field_78796_g += this.talkingHeadYawRadians;
        this.field_178720_f.field_78795_f += this.talkingHeadPitchRadians;
        float rightGestureAmount = entity.func_184591_cq() == HandSide.RIGHT ? this.talkingGestureMainhand : this.talkingGestureOffhand;
        float leftGestureAmount = entity.func_184591_cq() == HandSide.RIGHT ? this.talkingGestureOffhand : this.talkingGestureMainhand;
        this.field_178723_h.field_78795_f = (float)((double)this.field_178723_h.field_78795_f + (double)rightGestureAmount * Math.toRadians(-45.0));
        this.field_178723_h.field_78808_h = (float)((double)this.field_178723_h.field_78808_h + (double)rightGestureAmount * Math.toRadians(20.0));
        this.field_178724_i.field_78795_f = (float)((double)this.field_178724_i.field_78795_f + (double)leftGestureAmount * Math.toRadians(-45.0));
        this.field_178724_i.field_78808_h = (float)((double)this.field_178724_i.field_78808_h + (double)leftGestureAmount * Math.toRadians(-20.0));
        if (entity instanceof NPCEntity && !this.field_217113_d) {
            this.field_178721_j.field_78796_g = (float)Math.toRadians(5.0);
            this.field_178722_k.field_78796_g = (float)Math.toRadians(-5.0);
        }
        if (entity instanceof NPCEntity && ((NPCEntity)((Object)entity)).isDrunk()) {
            float f6 = ageInTicks / 80.0f;
            float f7 = (ageInTicks + 40.0f) / 80.0f;
            float f8 = MathHelper.func_76126_a((float)(f6 *= (float)Math.PI * 2)) * 0.5f;
            float f9 = MathHelper.func_76126_a((float)(f7 *= (float)Math.PI * 2)) * 0.5f;
            this.field_78116_c.field_78795_f += f8;
            this.field_78116_c.field_78796_g += f9;
            this.field_178720_f.field_78795_f += f8;
            this.field_178720_f.field_78796_g += f9;
            for (Hand hand : Hand.values()) {
                if (entity.func_184586_b(hand).func_190926_b()) continue;
                this.onArm((LivingEntity)entity, hand, arm -> {
                    arm.field_78795_f = (float)Math.toRadians(-60.0);
                });
            }
        }
    }

    private void onArm(LivingEntity entity, Hand handType, Consumer<ModelRenderer> action) {
        HandSide mainHandSide = entity.func_184591_cq();
        if (mainHandSide == HandSide.RIGHT) {
            action.accept(handType == Hand.MAIN_HAND ? this.field_178723_h : this.field_178724_i);
        } else {
            action.accept(handType == Hand.MAIN_HAND ? this.field_178724_i : this.field_178723_h);
        }
    }
}

