/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;

public class TransformableModelRenderer
extends ModelRenderer {
    private float scaleX;
    private float scaleY;
    private float scaleZ;
    private double transX;
    private double transY;
    private double transZ;

    public TransformableModelRenderer(Model model, int texOffX, int texOffY) {
        super(model, texOffX, texOffY);
        this.resetScaleAndTranslation();
    }

    public void resetScaleAndTranslation() {
        this.setScaleAndTranslation(1.0f, 1.0f, 1.0f, 0.0, 0.0, 0.0);
    }

    public void setScaleAndTranslation(float x, float y, float z, double tx, double ty, double tz) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
        this.transX = tx;
        this.transY = ty;
        this.transZ = tz;
    }

    private boolean hasTransform() {
        return this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f || this.transX != 0.0 || this.transY != 0.0 || this.transZ != 0.0;
    }

    public void func_228309_a_(MatrixStack matStack, IVertexBuilder buf, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        boolean hasTransform = this.hasTransform();
        if (hasTransform) {
            matStack.func_227860_a_();
            matStack.func_227862_a_(this.scaleX, this.scaleY, this.scaleZ);
            matStack.func_227861_a_(this.transX / 16.0, this.transY / 16.0, this.transZ / 16.0);
        }
        super.func_228309_a_(matStack, buf, packedLight, packedOverlay, red, green, blue, alpha);
        if (hasTransform) {
            matStack.func_227865_b_();
        }
    }
}

