/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity.model.armor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import lotr.client.event.LOTRTickHandlerClient;
import lotr.client.render.entity.model.armor.LOTRArmorModels;
import lotr.client.render.entity.model.armor.SpecialArmorModel;
import lotr.client.render.entity.model.armor.WearerDependentArmorModel;
import lotr.common.config.LOTRConfig;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;

public class DolAmrothChestplateModel
extends SpecialArmorModel<LivingEntity>
implements WearerDependentArmorModel {
    private final float modelSize;
    private int numWings;
    private ModelRenderer[] wingsRight;
    private ModelRenderer[] wingsLeft;

    public DolAmrothChestplateModel() {
        this(0.0f);
    }

    public DolAmrothChestplateModel(float f) {
        super(f);
        this.modelSize = f;
        this.numWings = DolAmrothChestplateModel.getNumWings();
        this.recreateBodyAndWings();
        this.field_178723_h = new ModelRenderer((Model)this, 24, 0);
        this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
        this.field_178723_h.func_228301_a_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, f);
        this.field_178724_i = new ModelRenderer((Model)this, 24, 0);
        this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        this.field_178724_i.field_78809_i = true;
        this.field_178724_i.func_228301_a_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, f);
        LOTRArmorModels.clearNonChestplateParts(this);
    }

    private static int getNumWings() {
        return (Integer)LOTRConfig.CLIENT.dolAmrothChestplateWings.get();
    }

    private void recreateBodyAndWings() {
        float f = this.modelSize;
        this.field_78115_e = new ModelRenderer((Model)this, 0, 0);
        this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
        this.field_78115_e.func_228301_a_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, f);
        if (this.numWings > 0) {
            ModelRenderer wing;
            int i;
            this.wingsRight = new ModelRenderer[this.numWings];
            for (i = 0; i < this.wingsRight.length; ++i) {
                wing = new ModelRenderer((Model)this, 0, 16);
                wing.func_78793_a(-2.0f, 0.0f, 0.0f);
                wing.func_228301_a_(-2.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, 0.0f);
                wing.func_78784_a(6, 16).func_228301_a_(-2.0f, 1.0f, 0.5f, 2.0f, 10.0f, 0.0f, 0.0f);
                this.wingsRight[i] = wing;
            }
            for (i = 0; i < this.wingsRight.length - 1; ++i) {
                this.wingsRight[i].func_78792_a(this.wingsRight[i + 1]);
            }
            this.wingsRight[0].func_78793_a(-2.0f, 1.0f, 1.0f);
            this.field_78115_e.func_78792_a(this.wingsRight[0]);
            this.wingsLeft = new ModelRenderer[this.numWings];
            for (i = 0; i < this.wingsLeft.length; ++i) {
                wing = new ModelRenderer((Model)this, 0, 16);
                wing.func_78793_a(2.0f, 0.0f, 0.0f);
                wing.field_78809_i = true;
                wing.func_228301_a_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f, 0.0f);
                wing.func_78784_a(6, 16).func_228301_a_(0.0f, 1.0f, 0.5f, 2.0f, 10.0f, 0.0f, 0.0f);
                this.wingsLeft[i] = wing;
            }
            for (i = 0; i < this.wingsLeft.length - 1; ++i) {
                this.wingsLeft[i].func_78792_a(this.wingsLeft[i + 1]);
            }
            this.wingsLeft[0].func_78793_a(2.0f, 1.0f, 1.0f);
            this.field_78115_e.func_78792_a(this.wingsLeft[0]);
        } else {
            this.wingsRight = new ModelRenderer[0];
            this.wingsLeft = new ModelRenderer[0];
        }
    }

    public void func_225598_a_(MatrixStack matStack, IVertexBuilder buf, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        int currentConfigNumWings = DolAmrothChestplateModel.getNumWings();
        if (this.numWings != currentConfigNumWings) {
            this.numWings = currentConfigNumWings;
            this.recreateBodyAndWings();
        }
        super.func_225598_a_(matStack, buf, packedLight, packedOverlay, r, g, b, a);
    }

    @Override
    public void acceptWearingEntity(LivingEntity entity) {
        boolean shouldSit;
        float partialTicks = LOTRTickHandlerClient.renderPartialTick;
        float limbSwing = 0.0f;
        float limbSwingAmount = 0.0f;
        boolean bl = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        if (!shouldSit && entity.func_70089_S()) {
            limbSwingAmount = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_184618_aE, (float)entity.field_70721_aZ);
            limbSwing = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
            if (entity.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
            limbSwingAmount = Math.min(limbSwingAmount, 1.0f);
        }
        float ageInTicks = (float)entity.field_70173_aa + partialTicks;
        float netHeadYaw = 0.0f;
        float headPitch = 0.0f;
        this.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    @Override
    public void func_225597_a_(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.numWings > 0) {
            float motion = limbSwingAmount;
            float motionPhase = limbSwing;
            if (entity != null && entity.func_184187_bx() instanceof LivingEntity) {
                LivingEntity mount = (LivingEntity)entity.func_184187_bx();
                float tick = LOTRTickHandlerClient.renderPartialTick;
                motion = mount.field_184618_aE + (mount.field_70721_aZ - mount.field_184618_aE) * tick;
                motionPhase = mount.field_184619_aG - mount.field_70721_aZ * (1.0f - tick);
                motion *= 1.5f;
                motionPhase *= 2.0f;
            }
            float wingAngleBase = (float)Math.toRadians(10.0);
            wingAngleBase += MathHelper.func_76126_a((float)(ageInTicks * 0.02f)) * 0.01f;
            wingAngleBase += MathHelper.func_76126_a((float)(motionPhase * 0.2f)) * 0.03f * motion;
            float wingYaw = (float)Math.toRadians(50.0);
            wingYaw += MathHelper.func_76126_a((float)(ageInTicks * 0.03f)) * 0.05f;
            wingYaw += MathHelper.func_76126_a((float)(motionPhase * 0.25f)) * 0.12f * motion;
            for (int i = 0; i < this.wingsRight.length; ++i) {
                float wingAngle;
                float factor = i + 1;
                this.wingsRight[i].field_78808_h = wingAngle = wingAngleBase / (factor / 3.4f);
                this.wingsLeft[i].field_78808_h = -wingAngle;
            }
            this.wingsRight[0].field_78796_g = MathHelper.func_76126_a((float)wingYaw);
            this.wingsRight[0].field_78795_f = MathHelper.func_76134_b((float)wingYaw);
            this.wingsLeft[0].field_78796_g = MathHelper.func_76126_a((float)(-wingYaw));
            this.wingsLeft[0].field_78795_f = MathHelper.func_76134_b((float)(-wingYaw));
        }
    }
}

