/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity.model.armor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lotr.client.render.entity.model.armor.ArnorHelmetModel;
import lotr.client.render.entity.model.armor.DolAmrothChestplateModel;
import lotr.client.render.entity.model.armor.DolAmrothHelmetModel;
import lotr.client.render.entity.model.armor.DorwinionElvenHelmetModel;
import lotr.client.render.entity.model.armor.GaladhrimHelmetModel;
import lotr.client.render.entity.model.armor.GondorHelmetModel;
import lotr.client.render.entity.model.armor.HaradWarlordHelmetModel;
import lotr.client.render.entity.model.armor.HarnennorChestplateModel;
import lotr.client.render.entity.model.armor.HarnennorHelmetModel;
import lotr.client.render.entity.model.armor.HighElvenHelmetModel;
import lotr.client.render.entity.model.armor.ItemStackDependentModel;
import lotr.client.render.entity.model.armor.PlateOnHeadModel;
import lotr.client.render.entity.model.armor.RohanMarshalHelmetModel;
import lotr.client.render.entity.model.armor.SpecialArmorModel;
import lotr.client.render.entity.model.armor.UmbarHelmetModel;
import lotr.client.render.entity.model.armor.UrukHelmetModel;
import lotr.client.render.entity.model.armor.WearerDependentArmorModel;
import lotr.client.render.entity.model.armor.WingedGondorHelmetModel;
import lotr.common.init.LOTRItems;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LOTRArmorModels {
    private static boolean hasSetup = false;
    private static final Map<Item, SpecialArmorModel<?>> specialArmorModels = new HashMap();

    private static void setup() {
        hasSetup = true;
        specialArmorModels.put((Item)LOTRItems.GONDOR_HELMET.get(), new GondorHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.LINDON_HELMET.get(), new HighElvenHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.RIVENDELL_HELMET.get(), new HighElvenHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.GALADHRIM_HELMET.get(), new GaladhrimHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.HARAD_WARLORD_HELMET.get(), new HaradWarlordHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.UMBAR_HELMET.get(), new UmbarHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.URUK_HELMET.get(), new UrukHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.URUK_BERSERKER_HELMET.get(), new UrukHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.DORWINION_ELVEN_HELMET.get(), new DorwinionElvenHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.ROHAN_MARSHAL_HELMET.get(), new RohanMarshalHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.WINGED_GONDOR_HELMET.get(), new WingedGondorHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.HARNENNOR_HELMET.get(), new HarnennorHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.HARNENNOR_CHESTPLATE.get(), new HarnennorChestplateModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.DOL_AMROTH_HELMET.get(), new DolAmrothHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.DOL_AMROTH_CHESTPLATE.get(), new DolAmrothChestplateModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.ARNOR_HELMET.get(), new ArnorHelmetModel(1.0f));
        specialArmorModels.put((Item)LOTRItems.FINE_PLATE.get(), new PlateOnHeadModel());
        specialArmorModels.put((Item)LOTRItems.STONEWARE_PLATE.get(), new PlateOnHeadModel());
        specialArmorModels.put((Item)LOTRItems.WOODEN_PLATE.get(), new PlateOnHeadModel());
    }

    @Nullable
    public static <A extends BipedModel<?>> A getArmorModel(LivingEntity entity, ItemStack itemstack, EquipmentSlotType slot, A _default) {
        Item item;
        if (!hasSetup) {
            LOTRArmorModels.setup();
        }
        if (specialArmorModels.containsKey(item = itemstack.func_77973_b())) {
            BipedModel model = specialArmorModels.get(item);
            if (model instanceof ItemStackDependentModel) {
                ((ItemStackDependentModel)model).setModelItem(itemstack);
            }
            if (model instanceof WearerDependentArmorModel) {
                ((WearerDependentArmorModel)model).acceptWearingEntity(entity);
            }
            return (A)model;
        }
        return null;
    }

    public static void clearNonHelmetParts(BipedModel model) {
        LOTRArmorModels.clearArmorPartsExcept(model, model.field_78116_c);
    }

    public static void clearNonChestplateParts(BipedModel model) {
        LOTRArmorModels.clearArmorPartsExcept(model, model.field_78115_e, model.field_178723_h, model.field_178724_i);
    }

    public static void clearArmorPartsExcept(BipedModel model, ModelRenderer ... exceptions) {
        List<ModelRenderer> exceptList = Arrays.asList(exceptions);
        if (!exceptList.contains(model.field_78116_c)) {
            model.field_78116_c = new ModelRenderer((Model)model, 0, 0);
        }
        if (!exceptList.contains(model.field_178720_f)) {
            model.field_178720_f = new ModelRenderer((Model)model, 0, 0);
        }
        if (!exceptList.contains(model.field_78115_e)) {
            model.field_78115_e = new ModelRenderer((Model)model, 0, 0);
        }
        if (!exceptList.contains(model.field_178723_h)) {
            model.field_178723_h = new ModelRenderer((Model)model, 0, 0);
        }
        if (!exceptList.contains(model.field_178724_i)) {
            model.field_178724_i = new ModelRenderer((Model)model, 0, 0);
        }
        if (!exceptList.contains(model.field_178721_j)) {
            model.field_178721_j = new ModelRenderer((Model)model, 0, 0);
        }
        if (!exceptList.contains(model.field_178722_k)) {
            model.field_178722_k = new ModelRenderer((Model)model, 0, 0);
        }
    }
}

