/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lotr.client.render.model.DynamicTextureResourcePack;
import lotr.client.render.model.connectedtex.ConnectedTextureElement;
import lotr.common.LOTRLog;
import lotr.common.item.VesselType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;

public class DynamicTextureRepository {
    public static final DynamicTextureRepository INSTANCE = new DynamicTextureRepository();
    private final Map<String, DynamicTextureResourcePack> virtualPacks = new HashMap<String, DynamicTextureResourcePack>();
    private final Map<ResourceLocation, List<ResourceLocation>> cachedConnectedLocations = new HashMap<ResourceLocation, List<ResourceLocation>>();
    private final Map<ResourceLocation, Map<VesselType, ResourceLocation>> cachedVesselLocations = new HashMap<ResourceLocation, Map<VesselType, ResourceLocation>>();
    private static final int VESSEL_FILL_COLOR = 0xFF00FF;

    private DynamicTextureRepository() {
    }

    public ResourceLocation getConnectedTexture(ResourceLocation base, Set<ConnectedTextureElement> elements) {
        ResourceLocation cacheKey = DynamicTextureRepository.getConnectedTextureSetCacheKey(base, elements.contains((Object)ConnectedTextureElement.BASE));
        if (!this.cachedConnectedLocations.containsKey(cacheKey)) {
            return MissingTextureSprite.func_195675_b();
        }
        return DynamicTextureRepository.getConnectedTextureLocation(base, elements);
    }

    private static ResourceLocation getConnectedTextureSetCacheKey(ResourceLocation basePath, boolean includeBase) {
        return new ResourceLocation(basePath.func_110624_b(), String.format("%s_%s", basePath.func_110623_a(), includeBase ? "base" : "nobase"));
    }

    private static ResourceLocation getConnectedTextureLocation(ResourceLocation base, Set<ConnectedTextureElement> elements) {
        int key = ConnectedTextureElement.getIconSetKey(elements);
        return new ResourceLocation(base.func_110624_b(), base.func_110623_a() + "_" + key);
    }

    public List<ResourceLocation> generateAllConnectedTextures(ResourceLocation base, boolean isSingleIcon, boolean includeBase) {
        boolean checkResourceExists;
        Minecraft mc = Minecraft.func_71410_x();
        IResourceManager resMgr = mc.func_195551_G();
        String namespace = base.func_110624_b();
        ResourceLocation cacheKeyLocation = DynamicTextureRepository.getConnectedTextureSetCacheKey(base, includeBase);
        if (this.cachedConnectedLocations.containsKey(cacheKeyLocation) && (checkResourceExists = resMgr.func_219533_b(DynamicTextureResourcePack.createDynamicTextureSetIsLoadedMarker(cacheKeyLocation)))) {
            return this.cachedConnectedLocations.get(cacheKeyLocation);
        }
        ArrayList<ResourceLocation> allList = new ArrayList<ResourceLocation>();
        try {
            ResourceLocation baseTextureFullPath = DynamicTextureRepository.convertTextureFullPath(base);
            NativeImage baseImage = NativeImage.func_195713_a((InputStream)resMgr.func_199002_a(baseTextureFullPath).func_199027_b());
            int iconWidth = baseImage.func_195702_a();
            int iconHeight = baseImage.func_195714_b();
            HashMap<ConnectedTextureElement, NativeImage> elementImages = new HashMap<ConnectedTextureElement, NativeImage>();
            for (ConnectedTextureElement elem : ConnectedTextureElement.values()) {
                if (elem == ConnectedTextureElement.BASE) {
                    if (!includeBase) continue;
                    elementImages.put(elem, baseImage);
                    continue;
                }
                if (isSingleIcon) {
                    elementImages.put(elem, this.makePartFromSingleIcon(baseImage, elem));
                    continue;
                }
                ResourceLocation elementPath = DynamicTextureRepository.convertTextureFullPath(new ResourceLocation(base + elem.iconName));
                NativeImage elementImage = NativeImage.func_195713_a((InputStream)resMgr.func_199002_a(elementPath).func_199027_b());
                if (elementImage.func_195702_a() != iconWidth || elementImage.func_195714_b() != iconHeight) {
                    LOTRLog.error("All connected texture icons for %s must have the same dimensions!", base);
                    LOTRLog.error("%s: base icon is %dx%d, but %s icon is %dx%d", base, iconWidth, iconHeight, elem.iconName, elementImage.func_195702_a(), elementImage.func_195714_b());
                    elementImages.put(elem, DynamicTextureRepository.createErroredImage(iconWidth, iconHeight));
                    continue;
                }
                elementImages.put(elem, elementImage);
            }
            Map<Integer, Set<ConnectedTextureElement>> permutationSet = includeBase ? ConnectedTextureElement.ALL_COMBINATIONS_WITH_BASE : ConnectedTextureElement.ALL_COMBINATIONS_WITHOUT_BASE;
            for (Map.Entry<Integer, Set<ConnectedTextureElement>> entry : permutationSet.entrySet()) {
                int key = entry.getKey();
                Set<ConnectedTextureElement> elementSet = entry.getValue();
                List<ConnectedTextureElement> sortedList = ConnectedTextureElement.sortIconSet(elementSet);
                NativeImage connectedImage = new NativeImage(baseImage.func_211678_c(), iconWidth, iconHeight, true);
                if (includeBase) {
                    connectedImage.func_195703_a(baseImage);
                }
                for (ConnectedTextureElement elem : sortedList) {
                    if (elem == ConnectedTextureElement.BASE) continue;
                    NativeImage elementImage = (NativeImage)elementImages.get((Object)elem);
                    for (int x = 0; x < connectedImage.func_195702_a(); ++x) {
                        for (int y = 0; y < connectedImage.func_195714_b(); ++y) {
                            int rgba = elementImage.func_195709_a(x, y);
                            int alpha = rgba >> 24 & 0xFF;
                            if (alpha == 0) continue;
                            connectedImage.func_195700_a(x, y, rgba);
                        }
                    }
                }
                DynamicTexture dynamic = new DynamicTexture(connectedImage);
                ResourceLocation connectedRes = DynamicTextureRepository.getConnectedTextureLocation(base, elementSet);
                ResourceLocation connectedFullPath = DynamicTextureRepository.convertTextureFullPath(connectedRes);
                mc.func_110434_K().func_229263_a_(connectedFullPath, (Texture)dynamic);
                this.getVirtualPack(namespace).addDynamicTexture(cacheKeyLocation, connectedFullPath, dynamic);
                allList.add(connectedRes);
            }
        }
        catch (IOException e) {
            LOTRLog.error("Error generating connected textures for %s", cacheKeyLocation);
            e.printStackTrace();
        }
        this.cachedConnectedLocations.put(cacheKeyLocation, allList);
        return allList;
    }

    private NativeImage makePartFromSingleIcon(NativeImage baseImage, ConnectedTextureElement elem) {
        int sideWidth = 3;
        int sideHeight = 3;
        int fullWidth = 16;
        int fullHeight = 16;
        switch (elem) {
            case SIDE_LEFT: {
                return this.copyAreaFromIcon(baseImage, 0.0, 0.0, 3.0, 16.0);
            }
            case SIDE_RIGHT: {
                return this.copyAreaFromIcon(baseImage, 13.0, 0.0, 16.0, 16.0);
            }
            case SIDE_TOP: {
                return this.copyAreaFromIcon(baseImage, 0.0, 0.0, 16.0, 3.0);
            }
            case SIDE_BOTTOM: {
                return this.copyAreaFromIcon(baseImage, 0.0, 13.0, 16.0, 16.0);
            }
            case CORNER_TOPLEFT: 
            case INVCORNER_TOPLEFT: {
                return this.copyAreaFromIcon(baseImage, 0.0, 0.0, 3.0, 3.0);
            }
            case CORNER_TOPRIGHT: 
            case INVCORNER_TOPRIGHT: {
                return this.copyAreaFromIcon(baseImage, 13.0, 0.0, 16.0, 3.0);
            }
            case CORNER_BOTTOMLEFT: 
            case INVCORNER_BOTTOMLEFT: {
                return this.copyAreaFromIcon(baseImage, 0.0, 13.0, 3.0, 16.0);
            }
            case CORNER_BOTTOMRIGHT: 
            case INVCORNER_BOTTOMRIGHT: {
                return this.copyAreaFromIcon(baseImage, 13.0, 13.0, 3.0, 16.0);
            }
        }
        throw new IllegalArgumentException("Unknown connected texture element " + elem.toString() + "!");
    }

    private NativeImage copyAreaFromIcon(NativeImage baseImage, double x0, double y0, double x1, double y1) {
        int iconWidth = baseImage.func_195702_a();
        int iconHeight = baseImage.func_195714_b();
        NativeImage elementImage = new NativeImage(baseImage.func_211678_c(), iconWidth, iconHeight, true);
        int x0I = (int)Math.round(x0 / 16.0 * (double)iconWidth);
        int x1I = (int)Math.round(x1 / 16.0 * (double)iconWidth);
        int y0I = (int)Math.round(y0 / 16.0 * (double)iconHeight);
        int y1I = (int)Math.round(y1 / 16.0 * (double)iconHeight);
        for (int y = y0I; y < y1I; ++y) {
            for (int x = x0I; x < x1I; ++x) {
                elementImage.func_195700_a(x, y, baseImage.func_195709_a(x, y));
            }
        }
        return elementImage;
    }

    public ResourceLocation getFilledVesselTexture(ResourceLocation liquidTex, VesselType vessel) {
        if (!this.cachedVesselLocations.containsKey(liquidTex)) {
            return MissingTextureSprite.func_195675_b();
        }
        return DynamicTextureRepository.getFilledVesselLocation(liquidTex, vessel);
    }

    public Map<VesselType, ResourceLocation> generateVesselDrinkTextures(ResourceLocation liquidTex) {
        boolean checkResourceExists;
        Minecraft mc = Minecraft.func_71410_x();
        IResourceManager resMgr = mc.func_195551_G();
        String namespace = liquidTex.func_110624_b();
        if (this.cachedVesselLocations.containsKey(liquidTex) && (checkResourceExists = resMgr.func_219533_b(DynamicTextureResourcePack.createDynamicTextureSetIsLoadedMarker(liquidTex)))) {
            return this.cachedVesselLocations.get(liquidTex);
        }
        HashMap<VesselType, ResourceLocation> allMap = new HashMap<VesselType, ResourceLocation>();
        try {
            ResourceLocation liquidTexFullPath = DynamicTextureRepository.convertTextureFullPath(liquidTex);
            NativeImage liquidImage = NativeImage.func_195713_a((InputStream)resMgr.func_199002_a(liquidTexFullPath).func_199027_b());
            int iconWidth = liquidImage.func_195702_a();
            int iconHeight = liquidImage.func_195714_b();
            for (VesselType ves : VesselType.values()) {
                ResourceLocation vesPath = DynamicTextureRepository.convertTextureFullPath(ves.getEmptySpritePath());
                NativeImage vesImage = NativeImage.func_195713_a((InputStream)resMgr.func_199002_a(vesPath).func_199027_b());
                if (iconWidth < vesImage.func_195702_a() || iconHeight < vesImage.func_195714_b()) {
                    LOTRLog.error("The loaded drink liquid icon %s is too small! Must be at least the size of loaded vessel icons, and ideally 2x2x", liquidTex);
                    LOTRLog.error("%s: liquid icon is %dx%d, but %s icon is %dx%d", liquidTex, iconWidth, iconHeight, ves.getEmptyIconName(), vesImage.func_195702_a(), vesImage.func_195714_b());
                    vesImage = DynamicTextureRepository.createErroredImage(iconWidth, iconHeight);
                }
                NativeImage filledDrinkImage = new NativeImage(vesImage.func_211678_c(), vesImage.func_195702_a(), vesImage.func_195714_b(), true);
                filledDrinkImage.func_195703_a(vesImage);
                for (int x = 0; x < filledDrinkImage.func_195702_a(); ++x) {
                    for (int y = 0; y < filledDrinkImage.func_195714_b(); ++y) {
                        int rgb = filledDrinkImage.func_195709_a(x, y) & 0xFFFFFF;
                        if (rgb != 0xFF00FF) continue;
                        int liquidRgba = liquidImage.func_195709_a(x, y);
                        filledDrinkImage.func_195700_a(x, y, liquidRgba);
                    }
                }
                DynamicTexture dynamic = new DynamicTexture(filledDrinkImage);
                ResourceLocation filledRes = DynamicTextureRepository.getFilledVesselLocation(liquidTex, ves);
                ResourceLocation filledFullPath = DynamicTextureRepository.convertTextureFullPath(filledRes);
                mc.func_110434_K().func_229263_a_(filledFullPath, (Texture)dynamic);
                this.getVirtualPack(namespace).addDynamicTexture(liquidTex, filledFullPath, dynamic);
                allMap.put(ves, filledRes);
            }
        }
        catch (IOException e) {
            LOTRLog.error("Error generating filled vessel textures for %s", liquidTex);
            e.printStackTrace();
        }
        this.cachedVesselLocations.put(liquidTex, allMap);
        return allMap;
    }

    private static ResourceLocation getFilledVesselLocation(ResourceLocation liquidTex, VesselType vessel) {
        return new ResourceLocation(liquidTex.func_110624_b(), liquidTex.func_110623_a() + "_" + vessel.getCodeName());
    }

    private static ResourceLocation convertTextureFullPath(ResourceLocation texture) {
        return new ResourceLocation(texture.func_110624_b(), String.format("textures/%s.png", texture.func_110623_a()));
    }

    private static NativeImage createErroredImage(int width, int height) {
        NativeImage errored = new NativeImage(width, height, true);
        for (int x = 0; x < errored.func_195702_a(); ++x) {
            for (int y = 0; y < errored.func_195714_b(); ++y) {
                int rgb = 0;
                rgb = (x + y) % 2 == 0 ? 0xFF0000 : 0;
                errored.func_195700_a(x, y, 0xFF000000 | rgb);
            }
        }
        return errored;
    }

    private DynamicTextureResourcePack getVirtualPack(String namespace) {
        Minecraft mc = Minecraft.func_71410_x();
        SimpleReloadableResourceManager resMgr = (SimpleReloadableResourceManager)mc.func_195551_G();
        DynamicTextureResourcePack pack = this.virtualPacks.get(namespace);
        if (pack == null || pack != null && !resMgr.func_219533_b(pack.packIsLoadedMarkerResource)) {
            pack = new DynamicTextureResourcePack(ResourcePackType.CLIENT_RESOURCES, namespace);
            this.virtualPacks.put(namespace, pack);
            resMgr.func_199021_a((IResourcePack)pack);
        }
        return pack;
    }
}

