/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.connectedtex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Util;

public enum ConnectedTextureElement {
    BASE("", 0),
    SIDE_LEFT("_left", 1),
    SIDE_RIGHT("_right", 1),
    SIDE_TOP("_top", 1),
    SIDE_BOTTOM("_bottom", 1),
    CORNER_TOPLEFT("_top_left", 2),
    CORNER_TOPRIGHT("_top_right", 2),
    CORNER_BOTTOMLEFT("_bottom_left", 2),
    CORNER_BOTTOMRIGHT("_bottom_right", 2),
    INVCORNER_TOPLEFT("_top_left_inv", 2),
    INVCORNER_TOPRIGHT("_top_right_inv", 2),
    INVCORNER_BOTTOMLEFT("_bottom_left_inv", 2),
    INVCORNER_BOTTOMRIGHT("_bottom_right_inv", 2);

    public final String iconName;
    private final int bitFlag;
    private final int priority;
    public static final Map<Integer, Set<ConnectedTextureElement>> ALL_COMBINATIONS_WITHOUT_BASE;
    public static final Map<Integer, Set<ConnectedTextureElement>> ALL_COMBINATIONS_WITH_BASE;
    private static final Comparator<ConnectedTextureElement> COMPARATOR;

    private ConnectedTextureElement(String s, int i) {
        this.iconName = s;
        this.bitFlag = 1 << this.ordinal();
        this.priority = i;
    }

    public static int getIconSetKey(Set<ConnectedTextureElement> set) {
        int i = 0;
        for (ConnectedTextureElement e : set) {
            i |= e.bitFlag;
        }
        return i;
    }

    public static List<ConnectedTextureElement> sortIconSet(Set<ConnectedTextureElement> set) {
        ArrayList<ConnectedTextureElement> list = new ArrayList<ConnectedTextureElement>(set);
        Collections.sort(list, COMPARATOR);
        return list;
    }

    static {
        ALL_COMBINATIONS_WITHOUT_BASE = (Map)Util.func_200696_a(new HashMap(), map -> {
            ArrayList<EnumSet<ConnectedTextureElement>> combinations = new ArrayList<EnumSet<ConnectedTextureElement>>();
            boolean[] trueOrFalse = new boolean[]{false, true};
            for (boolean left : trueOrFalse) {
                for (boolean right : trueOrFalse) {
                    for (boolean top : trueOrFalse) {
                        for (boolean bottom : trueOrFalse) {
                            for (boolean topLeft : trueOrFalse) {
                                for (boolean topRight : trueOrFalse) {
                                    for (boolean bottomLeft : trueOrFalse) {
                                        for (boolean bottomRight : trueOrFalse) {
                                            for (boolean topLeftInv : trueOrFalse) {
                                                for (boolean topRightInv : trueOrFalse) {
                                                    for (boolean bottomLeftInv : trueOrFalse) {
                                                        for (boolean bottomRightInv : trueOrFalse) {
                                                            boolean addBottom;
                                                            EnumSet<ConnectedTextureElement> set = EnumSet.noneOf(ConnectedTextureElement.class);
                                                            boolean addLeft = !(!left || top && !topLeft || bottom && !bottomLeft);
                                                            boolean addRight = !(!right || top && !topRight || bottom && !bottomRight);
                                                            boolean addTop = !(!top || left && !topLeft || right && !topRight);
                                                            boolean bl = addBottom = !(!bottom || left && !bottomLeft || right && !bottomRight);
                                                            if (addLeft) {
                                                                set.add(SIDE_LEFT);
                                                            }
                                                            if (addRight) {
                                                                set.add(SIDE_RIGHT);
                                                            }
                                                            if (addTop) {
                                                                set.add(SIDE_TOP);
                                                            }
                                                            if (addBottom) {
                                                                set.add(SIDE_BOTTOM);
                                                            }
                                                            if (topLeft && addTop && addLeft) {
                                                                set.add(CORNER_TOPLEFT);
                                                            }
                                                            if (topRight && addTop && addRight) {
                                                                set.add(CORNER_TOPRIGHT);
                                                            }
                                                            if (bottomLeft && addBottom && addLeft) {
                                                                set.add(CORNER_BOTTOMLEFT);
                                                            }
                                                            if (bottomRight && addBottom && addRight) {
                                                                set.add(CORNER_BOTTOMRIGHT);
                                                            }
                                                            if (topLeftInv && !topLeft && !addTop && !addLeft) {
                                                                set.add(INVCORNER_TOPLEFT);
                                                            }
                                                            if (topRightInv && !topRight && !addTop && !addRight) {
                                                                set.add(INVCORNER_TOPRIGHT);
                                                            }
                                                            if (bottomLeftInv && !bottomLeft && !addBottom && !addLeft) {
                                                                set.add(INVCORNER_BOTTOMLEFT);
                                                            }
                                                            if (bottomRightInv && !bottomRight && !addBottom && !addRight) {
                                                                set.add(INVCORNER_BOTTOMRIGHT);
                                                            }
                                                            combinations.add(set);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            Object object = combinations.iterator();
            while (object.hasNext()) {
                Set iconSet = (Set)object.next();
                int key = ConnectedTextureElement.getIconSetKey(iconSet);
                if (map.containsKey(key)) continue;
                map.put(key, iconSet);
            }
        });
        ALL_COMBINATIONS_WITH_BASE = (Map)Util.func_200696_a(new HashMap(), map -> {
            for (Set<ConnectedTextureElement> iconSet : ALL_COMBINATIONS_WITHOUT_BASE.values()) {
                EnumSet<ConnectedTextureElement> iconSetWithBase = EnumSet.copyOf(iconSet);
                iconSetWithBase.add(BASE);
                map.put(ConnectedTextureElement.getIconSetKey(iconSetWithBase), iconSetWithBase);
            }
        });
        COMPARATOR = (e1, e2) -> {
            if (e1.priority == e2.priority) {
                return e1.compareTo(e2);
            }
            return Integer.valueOf(e1.priority).compareTo(e2.priority);
        };
    }
}

