/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.model.scatter;

import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class ScatterPositionContext
implements IModelData {
    private final long positionHash;

    private ScatterPositionContext(long hash) {
        this.positionHash = hash;
    }

    public static ScatterPositionContext newEmptyContext() {
        return new ScatterPositionContext(0L);
    }

    public static ScatterPositionContext forPosition(IBlockDisplayReader world, BlockPos pos, BlockState state) {
        long hash = MathHelper.func_180186_a((Vector3i)pos);
        return new ScatterPositionContext(hash);
    }

    public long getPositionHash() {
        return this.positionHash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            ScatterPositionContext otherData = (ScatterPositionContext)other;
            return this.positionHash == otherData.positionHash;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.positionHash);
    }

    public String toString() {
        return String.format("ScatterPositionContext[%d]", this.positionHash);
    }

    public boolean hasProperty(ModelProperty<?> prop) {
        return false;
    }

    public <T> T getData(ModelProperty<T> prop) {
        return null;
    }

    public <T> T setData(ModelProperty<T> prop, T data) {
        return null;
    }
}

