/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import lotr.client.render.model.PlateFoodModels;
import lotr.common.entity.capabilities.PlateFallingData;
import lotr.common.tileentity.PlateTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.LazyOptional;

public class PlateTileEntityRenderer<T extends PlateTileEntity>
extends TileEntityRenderer<T> {
    private Random rand = new Random(42984194L);

    public PlateTileEntityRenderer(TileEntityRendererDispatcher disp) {
        super(disp);
    }

    public void render(T plate, float partialTicks, MatrixStack matStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        ItemStack plateItem = ((PlateTileEntity)((Object)plate)).getFoodItem();
        LazyOptional<PlateFallingData> fallingData = ((PlateTileEntity)((Object)plate)).getFallingDataForRender();
        float plateFallOffset = fallingData.map(d -> Float.valueOf(d.getPlateOffsetY(partialTicks))).orElse(Float.valueOf(0.0f)).floatValue();
        if (!plateItem.func_190926_b()) {
            matStack.func_227860_a_();
            RenderSystem.disableCull();
            RenderSystem.enableRescaleNormal();
            matStack.func_227861_a_(0.5, 0.0, 0.5);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            PlateFoodModels.ModelAndHeight specialItemModel = PlateFoodModels.INSTANCE.getSpecialModel(plateItem.func_77973_b());
            float itemHeight = PlateTileEntityRenderer.getItemHeight(plateItem, specialItemModel, true);
            int foods = plateItem.func_190916_E();
            float lowerOffset = 0.125f;
            for (int foodSlot = 0; foodSlot < foods; ++foodSlot) {
                matStack.func_227860_a_();
                int foodSlotFinal = foodSlot;
                float offset = fallingData.map(d -> Float.valueOf(d.getFoodOffsetY(foodSlotFinal, partialTicks))).orElse(Float.valueOf(0.0f)).floatValue();
                offset = Math.max(offset, lowerOffset);
                matStack.func_227861_a_(0.0, (double)offset, 0.0);
                lowerOffset = offset + itemHeight;
                this.rand.setSeed((long)(plate.func_174877_v().func_177958_n() * 3129871) ^ (long)plate.func_174877_v().func_177952_p() * 116129781L ^ (long)plate.func_174877_v().func_177956_o() + (long)foodSlot * 5930563L);
                matStack.func_227861_a_(0.0, 0.03125, 0.0);
                float rotation = this.rand.nextFloat() * 360.0f;
                matStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
                matStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                matStack.func_227862_a_(0.5625f, 0.5625f, 0.5625f);
                if (specialItemModel != null) {
                    IBakedModel model = itemRenderer.func_175037_a().func_178083_a().getModel(specialItemModel.modelRes);
                    matStack.func_227860_a_();
                    model = ForgeHooksClient.handleCameraTransforms((MatrixStack)matStack, (IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.FIXED, (boolean)false);
                    matStack.func_227861_a_(-0.5, -0.5, -0.5);
                    matStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                    matStack.func_227861_a_(0.0, -0.55, 0.0);
                    RenderType renderType = RenderType.func_228643_e_();
                    IVertexBuilder vertBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)renderType, (boolean)true, (boolean)plateItem.func_77962_s());
                    Random itemRenderRand = new Random();
                    long seed = 42L;
                    for (Direction direction : Direction.values()) {
                        itemRenderRand.setSeed(seed);
                        itemRenderer.func_229112_a_(matStack, vertBuilder, model.getQuads(null, direction, itemRenderRand, null), plateItem, combinedLight, combinedOverlay);
                    }
                    itemRenderRand.setSeed(seed);
                    itemRenderer.func_229112_a_(matStack, vertBuilder, model.getQuads(null, (Direction)null, itemRenderRand, null), plateItem, combinedLight, combinedOverlay);
                    matStack.func_227865_b_();
                } else {
                    itemRenderer.func_229110_a_(plateItem, ItemCameraTransforms.TransformType.FIXED, combinedLight, combinedOverlay, matStack, buffer);
                }
                matStack.func_227865_b_();
            }
            RenderSystem.disableRescaleNormal();
            RenderSystem.enableCull();
            matStack.func_227865_b_();
        }
    }

    public static float getItemHeight(ItemStack plateItem) {
        return PlateTileEntityRenderer.getItemHeight(plateItem, null, false);
    }

    private static float getItemHeight(ItemStack plateItem, PlateFoodModels.ModelAndHeight suppliedModel, boolean useSupplied) {
        if (!useSupplied) {
            suppliedModel = PlateFoodModels.INSTANCE.getSpecialModel(plateItem.func_77973_b());
        }
        float itemHeight = suppliedModel != null ? suppliedModel.height : 0.03125f;
        return itemHeight;
    }
}

