/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.world;

import lotr.client.render.world.MiddleEarthCloudRenderer;
import lotr.client.render.world.MiddleEarthSkyRenderer;
import lotr.client.render.world.MiddleEarthWeatherRenderer;
import lotr.common.LOTRMod;
import lotr.common.config.LOTRConfig;
import lotr.common.init.LOTRBiomes;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public abstract class LOTRDimensionRenderInfo
extends DimensionRenderInfo {
    private int skyR;
    private int skyG;
    private int skyB;
    private double cloudR;
    private double cloudG;
    private double cloudB;
    private static final float PINKISH_CLOUDS_BEGIN_BRIGHT = 0.98f;
    private static final float PINKISH_CLOUDS_MAX_BRIGHT = 0.8f;
    private static final float PINKISH_CLOUDS_MAX_DARK = 0.5f;
    private static final float PINKISH_CLOUDS_BEGIN_DARK = 0.2f;
    private static final float PINKISH_CLOUDS_BRIGHT_MIN = 0.2f;
    private static final double[] PINKISH_CLOUDS_RGB_MULTIPLIER = new double[]{1.07, 0.85, 1.07};

    public LOTRDimensionRenderInfo(float cloudHeight, boolean isSkyColored, DimensionRenderInfo.FogType fogType) {
        super(cloudHeight, isSkyColored, fogType, false, false);
        if (((Boolean)LOTRConfig.CLIENT.modSky.get()).booleanValue()) {
            this.setSkyRenderHandler(new MiddleEarthSkyRenderer());
        }
        if (((Boolean)LOTRConfig.CLIENT.modClouds.get()).booleanValue()) {
            this.setCloudRenderHandler(new MiddleEarthCloudRenderer());
        }
        if (((Boolean)LOTRConfig.CLIENT.newWeatherRendering.get()).booleanValue()) {
            this.setWeatherRenderHandler(new MiddleEarthWeatherRenderer());
        }
    }

    private World getClientWorld() {
        return LOTRMod.PROXY.getClientWorld();
    }

    public Vector3d func_230494_a_(Vector3d fogRgb, float partialTicks) {
        return fogRgb.func_216372_d((double)(partialTicks * 0.94f + 0.06f), (double)(partialTicks * 0.94f + 0.06f), (double)(partialTicks * 0.91f + 0.09f));
    }

    public boolean func_230493_a_(int x, int z) {
        World world = this.getClientWorld();
        Biome biome = world.func_226691_t_(new BlockPos(x, 0, z));
        return LOTRBiomes.getWrapperFor(biome, (IWorld)world).isFoggy();
    }

    private int getBiomeBlendDistance() {
        Minecraft mc = Minecraft.func_71410_x();
        GameSettings settings = mc.field_71474_y;
        int distance = 0;
        if (mc.func_71375_t()) {
            distance = Math.min(settings.field_151451_c * 2, 36);
        }
        return distance;
    }

    private int getBlendedBiomeSkyColor(World world, BlockPos pos, float partialTicks) {
        int distance = this.getBiomeBlendDistance();
        this.skyB = 0;
        this.skyG = 0;
        this.skyR = 0;
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Biome biome = world.func_226691_t_(pos.func_177982_a(x, 0, z));
                int skyHere = biome.func_225529_c_();
                this.skyR += skyHere >> 16 & 0xFF;
                this.skyG += skyHere >> 8 & 0xFF;
                this.skyB += skyHere & 0xFF;
                ++count;
            }
        }
        this.skyR /= count;
        this.skyG /= count;
        this.skyB /= count;
        return this.skyR << 16 | this.skyG << 8 | this.skyB;
    }

    public Vector3d getBlendedCompleteSkyColor(ClientWorld world, BlockPos pos, float partialTicks) {
        int lightningFlash;
        float thunder;
        float celestialAngleRadians = world.func_72929_e(partialTicks);
        float dayBright = MathHelper.func_76134_b((float)celestialAngleRadians) * 2.0f + 0.5f;
        dayBright = MathHelper.func_76131_a((float)dayBright, (float)0.0f, (float)1.0f);
        int biomeSky = this.getBlendedBiomeSkyColor((World)world, pos, partialTicks);
        float r = (float)(biomeSky >> 16 & 0xFF) / 255.0f;
        float g = (float)(biomeSky >> 8 & 0xFF) / 255.0f;
        float b = (float)(biomeSky & 0xFF) / 255.0f;
        r *= dayBright;
        g *= dayBright;
        b *= dayBright;
        float rain = world.func_72867_j(partialTicks);
        if (rain > 0.0f) {
            float rainLerp = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float rainBright = 1.0f - rain * 0.75f;
            r = r * rainBright + rainLerp * (1.0f - rainBright);
            g = g * rainBright + rainLerp * (1.0f - rainBright);
            b = b * rainBright + rainLerp * (1.0f - rainBright);
        }
        if ((thunder = world.func_72819_i(partialTicks)) > 0.0f) {
            float thunderLerp = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
            float thunderBright = 1.0f - thunder * 0.75f;
            r = r * thunderBright + thunderLerp * (1.0f - thunderBright);
            g = g * thunderBright + thunderLerp * (1.0f - thunderBright);
            b = b * thunderBright + thunderLerp * (1.0f - thunderBright);
        }
        if ((lightningFlash = world.func_228332_n_()) > 0) {
            float lightningFlashF = (float)lightningFlash - partialTicks;
            lightningFlashF = Math.min(lightningFlashF, 1.0f);
            r = r * (1.0f - (lightningFlashF *= 0.45f)) + 0.8f * lightningFlashF;
            g = g * (1.0f - lightningFlashF) + 0.8f * lightningFlashF;
            b = b * (1.0f - lightningFlashF) + 1.0f * lightningFlashF;
        }
        return new Vector3d((double)r, (double)g, (double)b);
    }

    public float getSkyFeatureBrightness(World world, BlockPos pos, float partialTicks) {
        int distance = this.getBiomeBlendDistance();
        float totalBrightness = 0.0f;
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Biome biome = world.func_226691_t_(pos.func_177982_a(x, 0, z));
                boolean hasSky = LOTRBiomes.getWrapperFor(biome, (IWorld)world).hasSkyFeatures();
                float skyBr = hasSky ? 1.0f : 0.0f;
                totalBrightness += skyBr;
                ++count;
            }
        }
        return totalBrightness /= (float)count;
    }

    public Vector3d getBlendedCompleteCloudColor(ClientWorld world, BlockPos pos, float partialTicks) {
        int distance = this.getBiomeBlendDistance();
        Vector3d clouds = this.getBaseCloudColor(world, partialTicks);
        this.cloudB = 0.0;
        this.cloudG = 0.0;
        this.cloudR = 0.0;
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Vector3d tempClouds = new Vector3d(clouds.field_72450_a, clouds.field_72448_b, clouds.field_72449_c);
                Biome biome = world.func_226691_t_(pos.func_177982_a(x, 0, z));
                tempClouds = LOTRBiomes.getWrapperFor(biome, (IWorld)world).alterCloudColor(tempClouds);
                this.cloudR += tempClouds.field_72450_a;
                this.cloudG += tempClouds.field_72448_b;
                this.cloudB += tempClouds.field_72449_c;
                ++count;
            }
        }
        this.cloudR /= (double)count;
        this.cloudG /= (double)count;
        this.cloudB /= (double)count;
        return new Vector3d(this.cloudR, this.cloudG, this.cloudB);
    }

    private Vector3d getBaseCloudColor(ClientWorld world, float partialTicks) {
        Vector3d normalClouds = world.func_228328_h_(partialTicks);
        return this.modifyCloudColorForSunriseSunset(normalClouds, world, partialTicks);
    }

    private Vector3d modifyCloudColorForSunriseSunset(Vector3d normalClouds, ClientWorld world, float partialTicks) {
        double[] rgb = new double[]{normalClouds.field_72450_a, normalClouds.field_72448_b, normalClouds.field_72449_c};
        float celestialAngleRadians = world.func_72929_e(partialTicks);
        float dayBright = MathHelper.func_76134_b((float)celestialAngleRadians) * 2.0f + 0.5f;
        if ((dayBright = MathHelper.func_76131_a((float)dayBright, (float)0.0f, (float)1.0f)) >= 0.2f && dayBright <= 0.98f) {
            float pinkishness = dayBright >= 0.5f && dayBright <= 0.8f ? 1.0f : (dayBright < 0.5f ? (dayBright - 0.2f) / 0.3f : (0.98f - dayBright) / 0.18f);
            for (int i = 0; i < rgb.length; ++i) {
                double rgbElem = rgb[i];
                rgbElem *= MathHelper.func_219803_d((double)pinkishness, (double)1.0, (double)PINKISH_CLOUDS_RGB_MULTIPLIER[i]);
                rgb[i] = rgbElem = MathHelper.func_151237_a((double)rgbElem, (double)0.0, (double)1.0);
            }
        }
        return new Vector3d(rgb[0], rgb[1], rgb[2]);
    }

    public float getCloudCoverage(World world, BlockPos pos, float partialTicks) {
        int distance = this.getBiomeBlendDistance();
        float cloudCoverage = 0.0f;
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                Biome biome = world.func_226691_t_(pos.func_177982_a(x, 0, z));
                float coverageHere = LOTRBiomes.getWrapperFor(biome, (IWorld)world).getCloudCoverage();
                cloudCoverage += coverageHere;
                ++count;
            }
        }
        return cloudCoverage /= (float)count;
    }

    public float[] modifyFogIntensity(float farPlane, FogRenderer.FogType fogType, Entity viewer) {
        int distance = this.getBiomeBlendDistance();
        float fogStart = 0.0f;
        float fogEnd = 0.0f;
        BlockPos viewerPos = viewer.func_233580_cy_();
        int count = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                float thisFogStart = 0.0f;
                float thisFogEnd = 0.0f;
                boolean nearFog = this.func_230493_a_(viewerPos.func_177958_n() + x, viewerPos.func_177952_p() + z);
                if (nearFog) {
                    thisFogStart = farPlane * 0.05f;
                    thisFogEnd = Math.min(farPlane, 192.0f) * 0.5f;
                } else if (fogType == FogRenderer.FogType.FOG_SKY) {
                    thisFogStart = 0.0f;
                    thisFogEnd = farPlane;
                } else {
                    thisFogStart = farPlane * 0.75f;
                    thisFogEnd = farPlane;
                }
                fogStart += thisFogStart;
                fogEnd += thisFogEnd;
                ++count;
            }
        }
        return new float[]{fogStart /= (float)count, fogEnd /= (float)count};
    }
}

