/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.world;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import lotr.common.init.LOTRBiomes;
import lotr.common.world.biome.ExtendedWeatherType;
import lotr.common.world.biome.LOTRBiomeBase;
import lotr.common.world.biome.LOTRBiomeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.client.IWeatherRenderHandler;

public class MiddleEarthWeatherRenderer
implements IWeatherRenderHandler {
    private static final ResourceLocation RAIN_TEXTURE = new ResourceLocation("lotr", "textures/weather/rain.png");
    private static final ResourceLocation SNOW_TEXTURE = new ResourceLocation("lotr", "textures/weather/snow.png");
    private static final ResourceLocation ASH_TEXTURE = new ResourceLocation("lotr", "textures/weather/ash.png");
    private static final ResourceLocation SANDSTORM_TEXTURE = new ResourceLocation("lotr", "textures/weather/sandstorm.png");
    private static final int RAIN_COORDS_SCALE = 5;
    private static final int RAIN_COORDS_SIZE = 32;
    private static final int RAIN_COORDS_SIZE_SQ = 1024;
    private final float[] rainCoordsX = new float[1024];
    private final float[] rainCoordsZ = new float[1024];

    public MiddleEarthWeatherRenderer() {
        this.setupRainCoords();
    }

    private void setupRainCoords() {
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                float xf = z - 16;
                float zf = x - 16;
                float dist = MathHelper.func_76129_c((float)(xf * xf + zf * zf));
                this.rainCoordsX[x << 5 | z] = -zf / dist;
                this.rainCoordsZ[x << 5 | z] = xf / dist;
            }
        }
    }

    public void render(int fullTicks, float partialTicks, ClientWorld world, Minecraft mc, LightTexture lightmap, double xIn, double yIn, double zIn) {
        float f = mc.field_71441_e.func_72867_j(partialTicks);
        if (!(f <= 0.0f)) {
            lightmap.func_205109_c();
            int x = MathHelper.func_76128_c((double)xIn);
            int y = MathHelper.func_76128_c((double)yIn);
            int z = MathHelper.func_76128_c((double)zIn);
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder buf = tess.func_178180_c();
            RenderSystem.disableCull();
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            int rainRange = 5;
            if (mc.func_71375_t()) {
                rainRange = 10;
            }
            int drawn = -1;
            float tick = (float)fullTicks + partialTicks;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean isChristmas = LOTRBiomeBase.isSnowEverywhereForChristmas();
            BlockPos.Mutable movingPos = new BlockPos.Mutable();
            for (int z1 = z - rainRange; z1 <= z + rainRange; ++z1) {
                for (int x1 = x - rainRange; x1 <= x + rainRange; ++x1) {
                    int k4;
                    int j4;
                    int i4;
                    int l3;
                    int k3;
                    float f9;
                    double d5;
                    double d3;
                    float f7;
                    int rainIndex = (z1 - z + 16) * 32 + x1 - x + 16;
                    double rainX = (double)this.rainCoordsX[rainIndex] * 0.5;
                    double rainZ = (double)this.rainCoordsZ[rainIndex] * 0.5;
                    movingPos.func_181079_c(x1, 0, z1);
                    Biome biome = world.func_226691_t_((BlockPos)movingPos);
                    LOTRBiomeWrapper biomeWrapper = LOTRBiomes.getWrapperFor(biome, (IWorld)world);
                    Biome.RainType rainType = biomeWrapper.getPrecipitationForRendering();
                    ExtendedWeatherType extWeatherType = biomeWrapper.getExtendedWeatherForRendering();
                    if (rainType == Biome.RainType.NONE && extWeatherType == ExtendedWeatherType.NONE) continue;
                    int rainHeight = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)movingPos).func_177956_o();
                    int rainMinY = y - rainRange;
                    int rainMaxY = y + rainRange;
                    if (rainMinY < rainHeight) {
                        rainMinY = rainHeight;
                    }
                    if (rainMaxY < rainHeight) {
                        rainMaxY = rainHeight;
                    }
                    int l2 = rainHeight;
                    if (rainHeight < y) {
                        l2 = y;
                    }
                    if (rainMinY == rainMaxY) continue;
                    Random rand = new Random(x1 * x1 * 3121 + x1 * 45238971 ^ z1 * z1 * 418711 + z1 * 13761);
                    movingPos.func_181079_c(x1, rainMinY, z1);
                    float temp = biomeWrapper.getTemperatureForSnowWeatherRendering((IWorld)world, (BlockPos)movingPos);
                    if (extWeatherType == ExtendedWeatherType.ASHFALL) {
                        if (drawn != 1) {
                            if (drawn >= 0) {
                                tess.func_78381_a();
                            }
                            drawn = 1;
                            mc.func_110434_K().func_110577_a(ASH_TEXTURE);
                            buf.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        float f6 = -((float)(fullTicks & 0x1FF) + partialTicks) / 512.0f;
                        f7 = (float)(rand.nextDouble() * (double)0.3f + (double)tick * 0.003 * (double)((float)rand.nextGaussian()));
                        float f8 = (float)(rand.nextDouble() + (double)(tick * (float)rand.nextGaussian()) * 0.001);
                        d3 = (double)((float)x1 + 0.5f) - xIn;
                        d5 = (double)((float)z1 + 0.5f) - zIn;
                        f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / (float)rainRange;
                        float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                        movingPos.func_181079_c(x1, l2, z1);
                        k3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)movingPos);
                        l3 = k3 >> 16 & 0xFFFF;
                        i4 = (k3 & 0xFFFF) * 3;
                        j4 = (l3 * 3 + 240) / 4;
                        k4 = (i4 * 3 + 240) / 4;
                        buf.func_225582_a_((double)x1 - xIn - rainX + 0.5, (double)rainMaxY - yIn, (double)z1 - zIn - rainZ + 0.5).func_225583_a_(0.0f + f7, (float)rainMinY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                        buf.func_225582_a_((double)x1 - xIn + rainX + 0.5, (double)rainMaxY - yIn, (double)z1 - zIn + rainZ + 0.5).func_225583_a_(1.0f + f7, (float)rainMinY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                        buf.func_225582_a_((double)x1 - xIn + rainX + 0.5, (double)rainMinY - yIn, (double)z1 - zIn + rainZ + 0.5).func_225583_a_(1.0f + f7, (float)rainMaxY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                        buf.func_225582_a_((double)x1 - xIn - rainX + 0.5, (double)rainMinY - yIn, (double)z1 - zIn - rainZ + 0.5).func_225583_a_(0.0f + f7, (float)rainMaxY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                        continue;
                    }
                    if (extWeatherType == ExtendedWeatherType.SANDSTORM) {
                        if (drawn != 1) {
                            if (drawn >= 0) {
                                tess.func_78381_a();
                            }
                            drawn = 1;
                            mc.func_110434_K().func_110577_a(SANDSTORM_TEXTURE);
                            buf.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        float f6 = -((float)(fullTicks & 0x1FF) + partialTicks) / 512.0f;
                        f7 = tick * (0.07f + (float)rand.nextGaussian() * 0.01f);
                        float f8 = (float)(rand.nextDouble() + (double)(tick * (float)rand.nextGaussian()) * 0.001);
                        d3 = (double)((float)x1 + 0.5f) - xIn;
                        d5 = (double)((float)z1 + 0.5f) - zIn;
                        f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / (float)rainRange;
                        float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                        movingPos.func_181079_c(x1, l2, z1);
                        k3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)movingPos);
                        l3 = k3 >> 16 & 0xFFFF;
                        i4 = (k3 & 0xFFFF) * 3;
                        j4 = (l3 * 3 + 240) / 4;
                        k4 = (i4 * 3 + 240) / 4;
                        buf.func_225582_a_((double)x1 - xIn - rainX + 0.5, (double)rainMaxY - yIn, (double)z1 - zIn - rainZ + 0.5).func_225583_a_(0.0f + f7, (float)rainMinY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                        buf.func_225582_a_((double)x1 - xIn + rainX + 0.5, (double)rainMaxY - yIn, (double)z1 - zIn + rainZ + 0.5).func_225583_a_(1.0f + f7, (float)rainMinY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                        buf.func_225582_a_((double)x1 - xIn + rainX + 0.5, (double)rainMinY - yIn, (double)z1 - zIn + rainZ + 0.5).func_225583_a_(1.0f + f7, (float)rainMaxY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                        buf.func_225582_a_((double)x1 - xIn - rainX + 0.5, (double)rainMinY - yIn, (double)z1 - zIn - rainZ + 0.5).func_225583_a_(0.0f + f7, (float)rainMaxY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                        continue;
                    }
                    if (!isChristmas && temp >= 0.15f) {
                        if (drawn != 0) {
                            if (drawn >= 0) {
                                tess.func_78381_a();
                            }
                            drawn = 0;
                            mc.func_110434_K().func_110577_a(RAIN_TEXTURE);
                            buf.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                        }
                        int i3 = fullTicks + x1 * x1 * 3121 + x1 * 45238971 + z1 * z1 * 418711 + z1 * 13761 & 0x1F;
                        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + rand.nextFloat());
                        double d2 = (double)((float)x1 + 0.5f) - xIn;
                        double d4 = (double)((float)z1 + 0.5f) - zIn;
                        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d4 * d4)) / (float)rainRange;
                        float f5 = ((1.0f - f4 * f4) * 0.5f + 0.5f) * f;
                        movingPos.func_181079_c(x1, l2, z1);
                        int j3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)movingPos);
                        buf.func_225582_a_((double)x1 - xIn - rainX + 0.5, (double)rainMaxY - yIn, (double)z1 - zIn - rainZ + 0.5).func_225583_a_(0.0f, (float)rainMinY * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        buf.func_225582_a_((double)x1 - xIn + rainX + 0.5, (double)rainMaxY - yIn, (double)z1 - zIn + rainZ + 0.5).func_225583_a_(1.0f, (float)rainMinY * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        buf.func_225582_a_((double)x1 - xIn + rainX + 0.5, (double)rainMinY - yIn, (double)z1 - zIn + rainZ + 0.5).func_225583_a_(1.0f, (float)rainMaxY * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        buf.func_225582_a_((double)x1 - xIn - rainX + 0.5, (double)rainMinY - yIn, (double)z1 - zIn - rainZ + 0.5).func_225583_a_(0.0f, (float)rainMaxY * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, f5).func_227886_a_(j3).func_181675_d();
                        continue;
                    }
                    if (drawn != 1) {
                        if (drawn >= 0) {
                            tess.func_78381_a();
                        }
                        drawn = 1;
                        mc.func_110434_K().func_110577_a(SNOW_TEXTURE);
                        buf.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    float f6 = -((float)(fullTicks & 0x1FF) + partialTicks) / 512.0f;
                    f7 = (float)(rand.nextDouble() + (double)tick * 0.01 * (double)((float)rand.nextGaussian()));
                    float f8 = (float)(rand.nextDouble() + (double)(tick * (float)rand.nextGaussian()) * 0.001);
                    d3 = (double)((float)x1 + 0.5f) - xIn;
                    d5 = (double)((float)z1 + 0.5f) - zIn;
                    f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / (float)rainRange;
                    float f10 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * f;
                    movingPos.func_181079_c(x1, l2, z1);
                    k3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)movingPos);
                    l3 = k3 >> 16 & 0xFFFF;
                    i4 = (k3 & 0xFFFF) * 3;
                    j4 = (l3 * 3 + 240) / 4;
                    k4 = (i4 * 3 + 240) / 4;
                    buf.func_225582_a_((double)x1 - xIn - rainX + 0.5, (double)rainMaxY - yIn, (double)z1 - zIn - rainZ + 0.5).func_225583_a_(0.0f + f7, (float)rainMinY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    buf.func_225582_a_((double)x1 - xIn + rainX + 0.5, (double)rainMaxY - yIn, (double)z1 - zIn + rainZ + 0.5).func_225583_a_(1.0f + f7, (float)rainMinY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    buf.func_225582_a_((double)x1 - xIn + rainX + 0.5, (double)rainMinY - yIn, (double)z1 - zIn + rainZ + 0.5).func_225583_a_(1.0f + f7, (float)rainMaxY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                    buf.func_225582_a_((double)x1 - xIn - rainX + 0.5, (double)rainMinY - yIn, (double)z1 - zIn - rainZ + 0.5).func_225583_a_(0.0f + f7, (float)rainMaxY * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, f10).func_225587_b_(k4, j4).func_181675_d();
                }
            }
            if (drawn >= 0) {
                tess.func_78381_a();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultAlphaFunc();
            lightmap.func_205108_b();
        }
    }
}

