/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.sound;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import lotr.client.sound.AmbientSoundNoAttenuation;
import lotr.common.LOTRLog;
import lotr.common.config.LOTRConfig;
import lotr.common.dim.LOTRDimensionType;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRSoundEvents;
import lotr.common.world.biome.ExtendedWeatherType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.LocatableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LOTRAmbience {
    private List<ISound> playingWindSounds = new ArrayList<ISound>();
    private static final int MAX_WIND_SOUNDS = 4;

    public LOTRAmbience() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        ISound sound = event.getSound();
        if (sound instanceof SimpleSound) {
            SimpleSound simpleSound = (SimpleSound)sound;
            ResourceLocation name = simpleSound.func_147650_b();
            Minecraft mc = Minecraft.func_71410_x();
            ClientWorld world = mc.field_71441_e;
            if (world != null && world.func_230315_m_() instanceof LOTRDimensionType) {
                if (name.equals((Object)SoundEvents.field_187918_gr.func_187503_a())) {
                    event.setResultSound((ISound)this.copySoundPropertiesToNew(simpleSound, LOTRSoundEvents.NEW_RAIN));
                } else if (name.equals((Object)SoundEvents.field_187754_de.func_187503_a())) {
                    event.setResultSound((ISound)this.copySoundPropertiesToNew(simpleSound, LOTRSoundEvents.NEW_THUNDER));
                }
            }
        }
    }

    private SimpleSound copySoundPropertiesToNew(SimpleSound srcSound, SoundEvent newSoundLocation) {
        float actualVolume = 1.0f;
        float actualPitch = 1.0f;
        try {
            actualVolume = ObfuscationReflectionHelper.findField(LocatableSound.class, (String)"field_147662_b").getFloat(srcSound);
            actualPitch = ObfuscationReflectionHelper.findField(LocatableSound.class, (String)"field_147663_c").getFloat(srcSound);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOTRLog.error("Failed to retrieve sound properties for replacement sound");
            e.printStackTrace();
        }
        return new SimpleSound(newSoundLocation.func_187503_a(), srcSound.func_184365_d(), actualVolume, actualPitch, srcSound.func_147657_c(), srcSound.func_147652_d(), srcSound.func_147656_j(), srcSound.func_147649_g(), srcSound.func_147654_h(), srcSound.func_147651_i(), srcSound.func_217861_m());
    }

    public void updateAmbience(Minecraft mc, World world, PlayerEntity player) {
        IProfiler profiler = world.func_217381_Z();
        profiler.func_76320_a("lotrAmbience");
        SoundHandler soundHandler = mc.func_147118_V();
        Random rand = world.field_73012_v;
        double xD = player.func_226277_ct_();
        double yD = player.func_226278_cu_();
        double zD = player.func_226281_cx_();
        BlockPos pos = player.func_233580_cy_();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean isLOTRDimension = world.func_230315_m_() instanceof LOTRDimensionType;
        if (isLOTRDimension && ((Boolean)LOTRConfig.CLIENT.windAmbience.get()).booleanValue()) {
            profiler.func_76320_a("wind");
            this.doWindAmbience(soundHandler, world, rand, player, pos);
            profiler.func_76319_b();
        }
        profiler.func_76319_b();
    }

    private void doWindAmbience(SoundHandler soundHandler, World world, Random rand, PlayerEntity player, BlockPos pos) {
        if (this.playingWindSounds.size() < 4) {
            int xzRange = 16;
            int yRange = 16;
            int minWindHeight = 100;
            int fullWindHeight = 180;
            if (rand.nextInt(20) == 0) {
                minWindHeight -= 10;
                if (rand.nextInt(10) == 0) {
                    minWindHeight -= 10;
                }
            }
            if (world.func_72896_J()) {
                Biome biome;
                minWindHeight = 80;
                fullWindHeight = 120;
                if (rand.nextInt(20) == 0) {
                    minWindHeight -= 20;
                }
                if (LOTRBiomes.getWrapperFor(biome = world.func_226691_t_(pos), (IWorld)world).getExtendedWeatherForRendering() == ExtendedWeatherType.SANDSTORM) {
                    minWindHeight = 60;
                    fullWindHeight = 80;
                }
            }
            BlockPos.Mutable movingPos = new BlockPos.Mutable();
            for (int l = 0; l < 2; ++l) {
                int dx = MathHelper.func_76136_a((Random)rand, (int)(-xzRange), (int)xzRange);
                int dz = MathHelper.func_76136_a((Random)rand, (int)(-xzRange), (int)xzRange);
                int dy = MathHelper.func_76136_a((Random)rand, (int)(-yRange), (int)yRange);
                movingPos.func_189533_g((Vector3i)pos).func_196234_d(dx, dy, dz);
                int windY = movingPos.func_177956_o();
                if (windY < minWindHeight || !world.func_175710_j((BlockPos)movingPos)) continue;
                float windHeightLerp = (float)(windY - minWindHeight) / (float)(fullWindHeight - minWindHeight);
                if ((windHeightLerp = MathHelper.func_76131_a((float)windHeightLerp, (float)0.0f, (float)1.0f)) < rand.nextFloat()) continue;
                float vol = 1.0f * Math.max(0.25f, windHeightLerp);
                float pitch = 0.8f + rand.nextFloat() * 0.4f;
                AmbientSoundNoAttenuation wind = new AmbientSoundNoAttenuation(LOTRSoundEvents.AMBIENCE_WIND, SoundCategory.AMBIENT, vol, pitch, (BlockPos)movingPos).modifyAmbientVolume(player, xzRange);
                soundHandler.func_147682_a((ISound)wind);
                this.playingWindSounds.add((ISound)wind);
                break;
            }
        } else {
            HashSet<ISound> removes = new HashSet<ISound>();
            for (ISound wind : this.playingWindSounds) {
                if (soundHandler.func_215294_c(wind)) continue;
                removes.add(wind);
            }
            this.playingWindSounds.removeAll(removes);
        }
    }
}

