/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import java.lang.reflect.Method;
import lotr.common.LOTRLog;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class LOTRGameRules {
    public static GameRules.RuleKey<GameRules.BooleanValue> ORC_SKIRMISH;
    public static GameRules.RuleKey<GameRules.BooleanValue> MIDDLE_EARTH_RESPAWNING;
    public static GameRules.RuleKey<GameRules.BooleanValue> FAST_TRAVEL;
    public static GameRules.RuleKey<GameRules.BooleanValue> CUSTOM_WAYPOINT_CREATION;
    public static GameRules.RuleKey<GameRules.IntegerValue> GONDOR_BEACON_RANGE;
    public static GameRules.RuleKey<GameRules.IntegerValue> GONDOR_BEACON_LIGHTING_TIME;

    public static void registerAll() {
        ORC_SKIRMISH = LOTRGameRules.register("orc_skirmish", GameRules.Category.MOBS, LOTRGameRules.createBoolean(true));
        MIDDLE_EARTH_RESPAWNING = LOTRGameRules.register("middle_earth_respawning", GameRules.Category.PLAYER, LOTRGameRules.createBoolean(true));
        FAST_TRAVEL = LOTRGameRules.register("fast_travel", GameRules.Category.PLAYER, LOTRGameRules.createBoolean(true));
        CUSTOM_WAYPOINT_CREATION = LOTRGameRules.register("custom_waypoint_creation", GameRules.Category.PLAYER, LOTRGameRules.createBoolean(true));
        GONDOR_BEACON_RANGE = LOTRGameRules.register("gondor_beacon_range", GameRules.Category.UPDATES, LOTRGameRules.createInt(80));
        GONDOR_BEACON_LIGHTING_TIME = LOTRGameRules.register("gondor_beacon_lighting_time", GameRules.Category.UPDATES, LOTRGameRules.createInt(100));
    }

    private static <T extends GameRules.RuleValue<T>> GameRules.RuleKey<T> register(String ruleName, GameRules.Category category, GameRules.RuleType<T> type) {
        String namespacedName = new ResourceLocation("lotr", ruleName).toString();
        GameRules.RuleKey ruleKey = GameRules.func_234903_a_((String)namespacedName, (GameRules.Category)category, type);
        return ruleKey;
    }

    private static GameRules.RuleType<GameRules.BooleanValue> createBoolean(boolean defaultValue) {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(GameRules.BooleanValue.class, (String)"func_223568_b", (Class[])new Class[]{Boolean.TYPE});
            return (GameRules.RuleType)m.invoke(null, defaultValue);
        }
        catch (Exception e) {
            LOTRLog.error("Error creating new boolean gamerule type");
            throw new RuntimeException(e);
        }
    }

    private static GameRules.RuleType<GameRules.IntegerValue> createInt(int defaultValue) {
        try {
            Method m = ObfuscationReflectionHelper.findMethod(GameRules.IntegerValue.class, (String)"func_223559_b", (Class[])new Class[]{Integer.TYPE});
            return (GameRules.RuleType)m.invoke(null, defaultValue);
        }
        catch (Exception e) {
            LOTRLog.error("Error creating new integral gamerule type");
            throw new RuntimeException(e);
        }
    }
}

