/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import lotr.client.LOTRClientProxy;
import lotr.common.LOTRGameRules;
import lotr.common.LOTRLog;
import lotr.common.LOTRProxy;
import lotr.common.LOTRServerProxy;
import lotr.common.command.LOTRArgumentTypes;
import lotr.common.config.LOTRConfig;
import lotr.common.datafix.LOTRItemRemappings;
import lotr.common.entity.LOTREntityDataSerializers;
import lotr.common.entity.npc.data.NPCEntitySettingsManager;
import lotr.common.entity.npc.data.NameBankManager;
import lotr.common.event.LOTREventHandler;
import lotr.common.event.LOTRTickHandlerServer;
import lotr.common.fac.FactionSettingsManager;
import lotr.common.init.LOTRAttributes;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTRCapabilities;
import lotr.common.init.LOTRCommands;
import lotr.common.init.LOTRContainers;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRParticles;
import lotr.common.init.LOTRSoundEvents;
import lotr.common.init.LOTRTileEntities;
import lotr.common.init.LOTRWorldTypes;
import lotr.common.loot.functions.LOTRLootFunctions;
import lotr.common.loot.modifiers.LOTRLootModifiers;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.recipe.LOTRRecipes;
import lotr.common.stat.LOTRStats;
import lotr.common.world.biome.util.LOTRBiomeJsonGenerator;
import lotr.common.world.gen.feature.LOTRFeatures;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.spawning.NPCSpawnSettingsManager;
import net.minecraft.command.CommandSource;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.fml.packs.ResourcePackLoader;

@Mod(value="lotr")
public class LOTRMod {
    public static final String MOD_ID = "lotr";
    public static final LOTRProxy PROXY = (LOTRProxy)DistExecutor.safeRunForDist(() -> LOTRClientProxy::new, () -> LOTRServerProxy::new);
    private static LOTREventHandler eventHandler;
    public static LOTRTickHandlerServer serverTickHandler;

    public LOTRMod() {
        LOTRLog.find();
        IEventBus fmlBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        fmlBus.register((Object)this);
        forgeBus.register((Object)this);
        forgeBus.addListener(this::onRegisterCommands);
        forgeBus.addListener(this::onAddDatapackListeners);
        fmlBus.register((Object)PROXY);
        forgeBus.register((Object)PROXY);
        LOTRConfig.register(fmlBus);
        LOTRBlocks.register();
        LOTRItems.register();
        LOTRAttributes.register();
        LOTREntityDataSerializers.register();
        LOTREntities.register();
        LOTRTileEntities.register();
        LOTRParticles.register();
        LOTRContainers.register();
        LOTRRecipes.register();
        LOTRBiomes.register();
        LOTRFeatures.register();
        LOTRDimensions.registerAssociated();
        LOTRWorldTypes.register();
        LOTRArgumentTypes.registerTypes();
        LOTRPacketHandler.register();
        LOTRStats.setup();
        LOTRGameRules.registerAll();
        LOTRSoundEvents.register();
        LOTRLootFunctions.register();
        LOTRLootModifiers.register();
        eventHandler = new LOTREventHandler();
        serverTickHandler = new LOTRTickHandlerServer();
    }

    @SubscribeEvent
    public void missingMappings(RegistryEvent.MissingMappings event) {
        LOTRItemRemappings.handle(event);
    }

    @SubscribeEvent
    public void onCommonSetup(FMLCommonSetupEvent event) {
        LOTRCapabilities.register();
        if (((Boolean)LOTRConfig.COMMON.generateBiomeJsons.get()).booleanValue()) {
            LOTRBiomeJsonGenerator.generateBiomeJsons();
        }
    }

    @SubscribeEvent
    public void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        LOTREntities.registerEntityTypeAttributes(event);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        LOTRCommands.registerCommands((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void onAddDatapackListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)MapSettingsManager.serverInstance());
        event.addListener((IFutureReloadListener)FactionSettingsManager.serverInstance());
        event.addListener((IFutureReloadListener)NPCEntitySettingsManager.serverInstance());
        event.addListener((IFutureReloadListener)NPCSpawnSettingsManager.INSTANCE);
        event.addListener((IFutureReloadListener)NameBankManager.INSTANCE);
    }

    public static ModContainer getModContainer() {
        return (ModContainer)ModList.get().getModContainerById(MOD_ID).get();
    }

    public static InputStream getModResourceStream(ResourcePackType type, ResourceLocation res) {
        try {
            ModFileResourcePack lotrAsPack = (ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)MOD_ID).get();
            return lotrAsPack.func_195761_a(type, res);
        }
        catch (NoSuchElementException e) {
            LOTRLog.error("Error loading mod resource - resource does not exist!");
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            LOTRLog.error("IOException loading mod resource");
            e.printStackTrace();
            return null;
        }
    }

    public static boolean modResourceExists(ResourcePackType type, ResourceLocation res) {
        ModFileResourcePack lotrAsPack = (ModFileResourcePack)ResourcePackLoader.getResourcePackFor((String)MOD_ID).get();
        return lotrAsPack.func_195764_b(type, res);
    }
}

