/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import lotr.common.init.LOTRTileEntities;
import lotr.common.tileentity.CustomWaypointMarkerTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CustomWaypointMarkerBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>((Map<Direction, VoxelShape>)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)0.0, (double)1.5, (double)14.5, (double)16.0, (double)14.5, (double)16.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)0.0, (double)1.5, (double)0.0, (double)16.0, (double)14.5, (double)1.5), (Object)Direction.EAST, (Object)Block.func_208617_a((double)0.0, (double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)16.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)14.5, (double)1.5, (double)0.0, (double)16.0, (double)14.5, (double)16.0)));

    public CustomWaypointMarkerBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200942_a().func_200948_a(-1.0f, 3600000.0f).func_222380_e().func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)LOTRTileEntities.CUSTOM_WAYPOINT_MARKER.get()).func_200968_a();
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        BlockPos attachedPos = pos.func_177972_a(facing.func_176734_d());
        return world.func_180495_p(attachedPos).func_224755_d((IBlockReader)world, attachedPos, facing);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing.func_176734_d() == state.func_177229_b((Property)FACING) && !state.func_196955_c((IWorldReader)world, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof CustomWaypointMarkerTileEntity) {
                CustomWaypointMarkerTileEntity marker = (CustomWaypointMarkerTileEntity)te;
                marker.recreateAndDropItemFrame(state);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }
}

