/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lotr.common.block.LOTRBlockStates;
import lotr.common.init.LOTRSoundEvents;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GateBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty OPEN = LOTRBlockStates.GATE_OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    private static final Map<Direction, BooleanProperty> CONNECTED_DIRECTION_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.UP, UP);
        map.put(Direction.DOWN, DOWN);
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
        map.put(Direction.EAST, EAST);
    });
    protected static final int MAX_GATE_RANGE = 16;
    private static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape WEST_EAST_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_SOUTH_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public final boolean fullBlockGate = false;
    private final boolean isCutoutGate;

    public GateBlock(AbstractBlock.Properties properties, boolean cutout) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false)));
        this.isCutoutGate = cutout;
    }

    public static GateBlock makeWooden() {
        return GateBlock.makeWooden(false);
    }

    public static GateBlock makeWoodenCutout() {
        return GateBlock.makeWooden(true);
    }

    private static GateBlock makeWooden(boolean cutout) {
        return new GateBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(4.0f, 3.0f).func_200947_a(SoundType.field_185848_a).func_226896_b_(), cutout);
    }

    public static GateBlock makeStone() {
        return new GateBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(4.0f, 6.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_(), false);
    }

    public static GateBlock makeMetal() {
        return GateBlock.makeMetal(false);
    }

    public static GateBlock makeMetalCutout() {
        return GateBlock.makeMetal(true);
    }

    private static GateBlock makeMetal(boolean cutout) {
        return new GateBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_235861_h_().func_200948_a(4.0f, 6.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_(), cutout);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, OPEN, POWERED, WATERLOGGED, UP, DOWN, NORTH, SOUTH, WEST, EAST});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b((Property)FACING) == Direction.UP) {
            return TOP_SHAPE;
        }
        if (state.func_177229_b((Property)FACING) == Direction.DOWN) {
            return BOTTOM_SHAPE;
        }
        if (((Direction)state.func_177229_b((Property)FACING)).func_176740_k() == Direction.Axis.X) {
            return WEST_EAST_SHAPE;
        }
        return NORTH_SOUTH_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)OPEN) != false ? VoxelShapes.func_197880_a() : super.func_220071_b(state, world, pos, context);
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return type == PathType.LAND || type == PathType.AIR ? ((Boolean)state.func_177229_b((Property)OPEN)).booleanValue() : super.func_196266_a(state, world, pos, type);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean powered = context.func_195991_k().func_175640_z(context.func_195995_a());
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)this.getDirectionForPlacement(context))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
    }

    private Direction getDirectionForPlacement(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction clickedSide = context.func_196000_l();
        BlockPos clickedOnPos = context.func_196012_c() ? pos : pos.func_177972_a(clickedSide.func_176734_d());
        BlockState clickedOnState = world.func_180495_p(clickedOnPos);
        if (clickedOnState.func_177230_c() instanceof GateBlock && ((Direction)clickedOnState.func_177229_b((Property)FACING)).func_176740_k() != clickedSide.func_176740_k()) {
            return (Direction)clickedOnState.func_177229_b((Property)FACING);
        }
        Direction horizontalFacing = context.func_195992_f();
        float horizontalAngle = 40.0f;
        float pitch = Optional.ofNullable(context.func_195999_j()).map(p -> Float.valueOf(p.field_70125_A)).orElse(Float.valueOf(0.0f)).floatValue();
        boolean lookingUp = pitch < -40.0f;
        boolean lookingDown = pitch > 40.0f;
        boolean sneak = context.func_225518_g_();
        if (clickedSide.func_176740_k().func_200128_b()) {
            return horizontalFacing;
        }
        if (lookingUp || lookingDown) {
            return context.func_221532_j().field_72448_b - (double)pos.func_177956_o() < 0.5 ? Direction.DOWN : Direction.UP;
        }
        return clickedSide.func_176735_f();
    }

    protected boolean directionsMatch(Direction facing1, Direction facing2) {
        if (facing1.func_176740_k() == Direction.Axis.Y || facing2.func_176740_k() == Direction.Axis.Y) {
            return facing1 == facing2;
        }
        return facing1.func_176740_k() == facing2.func_176740_k();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentState, Direction side) {
        Block block = adjacentState.func_177230_c();
        if (block instanceof GateBlock) {
            GateBlock otherGateBlock = (GateBlock)block;
            if (this.isCutoutGate == otherGateBlock.isCutoutGate) {
                boolean connectToSide;
                Direction thisFacing = (Direction)state.func_177229_b((Property)FACING);
                Direction otherFacing = (Direction)adjacentState.func_177229_b((Property)FACING);
                boolean thisOpen = (Boolean)state.func_177229_b((Property)OPEN);
                boolean otherOpen = (Boolean)adjacentState.func_177229_b((Property)OPEN);
                boolean bl = connectToSide = !this.directionsMatch(thisFacing, side);
                if (connectToSide) {
                    return thisOpen == otherOpen && this.directionsMatch(thisFacing, otherFacing) && otherGateBlock.directionsMatch(thisFacing, otherFacing);
                }
            }
        }
        return super.func_200122_a(state, adjacentState, side);
    }

    public static boolean doBlocksConnectVisually(BlockState state, BlockState otherState, List<Direction> connectOffsets) {
        Block block = state.func_177230_c();
        Block otherBlock = otherState.func_177230_c();
        if (block instanceof GateBlock) {
            GateBlock gateBlock = (GateBlock)block;
            Direction gateDir = (Direction)state.func_177229_b((Property)FACING);
            boolean open = (Boolean)state.func_177229_b((Property)OPEN);
            if (connectOffsets.stream().anyMatch(dir -> dir.func_176740_k() == gateDir.func_176740_k())) {
                return false;
            }
            if (otherBlock instanceof GateBlock) {
                GateBlock otherGateBlock = (GateBlock)otherBlock;
                Direction otherGateDir = (Direction)otherState.func_177229_b((Property)FACING);
                boolean otherOpen = (Boolean)otherState.func_177229_b((Property)OPEN);
                boolean connectToOtherGate = open || otherGateBlock == gateBlock;
                return connectToOtherGate && open == otherOpen && gateBlock.directionsMatch(gateDir, otherGateDir) && otherGateBlock.directionsMatch(gateDir, otherGateDir);
            }
            return gateDir.func_176740_k().func_176722_c() && open && connectOffsets.contains(Direction.DOWN);
        }
        return true;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        state = (BlockState)state.func_206870_a((Property)CONNECTED_DIRECTION_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(GateBlock.doBlocksConnectVisually(state, facingState, Collections.singletonList(facing))));
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    private static boolean isGateOpen(IBlockReader world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((Property)OPEN);
    }

    private static void setGateOpen(IWorld world, BlockPos pos, boolean open) {
        BlockState state = (BlockState)world.func_180495_p(pos).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open));
        state = Block.func_199770_b((BlockState)state, (IWorld)world, (BlockPos)pos);
        world.func_180501_a(pos, state, 3);
    }

    private static Direction getGateFacing(IBlockReader world, BlockPos pos) {
        return (Direction)world.func_180495_p(pos).func_177229_b((Property)FACING);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult target) {
        Item item;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && Block.func_149634_a((Item)(item = heldItem.func_77973_b())) instanceof GateBlock) {
            return ActionResultType.PASS;
        }
        if (!world.field_72995_K) {
            this.activateGate(world, pos);
        }
        return ActionResultType.SUCCESS;
    }

    private void activateGate(World world, BlockPos pos) {
        boolean wasOpen = GateBlock.isGateOpen((IBlockReader)world, pos);
        this.activateGate(world, pos, !wasOpen);
    }

    private void activateGate(World world, BlockPos pos, boolean open) {
        this.getConnectedGatePositions(world, pos).forEach(p -> GateBlock.setGateOpen((IWorld)world, p, open));
        world.func_184133_a(null, pos, this.getGateSound(open), SoundCategory.BLOCKS, 1.0f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
    }

    private SoundEvent getGateSound(boolean open) {
        if (this.field_149764_J == Material.field_151576_e) {
            return open ? LOTRSoundEvents.STONE_GATE_OPEN : LOTRSoundEvents.STONE_GATE_CLOSE;
        }
        return open ? LOTRSoundEvents.GATE_OPEN : LOTRSoundEvents.GATE_CLOSE;
    }

    private List<BlockPos> getConnectedGatePositions(World world, BlockPos pos) {
        boolean open = GateBlock.isGateOpen((IBlockReader)world, pos);
        Direction facing = GateBlock.getGateFacing((IBlockReader)world, pos);
        HashMap<BlockPos, Integer> coordsList = new HashMap<BlockPos, Integer>();
        int iterationDepth = 0;
        this.recursiveAddGates(world, pos, facing, open, iterationDepth, coordsList);
        return new ArrayList<BlockPos>(coordsList.keySet());
    }

    private void recursiveAddGates(World world, BlockPos pos, Direction originalFacing, boolean originalOpen, int iterationDepth, Map<BlockPos, Integer> coordsList) {
        if (coordsList.containsKey(pos) && coordsList.get(pos) < iterationDepth) {
            return;
        }
        BlockState stateHere = world.func_180495_p(pos);
        Block blockHere = stateHere.func_177230_c();
        if (blockHere instanceof GateBlock) {
            GateBlock gateBlockHere = (GateBlock)blockHere;
            boolean openHere = GateBlock.isGateOpen((IBlockReader)world, pos);
            Direction facingHere = GateBlock.getGateFacing((IBlockReader)world, pos);
            if (openHere == originalOpen && this.directionsMatch(facingHere, originalFacing) && gateBlockHere.directionsMatch(facingHere, originalFacing)) {
                coordsList.put(pos, iterationDepth);
                if (++iterationDepth >= 16) {
                    return;
                }
                this.addAdjacentGates(world, pos, originalFacing, originalOpen, iterationDepth, coordsList);
            }
        }
    }

    private void addAdjacentGates(World world, BlockPos pos, Direction originalFacing, boolean originalOpen, int iterationDepth, Map<BlockPos, Integer> coordsList) {
        for (Direction dir : Direction.values()) {
            if (dir.func_176740_k() == originalFacing.func_176740_k()) continue;
            this.recursiveAddGates(world, pos.func_177972_a(dir), originalFacing, originalOpen, iterationDepth, coordsList);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block changedBlock, BlockPos changedPos, boolean isMoving) {
        if (!world.field_72995_K && !(changedBlock instanceof GateBlock)) {
            boolean powered = world.func_175640_z(pos);
            if ((Boolean)state.func_177229_b((Property)POWERED) != powered) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered)));
                if (GateBlock.isGateOpen((IBlockReader)world, pos) != powered) {
                    this.activateGate(world, pos, powered);
                }
            }
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

