/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;

public class LOTRBlockMaterial {
    public static final Material CRYSTAL = new Builder(MaterialColor.field_151660_b).notOpaque().notSolid().pushDestroys().build();
    public static final Material ICE_BRICK = new Builder(MaterialColor.field_151657_g).build();
    public static final Material SNOW_BRICK = new Builder(MaterialColor.field_151666_j).build();

    private static class Builder {
        private PushReaction pushReaction = PushReaction.NORMAL;
        private boolean blocksMovement = true;
        private boolean canBurn;
        private boolean isLiquid;
        private boolean isReplaceable;
        private boolean isSolid = true;
        private final MaterialColor color;
        private boolean isOpaque = true;

        public Builder(MaterialColor c) {
            this.color = c;
        }

        public Builder liquid() {
            this.isLiquid = true;
            return this;
        }

        public Builder notSolid() {
            this.isSolid = false;
            return this;
        }

        public Builder doesNotBlockMovement() {
            this.blocksMovement = false;
            return this;
        }

        public Builder notOpaque() {
            this.isOpaque = false;
            return this;
        }

        public Builder flammable() {
            this.canBurn = true;
            return this;
        }

        public Builder replaceable() {
            this.isReplaceable = true;
            return this;
        }

        public Builder pushDestroys() {
            this.pushReaction = PushReaction.DESTROY;
            return this;
        }

        public Builder pushBlocks() {
            this.pushReaction = PushReaction.BLOCK;
            return this;
        }

        public Material build() {
            return new Material(this.color, this.isLiquid, this.isSolid, this.blocksMovement, this.isOpaque, this.canBurn, this.isReplaceable, this.pushReaction);
        }
    }
}

