/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.Random;
import java.util.function.Supplier;
import lotr.common.fac.FactionPointer;
import lotr.common.fac.FactionPointers;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTRContainers;
import lotr.common.inv.FactionCraftingContainer;
import lotr.common.stat.LOTRStats;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class LOTRCraftingTableBlock
extends Block {
    protected final FactionPointer tableFac;
    protected final Supplier<ContainerType<FactionCraftingContainer>> supContainerType;

    public LOTRCraftingTableBlock(Supplier<? extends Block> block, FactionPointer fac, Supplier<ContainerType<FactionCraftingContainer>> cont) {
        this(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)block.get())), fac, cont);
    }

    public LOTRCraftingTableBlock(AbstractBlock.Properties props, FactionPointer fac, Supplier<ContainerType<FactionCraftingContainer>> cont) {
        super(props);
        this.tableFac = fac;
        this.supContainerType = cont;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ContainerType<FactionCraftingContainer> containerType = this.supContainerType.get();
        TranslationTextComponent containerTitle = new TranslationTextComponent("container." + ForgeRegistries.CONTAINERS.getKey(containerType).toString().replace(":", "."));
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((i, inv, p) -> ((FactionCraftingContainer)containerType.create(i, inv, null)).setWorldPosCallable(IWorldPosCallable.func_221488_a((World)world, (BlockPos)pos)), (ITextComponent)containerTitle), extraData -> {});
        player.func_195066_a(LOTRStats.INTERACT_FACTION_CRAFTING_TABLE);
        return ActionResultType.SUCCESS;
    }

    public static class Dunlending
    extends LOTRCraftingTableBlock {
        public Dunlending(Supplier<? extends Block> block) {
            super(block, FactionPointers.DUNLAND, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.DUNLENDING_CRAFTING);
        }
    }

    public static class Lossoth
    extends LOTRCraftingTableBlock {
        public Lossoth(Supplier<? extends Block> block) {
            super(block, FactionPointers.LOSSOTH, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.LOSSOTH_CRAFTING);
        }
    }

    public static class Dale
    extends LOTRCraftingTableBlock {
        public Dale(Supplier<? extends Block> block) {
            super(block, FactionPointers.DALE, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.DALE_CRAFTING);
        }
    }

    public static class Dorwinion
    extends LOTRCraftingTableBlock {
        public Dorwinion(Supplier<? extends Block> block) {
            super(block, FactionPointers.DORWINION, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.DORWINION_CRAFTING);
        }
    }

    public static class Angmar
    extends LOTRCraftingTableBlock {
        public Angmar(Supplier<? extends Block> block) {
            super(block, FactionPointers.ANGMAR, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.ANGMAR_CRAFTING);
        }
    }

    public static class DolAmroth
    extends LOTRCraftingTableBlock {
        public DolAmroth(Supplier<? extends Block> block) {
            super(block, FactionPointers.GONDOR, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.DOL_AMROTH_CRAFTING);
        }
    }

    public static class Ranger
    extends LOTRCraftingTableBlock {
        public Ranger(Supplier<? extends Block> block) {
            super(block, FactionPointers.DUNEDAIN_NORTH, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.RANGER_CRAFTING);
        }
    }

    public static class BlueMountains
    extends LOTRCraftingTableBlock {
        public BlueMountains(Supplier<? extends Block> block) {
            super(block, FactionPointers.BLUE_MOUNTAINS, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.BLUE_MOUNTAINS_CRAFTING);
        }
    }

    public static class Hobbit
    extends LOTRCraftingTableBlock {
        public Hobbit(Supplier<? extends Block> block) {
            super(block, FactionPointers.HOBBITS, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.HOBBIT_CRAFTING);
        }
    }

    public static class Uruk
    extends LOTRCraftingTableBlock {
        public Uruk(Supplier<? extends Block> block) {
            super(block, FactionPointers.ISENGARD, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.URUK_CRAFTING);
        }
    }

    public static class Umbar
    extends LOTRCraftingTableBlock {
        public Umbar(Supplier<? extends Block> block) {
            super(block, FactionPointers.NEAR_HARAD, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.UMBAR_CRAFTING);
        }
    }

    public static class Harad
    extends LOTRCraftingTableBlock {
        public Harad(Supplier<? extends Block> block) {
            super(block, FactionPointers.NEAR_HARAD, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.HARAD_CRAFTING);
        }
    }

    public static class WoodElven
    extends LOTRCraftingTableBlock {
        public WoodElven(Supplier<? extends Block> block) {
            super(block, FactionPointers.WOODLAND_REALM, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.WOOD_ELVEN_CRAFTING);
        }
    }

    public static class Galadhrim
    extends LOTRCraftingTableBlock {
        public Galadhrim(Supplier<? extends Block> block) {
            super(block, FactionPointers.LOTHLORIEN, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.GALADHRIM_CRAFTING);
        }
    }

    public static class Rivendell
    extends LOTRCraftingTableBlock {
        public Rivendell(Supplier<? extends Block> block) {
            super(block, FactionPointers.HIGH_ELVES, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.RIVENDELL_CRAFTING);
        }
    }

    public static class Lindon
    extends LOTRCraftingTableBlock {
        public Lindon(Supplier<? extends Block> block) {
            super(block, FactionPointers.HIGH_ELVES, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.LINDON_CRAFTING);
        }
    }

    public static class Dwarven
    extends LOTRCraftingTableBlock {
        public Dwarven(Supplier<? extends Block> block) {
            super(block, FactionPointers.DURINS_FOLK, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.DWARVEN_CRAFTING);
        }
    }

    public static class Rohan
    extends LOTRCraftingTableBlock {
        public Rohan(Supplier<? extends Block> block) {
            super(block, FactionPointers.ROHAN, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.ROHAN_CRAFTING);
        }
    }

    public static class Mordor
    extends LOTRCraftingTableBlock {
        public Mordor(Supplier<? extends Block> block) {
            super(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)block.get())).func_235838_a_(LOTRBlocks.constantLight(8)), FactionPointers.MORDOR, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.MORDOR_CRAFTING);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
            for (int l = 0; l < 2; ++l) {
                double d0 = (float)pos.func_177958_n() + MathHelper.func_151240_a((Random)rand, (float)0.25f, (float)0.75f);
                double d1 = (double)pos.func_177956_o() + 1.0;
                double d2 = (float)pos.func_177952_p() + MathHelper.func_151240_a((Random)rand, (float)0.25f, (float)0.75f);
                world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class Gondor
    extends LOTRCraftingTableBlock {
        public Gondor(Supplier<? extends Block> block) {
            super(block, FactionPointers.GONDOR, (Supplier<ContainerType<FactionCraftingContainer>>)LOTRContainers.GONDOR_CRAFTING);
        }
    }
}

