/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import lotr.common.block.LOTRBlockStates;
import lotr.common.init.LOTRTags;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LOTRPillarBlock
extends RotatedPillarBlock {
    public static final BooleanProperty ABOVE = LOTRBlockStates.PILLAR_ABOVE;
    public static final BooleanProperty BELOW = LOTRBlockStates.PILLAR_BELOW;

    public LOTRPillarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ABOVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BELOW, (Comparable)Boolean.valueOf(false)));
    }

    public LOTRPillarBlock(MaterialColor materialColor) {
        this(materialColor, 1.5f, 6.0f);
    }

    public LOTRPillarBlock(MaterialColor materialColor, float hard, float res) {
        this(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)materialColor).func_235861_h_().func_200948_a(hard, res));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{ABOVE});
        builder.func_206894_a(new Property[]{BELOW});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = super.func_196258_a(context);
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        for (Direction dir : Direction.values()) {
            BlockPos facingPos = pos.func_177972_a(dir);
            state = this.checkAdjacentPillars(state, dir, world.func_180495_p(facingPos), (IWorld)world, pos, facingPos);
        }
        return state;
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return this.checkAdjacentPillars(state, dir, facingState, world, currentPos, facingPos);
    }

    private BlockState checkAdjacentPillars(BlockState state, Direction dir, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis pillarAxis = (Direction.Axis)state.func_177229_b((Property)field_176298_M);
        if (dir.func_176740_k() == pillarAxis) {
            Direction.AxisDirection axisDir = dir.func_176743_c();
            boolean matchDir = false;
            if (facingState.func_235714_a_(LOTRTags.Blocks.PILLARS)) {
                matchDir = facingState.func_235901_b_((Property)field_176298_M) ? facingState.func_177229_b((Property)field_176298_M) == pillarAxis : true;
            }
            if (axisDir == Direction.AxisDirection.POSITIVE) {
                return (BlockState)state.func_206870_a((Property)ABOVE, (Comparable)Boolean.valueOf(matchDir));
            }
            if (axisDir == Direction.AxisDirection.NEGATIVE) {
                return (BlockState)state.func_206870_a((Property)BELOW, (Comparable)Boolean.valueOf(matchDir));
            }
        }
        return state;
    }
}

