/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lotr.common.LOTRLog;
import lotr.common.util.LOTRUtil;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SignSetupHelper {
    private static List<Block> preparedSignBlocks = new ArrayList<Block>();

    public static void add(Block block) {
        if (!preparedSignBlocks.contains(block)) {
            preparedSignBlocks.add(block);
        }
    }

    public static void register(RegistryEvent.Register<Block> event) {
        if (event.getRegistry() != ForgeRegistries.BLOCKS) {
            return;
        }
        try {
            Field[] fs;
            TileEntityType signType = TileEntityType.field_200978_i;
            Field blocksField = null;
            for (Field f : fs = TileEntityType.class.getDeclaredFields()) {
                LOTRUtil.unlockFinalField(f);
                if (f.getType() != Set.class) continue;
                blocksField = f;
                break;
            }
            Set blockSet = (Set)blocksField.get(signType);
            HashSet<Block> newSet = new HashSet<Block>(blockSet);
            newSet.addAll(preparedSignBlocks);
            blocksField.set(signType, newSet);
            LOTRLog.info("Auto-registered %d sign blocks", preparedSignBlocks.size());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOTRLog.error("Error adding sign blocks to SignEntity");
            e.printStackTrace();
        }
    }
}

