/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.util.Random;
import lotr.common.init.LOTRBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class SnowPathBlock
extends Block {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public SnowPathBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public SnowPathBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151596_z).func_235861_h_().func_200943_b(0.2f).func_200947_a(SoundType.field_185856_i).harvestTool(ToolType.SHOVEL).func_235847_c_(LOTRBlocks::posPredicateTrue).func_235842_b_(LOTRBlocks::posPredicateTrue));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState defState = this.func_176223_P();
        if (!defState.func_196955_c((IWorldReader)world, pos)) {
            Block.func_199601_a((BlockState)defState, (BlockState)Blocks.field_196604_cC.func_176223_P(), (World)world, (BlockPos)pos);
        }
        return super.func_196258_a(context);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !state.func_196955_c((IWorldReader)world, currentPos)) {
            world.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        world.func_175656_a(pos, Block.func_199601_a((BlockState)state, (BlockState)Blocks.field_196604_cC.func_176223_P(), (World)world, (BlockPos)pos));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        BlockState aboveState = world.func_180495_p(pos.func_177984_a());
        return !aboveState.func_185904_a().func_76220_a() || aboveState.func_177230_c() instanceof FenceGateBlock;
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public static ActionResultType makeSnowPath(World world, BlockPos pos, Direction side, PlayerEntity player, Hand hand, ItemStack heldItem) {
        if (side != Direction.DOWN) {
            BlockState state = world.func_180495_p(pos);
            BlockState resultState = null;
            if (state.func_177230_c() == Blocks.field_196604_cC && world.func_175623_d(pos.func_177984_a())) {
                resultState = ((Block)LOTRBlocks.SNOW_PATH.get()).func_176223_P();
            } else if (state.func_177230_c() == Blocks.field_150433_aE && (Integer)state.func_177229_b((Property)SnowBlock.field_176315_a) == 1 && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196604_cC) {
                resultState = ((Block)LOTRBlocks.SNOW_PATH.get()).func_176223_P();
                pos = pos.func_177977_b();
            }
            if (resultState != null) {
                world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, resultState, 11);
                    if (player != null) {
                        heldItem.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }
}

