/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.util.LOTRUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class StrippedWoodHelper
extends AxeItem {
    private static Map<Supplier<Block>, Supplier<Block>> preparedWoods = new HashMap<Supplier<Block>, Supplier<Block>>();

    public StrippedWoodHelper(IItemTier tier, float atk, float speed, Item.Properties properties) {
        super(tier, atk, speed, properties);
        throw new IllegalArgumentException("This class should not be instantiated! It only extends AxeItem to access a protected field!");
    }

    public static void prepareStrippedWood(Supplier<Block> wood, Supplier<Block> stripped) {
        preparedWoods.put(wood, stripped);
    }

    public static Map<Block, Block> getStrippingMap() {
        return AxeItem.field_203176_a;
    }

    public static void register(RegistryEvent.Register<Block> event) {
        if (event.getRegistry() != ForgeRegistries.BLOCKS) {
            return;
        }
        try {
            Field[] fs;
            Field foundField = null;
            for (Field f : fs = AxeItem.class.getDeclaredFields()) {
                LOTRUtil.unlockFinalField(f);
                if (f.get(null) != StrippedWoodHelper.getStrippingMap()) continue;
                foundField = f;
                break;
            }
            Map strippedMap = (Map)foundField.get(null);
            HashMap<Block, Block> newMap = new HashMap<Block, Block>(strippedMap);
            for (Map.Entry<Supplier<Block>, Supplier<Block>> e : preparedWoods.entrySet()) {
                Supplier<Block> wood = e.getKey();
                Supplier<Block> stripped = e.getValue();
                newMap.put(wood.get(), stripped.get());
            }
            foundField.set(null, newMap);
            LOTRLog.info("Auto-registered %d stripped wood blocks", preparedWoods.size());
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOTRLog.error("Error auto-registering stripped wood blocks");
            e.printStackTrace();
        }
    }

    public static ActionResultType stripCustomWood(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockState strippedWoodState) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof AxeItem) {
            world.func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, strippedWoodState, 11);
                heldItem.func_222118_a(1, (LivingEntity)player, onBrokenPlayer -> onBrokenPlayer.func_213334_d(hand));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

