/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTRItems;
import lotr.common.init.LOTRSoundEvents;
import lotr.common.init.LOTRTileEntities;
import lotr.common.item.VesselDrinkItem;
import lotr.common.item.VesselOperations;
import lotr.common.item.VesselType;
import lotr.common.tileentity.VesselDrinkTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class VesselDrinkBlock
extends HorizontalBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private final VoxelShape vesselShape;

    public VesselDrinkBlock(AbstractBlock.Properties properties, VoxelShape shape) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.vesselShape = shape;
    }

    public VesselDrinkBlock(SoundType sound, float width, float height) {
        this(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.0f).func_200947_a(sound), VesselDrinkBlock.createVesselShape(width, height));
    }

    private static VoxelShape createVesselShape(float width, float height) {
        float halfWidth = width / 2.0f;
        return Block.func_208617_a((double)(8.0 - (double)halfWidth), (double)0.0, (double)(8.0 - (double)halfWidth), (double)(8.0 + (double)halfWidth), (double)height, (double)(8.0 + (double)halfWidth));
    }

    public static VesselDrinkBlock makeWoodenMug() {
        return new VesselDrinkBlock(SoundType.field_185848_a, 4.5f, 6.0f);
    }

    public static VesselDrinkBlock makeCeramicMug() {
        return new VesselDrinkBlock(LOTRBlocks.SOUND_CERAMIC, 4.5f, 6.0f);
    }

    public static VesselDrinkBlock makeMetalGoblet() {
        return new VesselDrinkBlock(SoundType.field_185852_e, 3.75f, 6.75f);
    }

    public static VesselDrinkBlock makeWoodenGoblet() {
        return new VesselDrinkBlock(SoundType.field_185852_e, 3.75f, 6.75f);
    }

    public static VesselDrinkBlock makeWineGlass() {
        return new VesselDrinkBlock(SoundType.field_185853_f, 3.75f, 7.5f);
    }

    public static VesselDrinkBlock makeAleHorn() {
        return new VesselDrinkBlock(SoundType.field_185851_d, 7.5f, 9.0f);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.vesselShape;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)LOTRTileEntities.VESSEL_DRINK.get()).func_200968_a();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return Block.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !state.func_196955_c((IWorldReader)world, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntity te;
        float temp;
        if (world.field_73012_v.nextInt(20) == 0 && (temp = world.func_226691_t_(pos).func_225486_c(pos)) >= 0.15f && (te = world.func_175625_s(pos)) instanceof VesselDrinkTileEntity) {
            VesselDrinkTileEntity vessel = (VesselDrinkTileEntity)te;
            vessel.fillFromRain();
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult trace) {
        ItemStack heldItem = player.func_184614_ca();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof VesselDrinkTileEntity) {
            VesselDrinkTileEntity vessel = (VesselDrinkTileEntity)te;
            ItemStack itemInVessel = vessel.getVesselItem();
            if (!vessel.isEmpty() && VesselOperations.isItemEmptyVessel(heldItem)) {
                ItemStack takenDrink = itemInVessel.func_77946_l();
                VesselType vesselType = VesselOperations.getVessel(heldItem);
                takenDrink = VesselOperations.getWithVesselSet(takenDrink, vesselType, true);
                if (player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, takenDrink);
                } else {
                    heldItem.func_190918_g(1);
                    if (heldItem.func_190926_b()) {
                        player.func_184611_a(hand, takenDrink);
                    } else if (!player.field_71071_by.func_70441_a(takenDrink)) {
                        player.func_71019_a(takenDrink, false);
                    }
                }
                vessel.setEmpty();
                world.func_184133_a(player, pos, LOTRSoundEvents.MUG_FILL, SoundCategory.BLOCKS, 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                return ActionResultType.SUCCESS;
            }
            if (vessel.isEmpty() && VesselOperations.isItemFullVessel(heldItem)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack emptyVessel = VesselOperations.getVessel(heldItem).createEmpty();
                    player.func_184611_a(hand, emptyVessel);
                }
                ItemStack vesselFill = heldItem.func_77946_l();
                vesselFill.func_190920_e(1);
                vessel.setVesselItem(vesselFill);
                world.func_184133_a(player, pos, LOTRSoundEvents.MUG_FILL, SoundCategory.BLOCKS, 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
                return ActionResultType.SUCCESS;
            }
            if (!vessel.isEmpty()) {
                ItemStack equivalentDrink = VesselOperations.getEquivalentDrink(itemInVessel);
                Item eqItem = equivalentDrink.func_77973_b();
                boolean canDrink = false;
                if (eqItem instanceof VesselDrinkItem) {
                    canDrink = ((VesselDrinkItem)eqItem).canBeginDrinking(player, equivalentDrink);
                }
                if (canDrink) {
                    ItemStack mugItemResult = itemInVessel.func_77950_b(world, (LivingEntity)player);
                    mugItemResult = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)itemInVessel, (int)itemInVessel.func_77988_m(), (ItemStack)mugItemResult);
                    vessel.setEmpty();
                    world.func_184133_a(player, pos, SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, trace);
    }

    public static ItemStack getVesselDrinkItem(IWorld world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof VesselDrinkTileEntity) {
            VesselDrinkTileEntity vessel = (VesselDrinkTileEntity)te;
            return vessel.getVesselItem();
        }
        return new ItemStack((IItemProvider)LOTRItems.WOODEN_MUG.get());
    }

    public static void setVesselDrinkItem(IWorld world, BlockPos pos, ItemStack itemstack, VesselType vesselType) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof VesselDrinkTileEntity) {
            VesselDrinkTileEntity vessel = (VesselDrinkTileEntity)te;
            vessel.setVesselItem(itemstack);
            vessel.setVesselType(vesselType);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        VesselDrinkTileEntity vessel;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof VesselDrinkTileEntity && !(vessel = (VesselDrinkTileEntity)te).isEmpty()) {
            ItemStack copy = vessel.getVesselItem().func_77946_l();
            copy.func_190920_e(1);
            return copy;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

