/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import lotr.common.command.LOTRBaseCommand;
import lotr.common.command.arguments.FactionArgument;
import lotr.common.fac.Faction;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class AlignmentCommand
extends LOTRBaseCommand {
    private static final float MAX_COMMAND_ALIGNMENT = 10000.0f;
    private static final float MIN_COMMAND_ALIGNMENT = -10000.0f;

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"alignment").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"set").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"faction", (ArgumentType)FactionArgument.faction()).then(Commands.func_197056_a((String)"amount", (ArgumentType)AlignmentCommand.alignmentSetValueArgument()).executes(context -> AlignmentCommand.setAlignment((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), FactionArgument.getFaction(context, "faction"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount")))))).then(Commands.func_197057_a((String)"all").then(Commands.func_197056_a((String)"amount", (ArgumentType)AlignmentCommand.alignmentSetValueArgument()).executes(context -> AlignmentCommand.setAllAlignments((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount")))))))).then(Commands.func_197057_a((String)"add").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"faction", (ArgumentType)FactionArgument.faction()).then(Commands.func_197056_a((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> AlignmentCommand.addAlignment((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), FactionArgument.getFaction(context, "faction"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount")))))).then(Commands.func_197057_a((String)"all").then(Commands.func_197056_a((String)"amount", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> AlignmentCommand.addAllAlignments((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), FloatArgumentType.getFloat((CommandContext)context, (String)"amount")))))))).then(Commands.func_197057_a((String)"query").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"faction", (ArgumentType)FactionArgument.faction()).executes(context -> AlignmentCommand.queryAlignment((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"target"), FactionArgument.getFaction(context, "faction")))))));
    }

    private static FloatArgumentType alignmentSetValueArgument() {
        return FloatArgumentType.floatArg((float)-10000.0f, (float)10000.0f);
    }

    private static ITextComponent getAmountComponent(float amount) {
        StringTextComponent text = new StringTextComponent(String.valueOf(amount));
        if (amount > 0.0f) {
            text.func_240699_a_(TextFormatting.GREEN);
        } else if (amount < 0.0f) {
            text.func_240699_a_(TextFormatting.RED);
        }
        return text;
    }

    private static int setAlignment(CommandSource source, Collection<ServerPlayerEntity> players, Faction faction, float amount) throws CommandSyntaxException {
        int playersChanged = 0;
        for (ServerPlayerEntity player : players) {
            AlignmentCommand.getAlignData(player).setAlignment(faction, amount);
            ++playersChanged;
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.set.single", new Object[]{players.iterator().next().func_145748_c_(), AlignmentCommand.getFactionNameComponent(faction), AlignmentCommand.getAmountComponent(amount)}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.set.multiple", new Object[]{players.size(), AlignmentCommand.getFactionNameComponent(faction), AlignmentCommand.getAmountComponent(amount)}), true);
        }
        return playersChanged;
    }

    private static int setAllAlignments(CommandSource source, Collection<ServerPlayerEntity> players, float amount) throws CommandSyntaxException {
        int playersChanged = 0;
        for (ServerPlayerEntity player : players) {
            for (Faction faction : AlignmentCommand.allFactions()) {
                AlignmentCommand.getAlignData(player).setAlignment(faction, amount);
            }
            ++playersChanged;
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.set.all.single", new Object[]{players.iterator().next().func_145748_c_(), AlignmentCommand.getAmountComponent(amount)}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.set.all.multiple", new Object[]{players.size(), AlignmentCommand.getAmountComponent(amount)}), true);
        }
        return playersChanged;
    }

    private static int addAlignment(CommandSource source, Collection<ServerPlayerEntity> players, Faction faction, float addAmount) throws CommandSyntaxException {
        int playersChanged = 0;
        for (ServerPlayerEntity player : players) {
            AlignmentCommand.checkResultingAlignmentWithinBounds(player, faction, addAmount);
            AlignmentCommand.getAlignData(player).addAlignment(faction, addAmount);
            ++playersChanged;
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.add.single", new Object[]{players.iterator().next().func_145748_c_(), AlignmentCommand.getFactionNameComponent(faction), AlignmentCommand.getAmountComponent(addAmount)}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.add.multiple", new Object[]{players.size(), AlignmentCommand.getFactionNameComponent(faction), AlignmentCommand.getAmountComponent(addAmount)}), true);
        }
        return playersChanged;
    }

    private static int addAllAlignments(CommandSource source, Collection<ServerPlayerEntity> players, float addAmount) throws CommandSyntaxException {
        int playersChanged = 0;
        for (ServerPlayerEntity player : players) {
            for (Faction faction : AlignmentCommand.allFactions()) {
                AlignmentCommand.checkResultingAlignmentWithinBounds(player, faction, addAmount);
                AlignmentCommand.getAlignData(player).addAlignment(faction, addAmount);
            }
            ++playersChanged;
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.add.all.single", new Object[]{players.iterator().next().func_145748_c_(), AlignmentCommand.getAmountComponent(addAmount)}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.add.all.multiple", new Object[]{players.size(), AlignmentCommand.getAmountComponent(addAmount)}), true);
        }
        return playersChanged;
    }

    private static void checkResultingAlignmentWithinBounds(ServerPlayerEntity player, Faction faction, float addAmount) throws CommandSyntaxException {
        float currentAmount = AlignmentCommand.getAlignData(player).getAlignment(faction);
        if (currentAmount + addAmount > 10000.0f) {
            throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.add.tooHigh", new Object[]{player.func_145748_c_(), faction.getDisplayName(), Float.valueOf(10000.0f)}));
        }
        if (currentAmount + addAmount < -10000.0f) {
            throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.add.tooLow", new Object[]{player.func_145748_c_(), faction.getDisplayName(), Float.valueOf(-10000.0f)}));
        }
    }

    private static int queryAlignment(CommandSource source, ServerPlayerEntity player, Faction faction) {
        float currentAmount = AlignmentCommand.getAlignData(player).getAlignment(faction);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.alignment.query", new Object[]{player.func_145748_c_(), AlignmentCommand.getFactionNameComponent(faction), AlignmentCommand.getAmountComponent(currentAmount)}), false);
        int i = Math.round(currentAmount);
        return i;
    }
}

