/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import lotr.common.LOTRMod;
import lotr.common.command.arguments.FactionArgument;
import lotr.common.command.arguments.LOTRTimeArgument;
import lotr.common.command.arguments.PlayerMessageTypeArgument;
import lotr.common.command.arguments.WaypointRegionArgument;
import lotr.common.fac.FactionSettings;
import lotr.common.fac.FactionSettingsManager;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.MapSettingsManager;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class LOTRArgumentTypes {
    public static void registerTypes() {
        LOTRArgumentTypes.register("lotr_time", LOTRTimeArgument.class, new ArgumentSerializer(LOTRTimeArgument::create));
        LOTRArgumentTypes.register("waypoint_region", WaypointRegionArgument.class, new ArgumentSerializer(WaypointRegionArgument::waypointRegion));
        LOTRArgumentTypes.register("faction", FactionArgument.class, new ArgumentSerializer(FactionArgument::faction));
        LOTRArgumentTypes.register("player_message", PlayerMessageTypeArgument.class, new ArgumentSerializer(PlayerMessageTypeArgument::messageType));
    }

    private static <T extends ArgumentType<?>> void register(String name, Class<T> cls, IArgumentSerializer<T> serializer) {
        String namespacedName = new ResourceLocation("lotr", name).toString();
        ArgumentTypes.func_218136_a((String)namespacedName, cls, serializer);
    }

    public static FactionSettings getCurrentSidedFactionSettings() {
        return FactionSettingsManager.sidedInstance(LOTRArgumentTypes.getSafeSideToUse()).getCurrentLoadedFactions();
    }

    public static MapSettings getCurrentSidedMapSettings() {
        return MapSettingsManager.sidedInstance(LOTRArgumentTypes.getSafeSideToUse()).getCurrentLoadedMap();
    }

    protected static LogicalSide getSafeSideToUse() {
        LogicalSide safeSide = ServerLifecycleHooks.getCurrentServer() != null || !LOTRMod.PROXY.isClient() ? LogicalSide.SERVER : LogicalSide.CLIENT;
        return safeSide;
    }
}

