/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashMap;
import lotr.common.command.LOTRBaseCommand;
import lotr.common.command.arguments.FactionArgument;
import lotr.common.data.AlignmentDataModule;
import lotr.common.fac.Faction;
import lotr.common.util.LOTRUtil;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class PledgeCommand
extends LOTRBaseCommand {
    private static final int MAX_COOLDOWN_SECONDS = 1000000;

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"pledge").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"faction", (ArgumentType)FactionArgument.faction()).executes(context -> PledgeCommand.setPledge((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), FactionArgument.getFaction(context, "faction"), false))).then(Commands.func_197057_a((String)"force").executes(context -> PledgeCommand.setPledge((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), FactionArgument.getFaction(context, "faction"), true))))))).then(Commands.func_197057_a((String)"break").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> PledgeCommand.breakPledge((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets")))))).then(Commands.func_197057_a((String)"cooldown").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000000)).executes(context -> PledgeCommand.setPledgeCooldown((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"))))))).then(Commands.func_197057_a((String)"query").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> PledgeCommand.queryPledge((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))));
    }

    private static int setPledge(CommandSource source, Collection<ServerPlayerEntity> players, Faction faction, boolean force) throws CommandSyntaxException {
        int playersPledged = 0;
        for (ServerPlayerEntity player : players) {
            AlignmentDataModule alignData = PledgeCommand.getAlignData(player);
            if (!alignData.isValidPledgeFaction(faction)) {
                throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.set.failure.invalid", new Object[]{faction.getDisplayName()}));
            }
            if (!force && !alignData.canPledgeToNow(faction)) {
                if (players.size() != 1) continue;
                throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.set.failure.requirements", new Object[]{player.func_145748_c_(), faction.getDisplayName()}));
            }
            if (alignData.getPledgeFaction() != null) {
                alignData.revokePledgeFaction((PlayerEntity)player, true);
            }
            if (force) {
                alignData.setAlignment(faction, faction.getPledgeAlignment());
            }
            alignData.setPledgeFaction(faction);
            ++playersPledged;
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.set.success.single", new Object[]{players.iterator().next().func_145748_c_(), PledgeCommand.getFactionNameComponent(faction)}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.set.success.multiple", new Object[]{players.size(), PledgeCommand.getFactionNameComponent(faction)}), true);
        }
        return playersPledged;
    }

    private static int breakPledge(CommandSource source, Collection<ServerPlayerEntity> players) throws CommandSyntaxException {
        int playersUnpledged = 0;
        HashMap<ServerPlayerEntity, Faction> brokenPledgesTo = new HashMap<ServerPlayerEntity, Faction>();
        for (ServerPlayerEntity player : players) {
            AlignmentDataModule alignData = PledgeCommand.getAlignData(player);
            Faction wasPledgedTo = alignData.getPledgeFaction();
            if (wasPledgedTo == null) {
                if (players.size() != 1) continue;
                throw new CommandException((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.break.failure.none", new Object[]{player.func_145748_c_()}));
            }
            brokenPledgesTo.put(player, wasPledgedTo);
            alignData.revokePledgeFaction((PlayerEntity)player, true);
            ++playersUnpledged;
        }
        if (players.size() == 1) {
            ServerPlayerEntity onePlayer = players.iterator().next();
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.break.success.single", new Object[]{onePlayer.func_145748_c_(), PledgeCommand.getFactionNameComponent((Faction)brokenPledgesTo.get(onePlayer))}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.break.success.multiple", new Object[]{players.size()}), true);
        }
        return playersUnpledged;
    }

    private static int setPledgeCooldown(CommandSource source, Collection<ServerPlayerEntity> players, int seconds) {
        ITextComponent hmsTime = LOTRUtil.getHMSTime_Seconds(seconds);
        int ticks = seconds * 20;
        int cooldownsSet = 0;
        for (ServerPlayerEntity player : players) {
            PledgeCommand.getAlignData(player).setPledgeBreakCooldown(ticks);
            ++cooldownsSet;
        }
        if (players.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.cooldown.single", new Object[]{players.iterator().next().func_145748_c_(), seconds, hmsTime}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.cooldown.multiple", new Object[]{players.size(), seconds, hmsTime}), true);
        }
        return cooldownsSet;
    }

    private static int queryPledge(CommandSource source, ServerPlayerEntity player) {
        Faction pledgeFaction = PledgeCommand.getAlignData(player).getPledgeFaction();
        if (pledgeFaction != null) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.query.pledged", new Object[]{player.func_145748_c_(), PledgeCommand.getFactionNameComponent(pledgeFaction)}), false);
            return 1;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.pledge.query.none", new Object[]{player.func_145748_c_()}), false);
        return 0;
    }
}

