/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import lotr.common.command.LOTRBaseCommand;
import lotr.common.util.LOTRUtil;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WaypointCooldownCommand
extends LOTRBaseCommand {
    private static final int MAX_COOLDOWN_SECONDS = 86400;

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"wpcooldown").requires(context -> context.func_197034_c(2))).then(Commands.func_197057_a((String)"max").then(Commands.func_197056_a((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0, (int)86400)).executes(context -> WaypointCooldownCommand.setMaxCooldown((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds")))))).then(Commands.func_197057_a((String)"min").then(Commands.func_197056_a((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0, (int)86400)).executes(context -> WaypointCooldownCommand.setMinCooldown((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seconds"))))));
    }

    private static int setMaxCooldown(CommandSource source, int max) {
        int min = WaypointCooldownCommand.getLevelData().getWaypointCooldownMin();
        boolean updatedMin = false;
        if (max < min) {
            min = max;
            updatedMin = true;
        }
        WaypointCooldownCommand.getLevelData().setWaypointCooldown((World)source.func_197023_e(), max, min);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpcooldown.max.set", new Object[]{max, LOTRUtil.getHMSTime_Seconds(max)}), true);
        if (updatedMin) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpcooldown.max.updatedMin", new Object[]{min}), true);
        }
        return 1;
    }

    private static int setMinCooldown(CommandSource source, int min) {
        int max = WaypointCooldownCommand.getLevelData().getWaypointCooldownMax();
        boolean updatedMax = false;
        if (min > max) {
            max = min;
            updatedMax = true;
        }
        WaypointCooldownCommand.getLevelData().setWaypointCooldown((World)source.func_197023_e(), max, min);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpcooldown.min.set", new Object[]{max, LOTRUtil.getHMSTime_Seconds(min)}), true);
        if (updatedMax) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.lotr.wpcooldown.min.updatedMax", new Object[]{min}), true);
        }
        return 1;
    }
}

