/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lotr.common.LOTRLog;
import lotr.common.config.LOTRConfig;
import lotr.common.data.DataUtil;
import lotr.common.data.LOTRPlayerData;
import lotr.common.data.PlayerDataModule;
import lotr.common.data.PlayerMessageType;
import lotr.common.entity.misc.AlignmentBonusEntity;
import lotr.common.fac.AlignmentBonus;
import lotr.common.fac.AlignmentBonusMap;
import lotr.common.fac.AlignmentPredicate;
import lotr.common.fac.Faction;
import lotr.common.fac.FactionPointer;
import lotr.common.fac.FactionRank;
import lotr.common.fac.FactionRegion;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTRSoundEvents;
import lotr.common.network.CPacketToggle;
import lotr.common.network.CPacketViewedFactions;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketAlignment;
import lotr.common.network.SPacketAlignmentBonus;
import lotr.common.network.SPacketAlignmentDrain;
import lotr.common.network.SPacketPledge;
import lotr.common.network.SPacketPledgeBreak;
import lotr.common.network.SPacketRegionLastViewedFaction;
import lotr.common.network.SPacketToggle;
import lotr.common.network.SPacketViewingFaction;
import lotr.common.network.SidedTogglePacket;
import lotr.common.util.LOTRUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Pair;

public class AlignmentDataModule
extends PlayerDataModule {
    private Faction currentViewedFaction;
    private Map<FactionRegion, Faction> regionLastViewedFactions = new HashMap<FactionRegion, Faction>();
    private Map<Faction, Float> alignments = new HashMap<Faction, Float>();
    private Faction pledgeFaction;
    private int pledgeKillCooldown;
    public static final int PLEDGE_KILL_COOLDOWN_MAX = 24000;
    private int pledgeBreakCooldown;
    private int pledgeBreakCooldownStart;
    private Faction brokenPledgeFaction;
    private boolean friendlyFire;

    protected AlignmentDataModule(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void save(CompoundNBT playerNBT) {
        this.writeFactionToNBT(playerNBT, "CurrentFaction", this.currentViewedFaction);
        playerNBT.func_218657_a("PrevRegionFactions", (INBT)DataUtil.saveMapAsListNBT(this.regionLastViewedFactions, (nbt, region, fac) -> {
            nbt.func_74778_a("Region", region.getName().toString());
            nbt.func_74778_a("Faction", fac.getName().toString());
        }));
        playerNBT.func_218657_a("AlignmentMap", (INBT)DataUtil.saveMapAsListNBT(this.alignments, (nbt, fac, alignment) -> {
            nbt.func_74778_a("Faction", fac.getName().toString());
            nbt.func_74776_a("AlignF", alignment.floatValue());
        }));
        this.writeFactionToNBT(playerNBT, "PledgeFac", this.pledgeFaction);
        playerNBT.func_74768_a("PledgeKillCD", this.pledgeKillCooldown);
        playerNBT.func_74768_a("PledgeBreakCD", this.pledgeBreakCooldown);
        playerNBT.func_74768_a("PledgeBreakCDStart", this.pledgeBreakCooldownStart);
        this.writeFactionToNBT(playerNBT, "BrokenPledgeFac", this.brokenPledgeFaction);
        playerNBT.func_74757_a("FriendlyFire", this.friendlyFire);
    }

    @Override
    public void load(CompoundNBT playerNBT) {
        this.currentViewedFaction = this.loadFactionFromNBT(playerNBT, "CurrentFaction", "Loaded nonexistent viewing faction %s");
        DataUtil.loadMapFromListNBT(this.regionLastViewedFactions, playerNBT.func_150295_c("PrevRegionFactions", 10), nbt -> {
            String regionName = nbt.func_74779_i("Region");
            String facName = nbt.func_74779_i("Faction");
            FactionRegion region = this.currentFactionSettings().getRegionByName(new ResourceLocation(regionName));
            if (region != null) {
                Faction faction = this.currentFactionSettings().getFactionByName(new ResourceLocation(facName));
                if (faction != null) {
                    return Pair.of((Object)region, (Object)faction);
                }
                this.playerData.logPlayerError("Loaded nonexistent faction ID %s", facName);
                return null;
            }
            this.playerData.logPlayerError("Loaded nonexistent faction region ID %s", regionName);
            return null;
        });
        DataUtil.loadMapFromListNBT(this.alignments, playerNBT.func_150295_c("AlignmentMap", 10), nbt -> {
            String facName = nbt.func_74779_i("Faction");
            Faction faction = this.currentFactionSettings().getFactionByName(new ResourceLocation(facName));
            if (faction != null) {
                float alignment = nbt.func_74760_g("AlignF");
                return Pair.of((Object)faction, (Object)Float.valueOf(alignment));
            }
            this.playerData.logPlayerError("Loaded nonexistent faction ID %s", facName);
            return null;
        });
        this.pledgeFaction = this.loadFactionFromNBT(playerNBT, "PledgeFac", "Loaded nonexistent pledge faction %s");
        this.pledgeKillCooldown = playerNBT.func_74762_e("PledgeKillCD");
        this.pledgeBreakCooldown = playerNBT.func_74762_e("PledgeBreakCD");
        this.pledgeBreakCooldownStart = playerNBT.func_74762_e("PledgeBreakCDStart");
        this.brokenPledgeFaction = this.loadFactionFromNBT(playerNBT, "BrokenPledgeFac", "Loaded nonexistent broken pledge faction %s");
        this.friendlyFire = playerNBT.func_74767_n("FriendlyFire");
    }

    @Override
    protected void sendLoginData(PacketBuffer buf) {
        this.writeFactionToBuffer(buf, this.currentViewedFaction);
        DataUtil.writeMapToBuffer(buf, this.regionLastViewedFactions, (region, faction) -> {
            buf.func_150787_b(region.getAssignedId());
            buf.func_150787_b(faction.getAssignedId());
        });
        DataUtil.writeMapToBuffer(buf, this.alignments, (faction, alignment) -> {
            buf.func_150787_b(faction.getAssignedId());
            buf.writeFloat(alignment.floatValue());
        });
        this.writeFactionToBuffer(buf, this.pledgeFaction);
        buf.writeBoolean(this.friendlyFire);
    }

    @Override
    protected void receiveLoginData(PacketBuffer buf) {
        this.currentViewedFaction = this.readFactionFromBuffer(buf, "Received nonexistent viewing faction ID %d from server");
        DataUtil.fillMapFromBuffer(buf, this.regionLastViewedFactions, () -> {
            int regionId = buf.func_150792_a();
            int factionId = buf.func_150792_a();
            FactionRegion region = this.currentFactionSettings().getRegionByID(regionId);
            Faction faction = this.currentFactionSettings().getFactionByID(factionId);
            if (region == null) {
                LOTRLog.warn("Received nonexistent faction region ID %d from server", regionId);
                return null;
            }
            if (faction == null) {
                LOTRLog.warn("Received nonexistent faction ID %d from server", factionId);
                return null;
            }
            return Pair.of((Object)region, (Object)faction);
        });
        DataUtil.fillMapFromBuffer(buf, this.alignments, () -> {
            int factionId = buf.func_150792_a();
            Faction faction = this.currentFactionSettings().getFactionByID(factionId);
            float alignment = buf.readFloat();
            if (faction == null) {
                LOTRLog.warn("Received nonexistent faction ID %d from server", factionId);
                return null;
            }
            return Pair.of((Object)faction, (Object)Float.valueOf(alignment));
        });
        this.pledgeFaction = this.readFactionFromBuffer(buf, "Received nonexistent pledge faction ID %d from server");
        this.friendlyFire = buf.readBoolean();
    }

    @Override
    protected void onUpdate(ServerPlayerEntity player, ServerWorld world, int tick) {
        RegistryKey<World> currentDimension = LOTRDimensions.getCurrentLOTRDimensionOrFallback((World)world);
        if (this.currentViewedFaction != null) {
            FactionRegion currentRegion = this.currentViewedFaction.getRegion();
            if (!currentRegion.getDimension().equals(currentDimension)) {
                this.updateCurrentViewedFactionToNewDimension(currentDimension);
            }
        } else {
            this.updateCurrentViewedFactionToNewDimension(currentDimension);
        }
        this.runAlignmentDraining(player, tick);
        if (this.pledgeKillCooldown > 0) {
            --this.pledgeKillCooldown;
            if (this.pledgeKillCooldown == 0 || AlignmentDataModule.isTimerAutosaveTick()) {
                this.markDirty();
            }
        }
        if (this.pledgeBreakCooldown > 0) {
            this.setPledgeBreakCooldown(this.pledgeBreakCooldown - 1);
        }
    }

    private void updateCurrentViewedFactionToNewDimension(RegistryKey<World> currentDimension) {
        List<FactionRegion> dimensionRegions = this.currentFactionSettings().getRegionsForDimension(currentDimension);
        if (dimensionRegions != null && !dimensionRegions.isEmpty()) {
            for (FactionRegion region : dimensionRegions) {
                Faction fac;
                List<Faction> regionFacs = this.currentFactionSettings().getFactionsForRegion(region);
                if (regionFacs == null || regionFacs.isEmpty() || (fac = this.getRegionLastViewedFaction(region)) == null) continue;
                this.setCurrentViewedFaction(fac);
                break;
            }
        }
    }

    public float getAlignment(Faction faction) {
        return this.alignments.getOrDefault(faction, Float.valueOf(0.0f)).floatValue();
    }

    public float getAlignment(FactionPointer pointer) {
        Optional<Faction> faction = pointer.resolveFaction(this.currentFactionSettings());
        if (faction.isPresent()) {
            return this.getAlignment(faction.get());
        }
        LOTRLog.warn("Tried to get player alignment for faction %s - but faction isn't defined in the current world!", pointer.getName());
        return 0.0f;
    }

    public boolean hasAlignment(Faction faction, AlignmentPredicate predicate) {
        return predicate.test(this.getAlignment(faction));
    }

    public boolean hasAlignmentWithAny(Collection<Faction> factions, AlignmentPredicate predicate) {
        return factions.stream().anyMatch(fac -> this.hasAlignment((Faction)fac, predicate));
    }

    public boolean hasAlignmentWithAll(Collection<Faction> factions, AlignmentPredicate predicate) {
        return factions.stream().allMatch(fac -> this.hasAlignment((Faction)fac, predicate));
    }

    public float getHighestAlignmentAmong(Collection<Faction> factions) {
        return factions.stream().map(this::getAlignment).sorted(Comparator.reverseOrder()).findFirst().orElse(Float.valueOf(Float.MIN_VALUE)).floatValue();
    }

    public void setAlignment(Faction faction, float alignment) {
        if (faction.isPlayableAlignmentFaction()) {
            this.alignments.put(faction, Float.valueOf(alignment));
            this.markDirty();
            this.sendPacketToClient(new SPacketAlignment(faction, alignment));
        }
        if (this.pledgeFaction != null && !this.canPledgeToNow(this.pledgeFaction)) {
            this.executeIfPlayerExistsServerside(player -> this.revokePledgeFaction((PlayerEntity)player, false));
        }
    }

    public void addAlignment(Faction faction, float alignmentAdd) {
        this.setAlignment(faction, this.getAlignment(faction) + alignmentAdd);
    }

    public AlignmentBonusMap addAlignmentFromBonus(ServerPlayerEntity player, AlignmentBonus source, Faction mainFaction, List<Faction> forcedBonusFactions, Entity entity) {
        return this.addAlignmentFromBonus(player, source, mainFaction, forcedBonusFactions, entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_213302_cg() * 0.7, 0.0));
    }

    public AlignmentBonusMap addAlignmentFromBonus(ServerPlayerEntity player, AlignmentBonus source, Faction mainFaction, Vector3d pos) {
        return this.addAlignmentFromBonus(player, source, mainFaction, null, pos);
    }

    public AlignmentBonusMap addAlignmentFromBonus(ServerPlayerEntity player, AlignmentBonus source, Faction mainFaction, List<Faction> forcedBonusFactions, Vector3d pos) {
        float bonus = source.bonus;
        AlignmentBonusMap factionBonusMap = new AlignmentBonusMap();
        float prevMainAlignment = this.getAlignment(mainFaction);
        float conquestBonus = 0.0f;
        float notPledgedMultiplier = 0.5f;
        if (source.isKill) {
            mainFaction.getBonusesForKilling().stream().filter(Faction::isPlayableAlignmentFaction).filter(fac -> fac.approvesCivilianKills() || !source.isCivilianKill).forEach(bonusFaction -> {
                if (!source.isKillByHiredUnit) {
                    float mplier = 0.0f;
                    mplier = forcedBonusFactions != null && forcedBonusFactions.contains(bonusFaction) ? 1.0f : bonusFaction.getAreasOfInfluence().getAlignmentMultiplier((PlayerEntity)player);
                    if (mplier > 0.0f) {
                        float alignment = this.getAlignment((Faction)bonusFaction);
                        float factionBonus = Math.abs(bonus);
                        factionBonus *= mplier;
                        if (alignment >= bonusFaction.getPledgeAlignment() && !this.isPledgedTo((Faction)bonusFaction)) {
                            factionBonus *= 0.5f;
                        }
                        factionBonus = this.checkBonusForPledgeEnemyLimit((Faction)bonusFaction, factionBonus);
                        this.setAlignment((Faction)bonusFaction, alignment += factionBonus);
                        factionBonusMap.put(bonusFaction, Float.valueOf(factionBonus));
                    }
                }
                if (bonusFaction == this.getPledgeFaction()) {
                    // empty if block
                }
            });
            mainFaction.getPenaltiesForKilling().stream().filter(Faction::isPlayableAlignmentFaction).forEach(penaltyFaction -> {
                if (!source.isKillByHiredUnit) {
                    float mplier = 0.0f;
                    mplier = penaltyFaction == mainFaction ? 1.0f : penaltyFaction.getAreasOfInfluence().getAlignmentMultiplier((PlayerEntity)player);
                    if (mplier > 0.0f) {
                        float alignment = this.getAlignment((Faction)penaltyFaction);
                        float factionPenalty = -Math.abs(bonus);
                        factionPenalty *= mplier;
                        factionPenalty = AlignmentBonus.scaleKillPenalty(factionPenalty, alignment);
                        this.setAlignment((Faction)penaltyFaction, alignment += factionPenalty);
                        factionBonusMap.put(penaltyFaction, Float.valueOf(factionPenalty));
                    }
                }
            });
        } else if (mainFaction.isPlayableAlignmentFaction()) {
            float alignment = this.getAlignment(mainFaction);
            float factionBonus = bonus;
            if (factionBonus > 0.0f && alignment >= mainFaction.getPledgeAlignment() && !this.isPledgedTo(mainFaction)) {
                factionBonus *= 0.5f;
            }
            factionBonus = this.checkBonusForPledgeEnemyLimit(mainFaction, factionBonus);
            this.setAlignment(mainFaction, alignment += factionBonus);
            factionBonusMap.put(mainFaction, Float.valueOf(factionBonus));
        }
        if (!factionBonusMap.isEmpty() || conquestBonus != 0.0f) {
            int entityId = AlignmentBonusEntity.getNextSafeEntityIdForBonusSpawn(player.func_71121_q());
            this.sendPacketToClient(new SPacketAlignmentBonus(entityId, source, mainFaction, prevMainAlignment, factionBonusMap, conquestBonus, pos));
        }
        return factionBonusMap;
    }

    private float checkBonusForPledgeEnemyLimit(Faction fac, float bonus) {
        if (this.isPledgeEnemyAlignmentLimited(fac)) {
            float limit;
            float alignment = this.getAlignment(fac);
            if (alignment > (limit = this.getPledgeEnemyAlignmentLimit(fac))) {
                bonus = 0.0f;
            } else if (alignment + bonus > limit) {
                bonus = limit - alignment;
            }
        }
        return bonus;
    }

    public Faction getCurrentViewedFaction() {
        return this.currentViewedFaction;
    }

    public Faction getCurrentViewedFactionOrFallbackToFirstIn(RegistryKey<World> currentDimension) {
        if (this.currentViewedFaction == null || !this.currentViewedFaction.getDimension().equals(currentDimension)) {
            this.updateCurrentViewedFactionToNewDimension(currentDimension);
        }
        return this.currentViewedFaction;
    }

    public void setCurrentViewedFaction(Faction fac) {
        if (fac != null) {
            this.currentViewedFaction = fac;
            this.markDirty();
            this.sendPacketToClient(new SPacketViewingFaction(this.currentViewedFaction));
        }
    }

    public Faction getRegionLastViewedFaction(FactionRegion region) {
        List<Faction> regionFacs;
        Faction fac = this.regionLastViewedFactions.get(region);
        if (fac == null && !(regionFacs = this.currentFactionSettings().getFactionsForRegion(region)).isEmpty()) {
            fac = regionFacs.get(0);
            this.regionLastViewedFactions.put(region, fac);
        }
        return fac;
    }

    public void setRegionLastViewedFaction(FactionRegion region, Faction fac) {
        List<Faction> regionFacs = this.currentFactionSettings().getFactionsForRegion(region);
        if (regionFacs.contains(fac)) {
            this.regionLastViewedFactions.put(region, fac);
            this.markDirty();
            this.sendPacketToClient(new SPacketRegionLastViewedFaction(region, fac));
        }
    }

    public void sendViewedFactionsToServer() {
        CPacketViewedFactions packet = new CPacketViewedFactions(this.currentViewedFaction, this.regionLastViewedFactions);
        LOTRPacketHandler.sendToServer(packet);
    }

    public Faction getPledgeFaction() {
        return this.pledgeFaction;
    }

    public boolean isPledgedTo(Faction faction) {
        return faction == this.pledgeFaction;
    }

    public void setPledgeFaction(Faction faction) {
        this.pledgeFaction = faction;
        this.pledgeKillCooldown = 0;
        this.markDirty();
        this.sendPacketToClient(new SPacketPledge(faction));
        this.executeIfPlayerExistsServerside(player -> {
            if (faction != null) {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), LOTRSoundEvents.PLEDGE, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        });
    }

    public boolean isValidPledgeFaction(Faction faction) {
        return faction.isPlayableAlignmentFaction();
    }

    public boolean canPledgeToNow(Faction faction) {
        if (this.isValidPledgeFaction(faction)) {
            return this.hasPledgeAlignment(faction) && this.getFactionsPreventingPledgeTo(faction).isEmpty();
        }
        return false;
    }

    public boolean hasPledgeAlignment(Faction faction) {
        return this.getAlignment(faction) >= faction.getPledgeAlignment();
    }

    public List<Faction> getFactionsPreventingPledgeTo(Faction faction) {
        return this.currentFactionSettings().getFactions().stream().filter(otherFac -> otherFac.isPlayableAlignmentFaction() && this.doesFactionPreventPledge(faction, (Faction)otherFac) && this.getAlignment((Faction)otherFac) > 0.0f).collect(Collectors.toList());
    }

    private boolean doesFactionPreventPledge(Faction pledgeFac, Faction otherFac) {
        return pledgeFac.isMortalEnemy(otherFac);
    }

    public boolean canMakeNewPledge() {
        return this.pledgeBreakCooldown <= 0;
    }

    public void revokePledgeFaction(PlayerEntity player, boolean intentional) {
        Faction wasPledgedTo = this.pledgeFaction;
        float pledgeLvl = wasPledgedTo.getPledgeAlignment();
        float prevAlign = this.getAlignment(wasPledgedTo);
        float diff = prevAlign - pledgeLvl;
        float cd = diff / 5000.0f;
        cd = MathHelper.func_76131_a((float)cd, (float)0.0f, (float)1.0f);
        int cdTicks = 36000;
        this.setPledgeFaction(null);
        this.setBrokenPledgeFaction(wasPledgedTo);
        this.setPledgeBreakCooldown(cdTicks += Math.round(cd * 150.0f * 60.0f * 20.0f));
        FactionRank rank = wasPledgedTo.getRankFor(prevAlign);
        FactionRank rank2Below = wasPledgedTo.getRankNBelow(rank, 2);
        float newAlign = rank2Below.getAlignment();
        newAlign = Math.max(newAlign, pledgeLvl / 2.0f);
        float alignPenalty = newAlign - prevAlign;
        if (alignPenalty < 0.0f) {
            this.addAlignment(wasPledgedTo, alignPenalty);
        }
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), LOTRSoundEvents.UNPLEDGE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (intentional) {
            TranslationTextComponent msg = new TranslationTextComponent("chat.lotr.pledge.break.intentional", new Object[]{wasPledgedTo.getDisplayName()});
            LOTRUtil.sendMessage(player, (ITextComponent)msg);
        } else {
            TranslationTextComponent msg = new TranslationTextComponent("chat.lotr.pledge.break.unintentional", new Object[]{wasPledgedTo.getDisplayName()});
            LOTRUtil.sendMessage(player, (ITextComponent)msg);
        }
    }

    public void onPledgeKill(PlayerEntity player) {
        this.pledgeKillCooldown += 24000;
        this.markDirty();
        if (this.pledgeKillCooldown > 24000) {
            this.revokePledgeFaction(player, false);
        } else if (this.pledgeFaction != null) {
            TranslationTextComponent msg = new TranslationTextComponent("chat.lotr.pledge.killWarn", new Object[]{this.pledgeFaction.getDisplayName()});
            LOTRUtil.sendMessage(player, (ITextComponent)msg);
        }
    }

    public int getPledgeBreakCooldown() {
        return this.pledgeBreakCooldown;
    }

    public void setPledgeBreakCooldown(int i) {
        boolean bigChange;
        int preCD = this.pledgeBreakCooldown;
        Faction preBroken = this.brokenPledgeFaction;
        this.pledgeBreakCooldown = i = Math.max(0, i);
        boolean bl = bigChange = (this.pledgeBreakCooldown == 0 || preCD == 0) && this.pledgeBreakCooldown != preCD;
        if (this.pledgeBreakCooldown > this.pledgeBreakCooldownStart) {
            this.setPledgeBreakCooldownStart(this.pledgeBreakCooldown);
            bigChange = true;
        }
        if (this.pledgeBreakCooldown <= 0 && preBroken != null) {
            this.setPledgeBreakCooldownStart(0);
            this.setBrokenPledgeFaction(null);
            bigChange = true;
        }
        if (bigChange || AlignmentDataModule.isTimerAutosaveTick()) {
            this.markDirty();
        }
        if (bigChange || this.pledgeBreakCooldown % 5 == 0) {
            this.sendPacketToClient(new SPacketPledgeBreak(this.pledgeBreakCooldown, this.pledgeBreakCooldownStart, this.brokenPledgeFaction));
        }
        if (this.pledgeBreakCooldown == 0 && preCD != this.pledgeBreakCooldown) {
            this.executeIfPlayerExistsServerside(player -> {
                TranslationTextComponent msg = new TranslationTextComponent("chat.lotr.pledge.breakCooldown", new Object[]{Faction.getFactionOrUnknownDisplayName(preBroken)});
                LOTRUtil.sendMessage((PlayerEntity)player, (ITextComponent)msg);
            });
        }
    }

    public int getPledgeBreakCooldownStart() {
        return this.pledgeBreakCooldownStart;
    }

    public void setPledgeBreakCooldownStart(int i) {
        this.pledgeBreakCooldownStart = i;
        this.markDirty();
    }

    public float getPledgeBreakCooldownFraction() {
        if (this.pledgeBreakCooldownStart == 0) {
            return 0.0f;
        }
        return (float)this.pledgeBreakCooldown / (float)this.pledgeBreakCooldownStart;
    }

    public Faction getBrokenPledgeFaction() {
        return this.brokenPledgeFaction;
    }

    public void setBrokenPledgeFaction(Faction f) {
        this.brokenPledgeFaction = f;
        this.markDirty();
    }

    public boolean isPledgeEnemyAlignmentLimited(Faction faction) {
        return this.pledgeFaction != null && this.doesFactionPreventPledge(this.pledgeFaction, faction);
    }

    public float getPledgeEnemyAlignmentLimit(Faction faction) {
        return 0.0f;
    }

    private void runAlignmentDraining(ServerPlayerEntity player, int tick) {
        if (((Boolean)LOTRConfig.COMMON.alignmentDraining.get()).booleanValue() && tick % 1000 == 0) {
            float drainLimit = 0.0f;
            ArrayList<Faction> drainFactions = new ArrayList<Faction>();
            List<Faction> allFacs = this.currentFactionSettings().getAllPlayableAlignmentFactions();
            for (Faction fac1 : allFacs) {
                for (Faction fac2 : allFacs) {
                    if (!this.doFactionsDrain(fac1, fac2)) continue;
                    float align1 = this.getAlignment(fac1);
                    float align2 = this.getAlignment(fac2);
                    if (!(align1 > 0.0f) || !(align2 > 0.0f)) continue;
                    if (!drainFactions.contains(fac1)) {
                        drainFactions.add(fac1);
                    }
                    if (drainFactions.contains(fac2)) continue;
                    drainFactions.add(fac2);
                }
            }
            if (!drainFactions.isEmpty()) {
                for (Faction fac : drainFactions) {
                    float align = this.getAlignment(fac);
                    float alignLoss = 5.0f;
                    alignLoss = Math.min(alignLoss, align - 0.0f);
                    this.setAlignment(fac, align -= alignLoss);
                }
                LOTRPacketHandler.sendTo(new SPacketAlignmentDrain(drainFactions.size()), player);
                this.playerData.getMessageData().sendMessageIfNotReceived(PlayerMessageType.ALIGN_DRAIN);
            }
        }
    }

    private boolean doFactionsDrain(Faction fac1, Faction fac2) {
        return fac1.isMortalEnemy(fac2);
    }

    public boolean isFriendlyFireEnabled() {
        return this.friendlyFire;
    }

    public void setFriendlyFireEnabled(boolean flag) {
        if (this.friendlyFire != flag) {
            this.friendlyFire = flag;
            this.markDirty();
            this.sendPacketToClient(new SPacketToggle(SidedTogglePacket.ToggleType.FRIENDLY_FIRE, this.friendlyFire));
        }
    }

    public void toggleFriendlyFireEnabledAndSendToServer() {
        this.friendlyFire = !this.friendlyFire;
        LOTRPacketHandler.sendToServer(new CPacketToggle(SidedTogglePacket.ToggleType.FRIENDLY_FIRE, this.friendlyFire));
    }
}

