/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lotr.common.LOTRLog;
import lotr.common.fac.FactionPointer;
import lotr.common.util.TriConsumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import org.apache.commons.lang3.tuple.Pair;

public class DataUtil {
    public static <T> T getIfNBTContains(T currentValue, CompoundNBT nbt, String key, BiFunction<CompoundNBT, String, T> nbtGetter) {
        if (nbt.func_74764_b(key)) {
            return nbtGetter.apply(nbt, key);
        }
        return currentValue;
    }

    public static UUID getUniqueIdBackCompat(CompoundNBT nbt, String key) {
        try {
            return nbt.func_186857_a(key);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            if (DataUtil.hasOldUniqueId(nbt, key)) {
                return new UUID(nbt.func_74763_f(key + "Most"), nbt.func_74763_f(key + "Least"));
            }
            throw e;
        }
    }

    private static boolean hasOldUniqueId(CompoundNBT nbt, String key) {
        return nbt.func_150297_b(key + "Most", 4) && nbt.func_150297_b(key + "Least", 4);
    }

    public static boolean hasUniqueIdBackCompat(CompoundNBT nbt, String key) {
        return nbt.func_186855_b(key) || DataUtil.hasOldUniqueId(nbt, key);
    }

    public static <T> ListNBT saveCollectionAsCompoundListNBT(Collection<T> collection, BiConsumer<CompoundNBT, T> elementToNbt) {
        ListNBT tagList = new ListNBT();
        for (T t : collection) {
            CompoundNBT nbt = new CompoundNBT();
            elementToNbt.accept(nbt, (CompoundNBT)t);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    public static <T, N extends INBT> ListNBT saveCollectionAsPrimitiveListNBT(Collection<T> collection, Function<T, N> elementToNbt) {
        ListNBT tagList = new ListNBT();
        for (T t : collection) {
            tagList.add(elementToNbt.apply(t));
        }
        return tagList;
    }

    public static <T> void loadCollectionFromCompoundListNBT(Collection<T> collection, ListNBT tagList, Function<CompoundNBT, T> nbtToElement) {
        collection.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbt = tagList.func_150305_b(i);
            T element = nbtToElement.apply(nbt);
            if (element == null) continue;
            collection.add(element);
        }
    }

    public static <T, P> void loadCollectionFromPrimitiveListNBT(Collection<T> collection, ListNBT tagList, BiFunction<ListNBT, Integer, P> listNbtToPrimitive, Function<P, T> primitiveToElement) {
        collection.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            P value = listNbtToPrimitive.apply(tagList, i);
            T element = primitiveToElement.apply(value);
            if (element == null) continue;
            collection.add(element);
        }
    }

    public static <K, V> ListNBT saveMapAsListNBT(Map<K, V> map, TriConsumer<CompoundNBT, K, V> entryToNbt) {
        ListNBT tagList = new ListNBT();
        for (Map.Entry<K, V> e : map.entrySet()) {
            K key = e.getKey();
            V value = e.getValue();
            CompoundNBT nbt = new CompoundNBT();
            entryToNbt.accept(nbt, key, value);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    public static <K, V> void loadMapFromListNBT(Map<K, V> map, ListNBT tagList, Function<CompoundNBT, Pair<K, V>> nbtToEntry) {
        map.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbt = tagList.func_150305_b(i);
            Pair<K, V> entry = nbtToEntry.apply(nbt);
            if (entry == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static void writeOptionalFactionPointerToNBT(CompoundNBT nbt, String key, Optional<FactionPointer> pointer) {
        if (pointer.isPresent()) {
            nbt.func_74778_a(key, pointer.get().getName().toString());
        }
    }

    public static Optional<FactionPointer> readOptionalFactionPointerFromNBT(CompoundNBT nbt, String key) {
        if (nbt.func_150297_b(key, 8)) {
            String facName = nbt.func_74779_i(key);
            try {
                return Optional.of(FactionPointer.of(new ResourceLocation(facName)));
            }
            catch (ResourceLocationException e) {
                LOTRLog.error("Invalid %s name %s", key, facName);
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    public static <T> void writeCollectionToBuffer(PacketBuffer buf, Collection<T> collection, Consumer<T> elementToBuffer) {
        buf.func_150787_b(collection.size());
        collection.forEach(elementToBuffer);
    }

    public static <T> void fillCollectionFromBuffer(PacketBuffer buf, Collection<T> collection, Supplier<T> bufferToElement) {
        collection.clear();
        int collectionSize = buf.func_150792_a();
        for (int i = 0; i < collectionSize; ++i) {
            T element = bufferToElement.get();
            if (element == null) continue;
            collection.add(element);
        }
    }

    public static <T, C extends Collection<T>> C readNewCollectionFromBuffer(PacketBuffer buf, Supplier<C> collectionSupplier, Supplier<T> bufferToElement) {
        Collection collection = (Collection)collectionSupplier.get();
        DataUtil.fillCollectionFromBuffer(buf, collection, bufferToElement);
        return (C)collection;
    }

    public static <K, V> void writeMapToBuffer(PacketBuffer buf, Map<K, V> map, BiConsumer<K, V> entryToBuffer) {
        buf.func_150787_b(map.size());
        map.forEach(entryToBuffer);
    }

    public static <K, V> void fillMapFromBuffer(PacketBuffer buf, Map<K, V> map, Supplier<Pair<K, V>> bufferToEntry) {
        map.clear();
        int mapSize = buf.func_150792_a();
        for (int i = 0; i < mapSize; ++i) {
            Pair<K, V> entry = bufferToEntry.get();
            if (entry == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public static <K, V, M extends Map<K, V>> M readNewMapFromBuffer(PacketBuffer buf, Supplier<M> mapSupplier, Supplier<Pair<K, V>> bufferToEntry) {
        Map map = (Map)mapSupplier.get();
        DataUtil.fillMapFromBuffer(buf, map, bufferToEntry);
        return (M)map;
    }

    public static <T> void writeNullableToBuffer(PacketBuffer buf, T object, Runnable elementToBuffer) {
        boolean hasObject = object != null;
        buf.writeBoolean(hasObject);
        if (hasObject) {
            elementToBuffer.run();
        }
    }

    public static <T> void writeNullableToBuffer(PacketBuffer buf, T object, BiFunction<PacketBuffer, T, PacketBuffer> elementToBuffer) {
        DataUtil.writeNullableToBuffer(buf, object, () -> {
            PacketBuffer cfr_ignored_0 = (PacketBuffer)elementToBuffer.apply(buf, object);
        });
    }

    public static <T> void writeNullableToBuffer(PacketBuffer buf, T object, BiConsumer<T, PacketBuffer> elementToBuffer) {
        DataUtil.writeNullableToBuffer(buf, object, () -> elementToBuffer.accept(object, buf));
    }

    public static <T> T readNullableFromBuffer(PacketBuffer buf, Supplier<T> bufferToObject) {
        boolean hasObject = buf.readBoolean();
        if (hasObject) {
            return bufferToObject.get();
        }
        return null;
    }
}

