/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import java.util.HashMap;
import java.util.Map;
import lotr.common.LOTRLog;
import lotr.common.data.DataUtil;
import lotr.common.data.FactionStats;
import lotr.common.data.LOTRPlayerData;
import lotr.common.data.PlayerDataModule;
import lotr.common.fac.Faction;
import lotr.common.network.SPacketFactionStats;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class FactionStatsDataModule
extends PlayerDataModule {
    private final Map<Faction, FactionStats> factionStatsMap = new HashMap<Faction, FactionStats>();

    protected FactionStatsDataModule(LOTRPlayerData pd) {
        super(pd);
    }

    @Override
    public void save(CompoundNBT playerNBT) {
        playerNBT.func_218657_a("FactionStats", (INBT)DataUtil.saveMapAsListNBT(this.factionStatsMap, (nbt, fac, stats) -> {
            nbt.func_74778_a("Faction", fac.getName().toString());
            stats.save((CompoundNBT)nbt);
        }));
    }

    @Override
    public void load(CompoundNBT playerNBT) {
        DataUtil.loadMapFromListNBT(this.factionStatsMap, playerNBT.func_150295_c("FactionStats", 10), nbt -> {
            ResourceLocation facName = new ResourceLocation(nbt.func_74779_i("Faction"));
            Faction fac = this.currentFactionSettings().getFactionByName(facName);
            if (fac != null) {
                FactionStats stats = new FactionStats(this, fac);
                stats.load((CompoundNBT)nbt);
                return Pair.of((Object)fac, (Object)stats);
            }
            this.playerData.logPlayerError("Loaded faction stats for nonexistent faction %s", facName);
            return null;
        });
    }

    @Override
    protected void sendLoginData(PacketBuffer buf) {
        DataUtil.writeMapToBuffer(buf, this.factionStatsMap, (faction, stats) -> {
            buf.func_150787_b(faction.getAssignedId());
            stats.write(buf);
        });
    }

    @Override
    protected void receiveLoginData(PacketBuffer buf) {
        DataUtil.fillMapFromBuffer(buf, this.factionStatsMap, () -> {
            int factionId = buf.func_150792_a();
            Faction faction = this.currentFactionSettings().getFactionByID(factionId);
            if (faction == null) {
                LOTRLog.warn("Received faction stats for nonexistent faction ID %d from server", factionId);
                return null;
            }
            FactionStats stats = new FactionStats(this, faction);
            stats.read(buf);
            return Pair.of((Object)faction, (Object)stats);
        });
    }

    public FactionStats getFactionStats(Faction faction) {
        return this.factionStatsMap.computeIfAbsent(faction, f -> new FactionStats(this, (Faction)f));
    }

    protected void updateFactionData(Faction faction) {
        this.markDirty();
        this.sendPacketToClient(new SPacketFactionStats(faction, this.getFactionStats(faction)));
    }
}

