/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.data;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.SPacketPlayerMessage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public enum PlayerMessageType {
    FRIENDLY_FIRE("friendly_fire"),
    ALIGN_DRAIN("align_drain"),
    CUSTOM("custom");

    private final String messageName;
    public final int networkID;

    private PlayerMessageType(String s) {
        this.messageName = s;
        this.networkID = this.ordinal();
    }

    public ITextComponent getDisplayMessage() {
        return new TranslationTextComponent("gui.lotr.message." + this.messageName);
    }

    public void displayTo(ServerPlayerEntity player, boolean isCommandSent) {
        LOTRPacketHandler.sendTo(new SPacketPlayerMessage(this, isCommandSent, null), player);
    }

    public static void displayCustomMessageTo(ServerPlayerEntity player, boolean isCommandSent, String customText) {
        LOTRPacketHandler.sendTo(new SPacketPlayerMessage(CUSTOM, isCommandSent, customText), player);
    }

    public String getSaveName() {
        return this.messageName;
    }

    public static List<String> getAllPresetNamesForCommand() {
        return Stream.of(PlayerMessageType.values()).filter(type -> type != CUSTOM).map(PlayerMessageType::getSaveName).collect(Collectors.toList());
    }

    public static PlayerMessageType forSaveName(String name) {
        for (PlayerMessageType message : PlayerMessageType.values()) {
            if (!message.getSaveName().equals(name)) continue;
            return message;
        }
        return null;
    }

    public static PlayerMessageType forNetworkID(int id) {
        for (PlayerMessageType message : PlayerMessageType.values()) {
            if (message.networkID != id) continue;
            return message;
        }
        return null;
    }
}

