/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.item;

import java.util.function.Supplier;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTREntities;
import lotr.common.init.LOTRItems;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class LOTRBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> MOD_BOAT_TYPE = EntityDataManager.func_187226_a(LOTRBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public LOTRBoatEntity(EntityType<? extends LOTRBoatEntity> type, World w) {
        super(type, w);
        this.field_70156_m = true;
    }

    public LOTRBoatEntity(World w, double x, double y, double z) {
        this((EntityType<? extends LOTRBoatEntity>)((EntityType)LOTREntities.BOAT.get()), w);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOD_BOAT_TYPE, (Object)ModBoatType.PINE.ordinal());
    }

    public void setModBoatType(ModBoatType type) {
        this.field_70180_af.func_187227_b(MOD_BOAT_TYPE, (Object)type.ordinal());
    }

    public ModBoatType getModBoatType() {
        return ModBoatType.byId((Integer)this.field_70180_af.func_187225_a(MOD_BOAT_TYPE));
    }

    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a("ModType", this.getModBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("ModType", 8)) {
            this.setModBoatType(ModBoatType.getTypeFromString(nbt.func_74779_i("ModType")));
        }
    }

    public Item func_184455_j() {
        return this.getModBoatType().asBoatItem();
    }

    public ItemEntity func_199703_a(IItemProvider item) {
        if (item == this.func_184453_r().func_195933_b()) {
            item = this.getModBoatType().asPlank();
        }
        return super.func_199703_a(item);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum ModBoatType {
        PINE((Supplier<Block>)LOTRBlocks.PINE_PLANKS, (Supplier<Item>)LOTRItems.PINE_BOAT, "pine"),
        MALLORN((Supplier<Block>)LOTRBlocks.MALLORN_PLANKS, (Supplier<Item>)LOTRItems.MALLORN_BOAT, "mallorn"),
        MIRK_OAK((Supplier<Block>)LOTRBlocks.MIRK_OAK_PLANKS, (Supplier<Item>)LOTRItems.MIRK_OAK_BOAT, "mirk_oak"),
        CHARRED((Supplier<Block>)LOTRBlocks.CHARRED_PLANKS, (Supplier<Item>)LOTRItems.CHARRED_BOAT, "charred"),
        APPLE((Supplier<Block>)LOTRBlocks.APPLE_PLANKS, (Supplier<Item>)LOTRItems.APPLE_BOAT, "apple"),
        PEAR((Supplier<Block>)LOTRBlocks.PEAR_PLANKS, (Supplier<Item>)LOTRItems.PEAR_BOAT, "pear"),
        CHERRY((Supplier<Block>)LOTRBlocks.CHERRY_PLANKS, (Supplier<Item>)LOTRItems.CHERRY_BOAT, "cherry"),
        LEBETHRON((Supplier<Block>)LOTRBlocks.LEBETHRON_PLANKS, (Supplier<Item>)LOTRItems.LEBETHRON_BOAT, "lebethron"),
        BEECH((Supplier<Block>)LOTRBlocks.BEECH_PLANKS, (Supplier<Item>)LOTRItems.BEECH_BOAT, "beech"),
        MAPLE((Supplier<Block>)LOTRBlocks.MAPLE_PLANKS, (Supplier<Item>)LOTRItems.MAPLE_BOAT, "maple"),
        ASPEN((Supplier<Block>)LOTRBlocks.ASPEN_PLANKS, (Supplier<Item>)LOTRItems.ASPEN_BOAT, "aspen"),
        LAIRELOSSE((Supplier<Block>)LOTRBlocks.LAIRELOSSE_PLANKS, (Supplier<Item>)LOTRItems.LAIRELOSSE_BOAT, "lairelosse"),
        CEDAR((Supplier<Block>)LOTRBlocks.CEDAR_PLANKS, (Supplier<Item>)LOTRItems.CEDAR_BOAT, "cedar"),
        FIR((Supplier<Block>)LOTRBlocks.FIR_PLANKS, (Supplier<Item>)LOTRItems.FIR_BOAT, "fir"),
        LARCH((Supplier<Block>)LOTRBlocks.LARCH_PLANKS, (Supplier<Item>)LOTRItems.LARCH_BOAT, "larch"),
        HOLLY((Supplier<Block>)LOTRBlocks.HOLLY_PLANKS, (Supplier<Item>)LOTRItems.HOLLY_BOAT, "holly"),
        GREEN_OAK((Supplier<Block>)LOTRBlocks.GREEN_OAK_PLANKS, (Supplier<Item>)LOTRItems.GREEN_OAK_BOAT, "green_oak"),
        CYPRESS((Supplier<Block>)LOTRBlocks.CYPRESS_PLANKS, (Supplier<Item>)LOTRItems.CYPRESS_BOAT, "cypress"),
        ROTTEN((Supplier<Block>)LOTRBlocks.ROTTEN_PLANKS, (Supplier<Item>)LOTRItems.ROTTEN_BOAT, "rotten");

        private final Supplier<Block> plankSup;
        private final Supplier<Item> boatSup;
        private final String name;

        private ModBoatType(Supplier<Block> plank, Supplier<Item> boat, String s) {
            this.plankSup = plank;
            this.boatSup = boat;
            this.name = s;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.plankSup.get();
        }

        public Item asBoatItem() {
            return this.boatSup.get();
        }

        public String toString() {
            return this.name;
        }

        public static ModBoatType byId(int id) {
            ModBoatType[] types = ModBoatType.values();
            if (id < 0 || id >= types.length) {
                id = 0;
            }
            return types[id];
        }

        public static ModBoatType getTypeFromString(String nameIn) {
            ModBoatType[] types = ModBoatType.values();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].getName().equals(nameIn)) continue;
                return types[i];
            }
            return types[0];
        }
    }
}

